/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListTargetHttpsProxiesRequest;
import com.google.cloud.compute.v1.DeleteTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.GetTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.InsertTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.ListTargetHttpsProxiesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.SetCertificateMapTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.SetQuicOverrideTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.SetSslCertificatesTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.SetSslPolicyTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.SetUrlMapTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.TargetHttpsProxiesClient;
import com.google.cloud.compute.v1.TargetHttpsProxiesScopedList;
import com.google.cloud.compute.v1.TargetHttpsProxy;
import com.google.cloud.compute.v1.TargetHttpsProxyAggregatedList;
import com.google.cloud.compute.v1.TargetHttpsProxyList;
import com.google.cloud.compute.v1.stub.HttpJsonTargetHttpsProxiesStub;
import com.google.cloud.compute.v1.stub.TargetHttpsProxiesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class TargetHttpsProxiesStubSettings
extends StubSettings<TargetHttpsProxiesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteTargetHttpsProxyRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteTargetHttpsProxyRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetTargetHttpsProxyRequest, TargetHttpsProxy> getSettings;
    private final UnaryCallSettings<InsertTargetHttpsProxyRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertTargetHttpsProxyRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxiesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PatchTargetHttpsProxyRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchTargetHttpsProxyRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<SetCertificateMapTargetHttpsProxyRequest, Operation> setCertificateMapSettings;
    private final OperationCallSettings<SetCertificateMapTargetHttpsProxyRequest, Operation, Operation> setCertificateMapOperationSettings;
    private final UnaryCallSettings<SetQuicOverrideTargetHttpsProxyRequest, Operation> setQuicOverrideSettings;
    private final OperationCallSettings<SetQuicOverrideTargetHttpsProxyRequest, Operation, Operation> setQuicOverrideOperationSettings;
    private final UnaryCallSettings<SetSslCertificatesTargetHttpsProxyRequest, Operation> setSslCertificatesSettings;
    private final OperationCallSettings<SetSslCertificatesTargetHttpsProxyRequest, Operation, Operation> setSslCertificatesOperationSettings;
    private final UnaryCallSettings<SetSslPolicyTargetHttpsProxyRequest, Operation> setSslPolicySettings;
    private final OperationCallSettings<SetSslPolicyTargetHttpsProxyRequest, Operation, Operation> setSslPolicyOperationSettings;
    private final UnaryCallSettings<SetUrlMapTargetHttpsProxyRequest, Operation> setUrlMapSettings;
    private final OperationCallSettings<SetUrlMapTargetHttpsProxyRequest, Operation, Operation> setUrlMapOperationSettings;
    private static final PagedListDescriptor<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, Map.Entry<String, TargetHttpsProxiesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, Map.Entry<String, TargetHttpsProxiesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListTargetHttpsProxiesRequest injectToken(AggregatedListTargetHttpsProxiesRequest payload, String token) {
            return AggregatedListTargetHttpsProxiesRequest.newBuilder((AggregatedListTargetHttpsProxiesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListTargetHttpsProxiesRequest injectPageSize(AggregatedListTargetHttpsProxiesRequest payload, int pageSize) {
            return AggregatedListTargetHttpsProxiesRequest.newBuilder((AggregatedListTargetHttpsProxiesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListTargetHttpsProxiesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetHttpsProxyAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, TargetHttpsProxiesScopedList>> extractResources(TargetHttpsProxyAggregatedList payload) {
            return payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy>(){

        public String emptyToken() {
            return "";
        }

        public ListTargetHttpsProxiesRequest injectToken(ListTargetHttpsProxiesRequest payload, String token) {
            return ListTargetHttpsProxiesRequest.newBuilder((ListTargetHttpsProxiesRequest)payload).setPageToken(token).build();
        }

        public ListTargetHttpsProxiesRequest injectPageSize(ListTargetHttpsProxiesRequest payload, int pageSize) {
            return ListTargetHttpsProxiesRequest.newBuilder((ListTargetHttpsProxiesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListTargetHttpsProxiesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetHttpsProxyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetHttpsProxy> extractResources(TargetHttpsProxyList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesClient.AggregatedListPagedResponse>(){

        public ApiFuture<TargetHttpsProxiesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList> callable, AggregatedListTargetHttpsProxiesRequest request, ApiCallContext context, ApiFuture<TargetHttpsProxyAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetHttpsProxiesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, Map.Entry<String, TargetHttpsProxiesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxiesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxiesClient.ListPagedResponse>(){

        public ApiFuture<TargetHttpsProxiesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListTargetHttpsProxiesRequest, TargetHttpsProxyList> callable, ListTargetHttpsProxiesRequest request, ApiCallContext context, ApiFuture<TargetHttpsProxyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetHttpsProxiesClient.ListPagedResponse.createAsync((PageContext<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteTargetHttpsProxyRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteTargetHttpsProxyRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetTargetHttpsProxyRequest, TargetHttpsProxy> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertTargetHttpsProxyRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertTargetHttpsProxyRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxiesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PatchTargetHttpsProxyRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchTargetHttpsProxyRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<SetCertificateMapTargetHttpsProxyRequest, Operation> setCertificateMapSettings() {
        return this.setCertificateMapSettings;
    }

    public OperationCallSettings<SetCertificateMapTargetHttpsProxyRequest, Operation, Operation> setCertificateMapOperationSettings() {
        return this.setCertificateMapOperationSettings;
    }

    public UnaryCallSettings<SetQuicOverrideTargetHttpsProxyRequest, Operation> setQuicOverrideSettings() {
        return this.setQuicOverrideSettings;
    }

    public OperationCallSettings<SetQuicOverrideTargetHttpsProxyRequest, Operation, Operation> setQuicOverrideOperationSettings() {
        return this.setQuicOverrideOperationSettings;
    }

    public UnaryCallSettings<SetSslCertificatesTargetHttpsProxyRequest, Operation> setSslCertificatesSettings() {
        return this.setSslCertificatesSettings;
    }

    public OperationCallSettings<SetSslCertificatesTargetHttpsProxyRequest, Operation, Operation> setSslCertificatesOperationSettings() {
        return this.setSslCertificatesOperationSettings;
    }

    public UnaryCallSettings<SetSslPolicyTargetHttpsProxyRequest, Operation> setSslPolicySettings() {
        return this.setSslPolicySettings;
    }

    public OperationCallSettings<SetSslPolicyTargetHttpsProxyRequest, Operation, Operation> setSslPolicyOperationSettings() {
        return this.setSslPolicyOperationSettings;
    }

    public UnaryCallSettings<SetUrlMapTargetHttpsProxyRequest, Operation> setUrlMapSettings() {
        return this.setUrlMapSettings;
    }

    public OperationCallSettings<SetUrlMapTargetHttpsProxyRequest, Operation, Operation> setUrlMapOperationSettings() {
        return this.setUrlMapOperationSettings;
    }

    public TargetHttpsProxiesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTargetHttpsProxiesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TargetHttpsProxiesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TargetHttpsProxiesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TargetHttpsProxiesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.setCertificateMapSettings = settingsBuilder.setCertificateMapSettings().build();
        this.setCertificateMapOperationSettings = settingsBuilder.setCertificateMapOperationSettings().build();
        this.setQuicOverrideSettings = settingsBuilder.setQuicOverrideSettings().build();
        this.setQuicOverrideOperationSettings = settingsBuilder.setQuicOverrideOperationSettings().build();
        this.setSslCertificatesSettings = settingsBuilder.setSslCertificatesSettings().build();
        this.setSslCertificatesOperationSettings = settingsBuilder.setSslCertificatesOperationSettings().build();
        this.setSslPolicySettings = settingsBuilder.setSslPolicySettings().build();
        this.setSslPolicyOperationSettings = settingsBuilder.setSslPolicyOperationSettings().build();
        this.setUrlMapSettings = settingsBuilder.setUrlMapSettings().build();
        this.setUrlMapOperationSettings = settingsBuilder.setUrlMapOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TargetHttpsProxiesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteTargetHttpsProxyRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteTargetHttpsProxyRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetTargetHttpsProxyRequest, TargetHttpsProxy> getSettings;
        private final UnaryCallSettings.Builder<InsertTargetHttpsProxyRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertTargetHttpsProxyRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxiesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PatchTargetHttpsProxyRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchTargetHttpsProxyRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<SetCertificateMapTargetHttpsProxyRequest, Operation> setCertificateMapSettings;
        private final OperationCallSettings.Builder<SetCertificateMapTargetHttpsProxyRequest, Operation, Operation> setCertificateMapOperationSettings;
        private final UnaryCallSettings.Builder<SetQuicOverrideTargetHttpsProxyRequest, Operation> setQuicOverrideSettings;
        private final OperationCallSettings.Builder<SetQuicOverrideTargetHttpsProxyRequest, Operation, Operation> setQuicOverrideOperationSettings;
        private final UnaryCallSettings.Builder<SetSslCertificatesTargetHttpsProxyRequest, Operation> setSslCertificatesSettings;
        private final OperationCallSettings.Builder<SetSslCertificatesTargetHttpsProxyRequest, Operation, Operation> setSslCertificatesOperationSettings;
        private final UnaryCallSettings.Builder<SetSslPolicyTargetHttpsProxyRequest, Operation> setSslPolicySettings;
        private final OperationCallSettings.Builder<SetSslPolicyTargetHttpsProxyRequest, Operation, Operation> setSslPolicyOperationSettings;
        private final UnaryCallSettings.Builder<SetUrlMapTargetHttpsProxyRequest, Operation> setUrlMapSettings;
        private final OperationCallSettings.Builder<SetUrlMapTargetHttpsProxyRequest, Operation, Operation> setUrlMapOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.setCertificateMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setCertificateMapOperationSettings = OperationCallSettings.newBuilder();
            this.setQuicOverrideSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setQuicOverrideOperationSettings = OperationCallSettings.newBuilder();
            this.setSslCertificatesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSslCertificatesOperationSettings = OperationCallSettings.newBuilder();
            this.setSslPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSslPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.setUrlMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setUrlMapOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.patchSettings, this.setCertificateMapSettings, this.setQuicOverrideSettings, this.setSslCertificatesSettings, this.setSslPolicySettings, this.setUrlMapSettings);
            Builder.initDefaults(this);
        }

        protected Builder(TargetHttpsProxiesStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.setCertificateMapSettings = settings.setCertificateMapSettings.toBuilder();
            this.setCertificateMapOperationSettings = settings.setCertificateMapOperationSettings.toBuilder();
            this.setQuicOverrideSettings = settings.setQuicOverrideSettings.toBuilder();
            this.setQuicOverrideOperationSettings = settings.setQuicOverrideOperationSettings.toBuilder();
            this.setSslCertificatesSettings = settings.setSslCertificatesSettings.toBuilder();
            this.setSslCertificatesOperationSettings = settings.setSslCertificatesOperationSettings.toBuilder();
            this.setSslPolicySettings = settings.setSslPolicySettings.toBuilder();
            this.setSslPolicyOperationSettings = settings.setSslPolicyOperationSettings.toBuilder();
            this.setUrlMapSettings = settings.setUrlMapSettings.toBuilder();
            this.setUrlMapOperationSettings = settings.setUrlMapOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.patchSettings, this.setCertificateMapSettings, this.setQuicOverrideSettings, this.setSslCertificatesSettings, this.setSslPolicySettings, this.setUrlMapSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TargetHttpsProxiesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TargetHttpsProxiesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TargetHttpsProxiesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TargetHttpsProxiesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setCertificateMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setQuicOverrideSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setSslCertificatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setSslPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setUrlMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setCertificateMapOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setQuicOverrideOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setSslCertificatesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setSslPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setUrlMapOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListTargetHttpsProxiesRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteTargetHttpsProxyRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteTargetHttpsProxyRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetTargetHttpsProxyRequest, TargetHttpsProxy> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertTargetHttpsProxyRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertTargetHttpsProxyRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxiesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PatchTargetHttpsProxyRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchTargetHttpsProxyRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<SetCertificateMapTargetHttpsProxyRequest, Operation> setCertificateMapSettings() {
            return this.setCertificateMapSettings;
        }

        public OperationCallSettings.Builder<SetCertificateMapTargetHttpsProxyRequest, Operation, Operation> setCertificateMapOperationSettings() {
            return this.setCertificateMapOperationSettings;
        }

        public UnaryCallSettings.Builder<SetQuicOverrideTargetHttpsProxyRequest, Operation> setQuicOverrideSettings() {
            return this.setQuicOverrideSettings;
        }

        public OperationCallSettings.Builder<SetQuicOverrideTargetHttpsProxyRequest, Operation, Operation> setQuicOverrideOperationSettings() {
            return this.setQuicOverrideOperationSettings;
        }

        public UnaryCallSettings.Builder<SetSslCertificatesTargetHttpsProxyRequest, Operation> setSslCertificatesSettings() {
            return this.setSslCertificatesSettings;
        }

        public OperationCallSettings.Builder<SetSslCertificatesTargetHttpsProxyRequest, Operation, Operation> setSslCertificatesOperationSettings() {
            return this.setSslCertificatesOperationSettings;
        }

        public UnaryCallSettings.Builder<SetSslPolicyTargetHttpsProxyRequest, Operation> setSslPolicySettings() {
            return this.setSslPolicySettings;
        }

        public OperationCallSettings.Builder<SetSslPolicyTargetHttpsProxyRequest, Operation, Operation> setSslPolicyOperationSettings() {
            return this.setSslPolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<SetUrlMapTargetHttpsProxyRequest, Operation> setUrlMapSettings() {
            return this.setUrlMapSettings;
        }

        public OperationCallSettings.Builder<SetUrlMapTargetHttpsProxyRequest, Operation, Operation> setUrlMapOperationSettings() {
            return this.setUrlMapOperationSettings;
        }

        public TargetHttpsProxiesStubSettings build() throws IOException {
            return new TargetHttpsProxiesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

