/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddPeeringNetworkRequest;
import com.google.cloud.compute.v1.DeleteNetworkRequest;
import com.google.cloud.compute.v1.ExchangedPeeringRoute;
import com.google.cloud.compute.v1.ExchangedPeeringRoutesList;
import com.google.cloud.compute.v1.GetEffectiveFirewallsNetworkRequest;
import com.google.cloud.compute.v1.GetNetworkRequest;
import com.google.cloud.compute.v1.InsertNetworkRequest;
import com.google.cloud.compute.v1.ListNetworksRequest;
import com.google.cloud.compute.v1.ListPeeringRoutesNetworksRequest;
import com.google.cloud.compute.v1.Network;
import com.google.cloud.compute.v1.NetworkList;
import com.google.cloud.compute.v1.NetworksAddPeeringRequest;
import com.google.cloud.compute.v1.NetworksGetEffectiveFirewallsResponse;
import com.google.cloud.compute.v1.NetworksRemovePeeringRequest;
import com.google.cloud.compute.v1.NetworksSettings;
import com.google.cloud.compute.v1.NetworksUpdatePeeringRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchNetworkRequest;
import com.google.cloud.compute.v1.RemovePeeringNetworkRequest;
import com.google.cloud.compute.v1.SwitchToCustomModeNetworkRequest;
import com.google.cloud.compute.v1.UpdatePeeringNetworkRequest;
import com.google.cloud.compute.v1.stub.NetworksStub;
import com.google.cloud.compute.v1.stub.NetworksStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class NetworksClient
implements BackgroundResource {
    private final NetworksSettings settings;
    private final NetworksStub stub;

    public static final NetworksClient create() throws IOException {
        return NetworksClient.create(NetworksSettings.newBuilder().build());
    }

    public static final NetworksClient create(NetworksSettings settings) throws IOException {
        return new NetworksClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final NetworksClient create(NetworksStub stub) {
        return new NetworksClient(stub);
    }

    protected NetworksClient(NetworksSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NetworksStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected NetworksClient(NetworksStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final NetworksSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NetworksStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> addPeeringAsync(String project, String network, NetworksAddPeeringRequest networksAddPeeringRequestResource) {
        AddPeeringNetworkRequest request = AddPeeringNetworkRequest.newBuilder().setProject(project).setNetwork(network).setNetworksAddPeeringRequestResource(networksAddPeeringRequestResource).build();
        return this.addPeeringAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> addPeeringAsync(AddPeeringNetworkRequest request) {
        return this.addPeeringOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddPeeringNetworkRequest, Operation, Operation> addPeeringOperationCallable() {
        return this.stub.addPeeringOperationCallable();
    }

    public final UnaryCallable<AddPeeringNetworkRequest, Operation> addPeeringCallable() {
        return this.stub.addPeeringCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String network) {
        DeleteNetworkRequest request = DeleteNetworkRequest.newBuilder().setProject(project).setNetwork(network).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteNetworkRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNetworkRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteNetworkRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Network get(String project, String network) {
        GetNetworkRequest request = GetNetworkRequest.newBuilder().setProject(project).setNetwork(network).build();
        return this.get(request);
    }

    public final Network get(GetNetworkRequest request) {
        return (Network)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetNetworkRequest, Network> getCallable() {
        return this.stub.getCallable();
    }

    public final NetworksGetEffectiveFirewallsResponse getEffectiveFirewalls(String project, String network) {
        GetEffectiveFirewallsNetworkRequest request = GetEffectiveFirewallsNetworkRequest.newBuilder().setProject(project).setNetwork(network).build();
        return this.getEffectiveFirewalls(request);
    }

    public final NetworksGetEffectiveFirewallsResponse getEffectiveFirewalls(GetEffectiveFirewallsNetworkRequest request) {
        return (NetworksGetEffectiveFirewallsResponse)this.getEffectiveFirewallsCallable().call((Object)request);
    }

    public final UnaryCallable<GetEffectiveFirewallsNetworkRequest, NetworksGetEffectiveFirewallsResponse> getEffectiveFirewallsCallable() {
        return this.stub.getEffectiveFirewallsCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, Network networkResource) {
        InsertNetworkRequest request = InsertNetworkRequest.newBuilder().setProject(project).setNetworkResource(networkResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertNetworkRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertNetworkRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertNetworkRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListNetworksRequest request = ListNetworksRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListNetworksRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNetworksRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListNetworksRequest, NetworkList> listCallable() {
        return this.stub.listCallable();
    }

    public final ListPeeringRoutesPagedResponse listPeeringRoutes(String project, String network) {
        ListPeeringRoutesNetworksRequest request = ListPeeringRoutesNetworksRequest.newBuilder().setProject(project).setNetwork(network).build();
        return this.listPeeringRoutes(request);
    }

    public final ListPeeringRoutesPagedResponse listPeeringRoutes(ListPeeringRoutesNetworksRequest request) {
        return (ListPeeringRoutesPagedResponse)((Object)this.listPeeringRoutesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPeeringRoutesNetworksRequest, ListPeeringRoutesPagedResponse> listPeeringRoutesPagedCallable() {
        return this.stub.listPeeringRoutesPagedCallable();
    }

    public final UnaryCallable<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList> listPeeringRoutesCallable() {
        return this.stub.listPeeringRoutesCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String network, Network networkResource) {
        PatchNetworkRequest request = PatchNetworkRequest.newBuilder().setProject(project).setNetwork(network).setNetworkResource(networkResource).build();
        return this.patchAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> patchAsync(PatchNetworkRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchNetworkRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchNetworkRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final OperationFuture<Operation, Operation> removePeeringAsync(String project, String network, NetworksRemovePeeringRequest networksRemovePeeringRequestResource) {
        RemovePeeringNetworkRequest request = RemovePeeringNetworkRequest.newBuilder().setProject(project).setNetwork(network).setNetworksRemovePeeringRequestResource(networksRemovePeeringRequestResource).build();
        return this.removePeeringAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> removePeeringAsync(RemovePeeringNetworkRequest request) {
        return this.removePeeringOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemovePeeringNetworkRequest, Operation, Operation> removePeeringOperationCallable() {
        return this.stub.removePeeringOperationCallable();
    }

    public final UnaryCallable<RemovePeeringNetworkRequest, Operation> removePeeringCallable() {
        return this.stub.removePeeringCallable();
    }

    public final OperationFuture<Operation, Operation> switchToCustomModeAsync(String project, String network) {
        SwitchToCustomModeNetworkRequest request = SwitchToCustomModeNetworkRequest.newBuilder().setProject(project).setNetwork(network).build();
        return this.switchToCustomModeAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> switchToCustomModeAsync(SwitchToCustomModeNetworkRequest request) {
        return this.switchToCustomModeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SwitchToCustomModeNetworkRequest, Operation, Operation> switchToCustomModeOperationCallable() {
        return this.stub.switchToCustomModeOperationCallable();
    }

    public final UnaryCallable<SwitchToCustomModeNetworkRequest, Operation> switchToCustomModeCallable() {
        return this.stub.switchToCustomModeCallable();
    }

    public final OperationFuture<Operation, Operation> updatePeeringAsync(String project, String network, NetworksUpdatePeeringRequest networksUpdatePeeringRequestResource) {
        UpdatePeeringNetworkRequest request = UpdatePeeringNetworkRequest.newBuilder().setProject(project).setNetwork(network).setNetworksUpdatePeeringRequestResource(networksUpdatePeeringRequestResource).build();
        return this.updatePeeringAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> updatePeeringAsync(UpdatePeeringNetworkRequest request) {
        return this.updatePeeringOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdatePeeringNetworkRequest, Operation, Operation> updatePeeringOperationCallable() {
        return this.stub.updatePeeringOperationCallable();
    }

    public final UnaryCallable<UpdatePeeringNetworkRequest, Operation> updatePeeringCallable() {
        return this.stub.updatePeeringCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListPeeringRoutesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, ExchangedPeeringRoute, ListPeeringRoutesPage, ListPeeringRoutesFixedSizeCollection> {
        private ListPeeringRoutesFixedSizeCollection(List<ListPeeringRoutesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPeeringRoutesFixedSizeCollection createEmptyCollection() {
            return new ListPeeringRoutesFixedSizeCollection(null, 0);
        }

        protected ListPeeringRoutesFixedSizeCollection createCollection(List<ListPeeringRoutesPage> pages, int collectionSize) {
            return new ListPeeringRoutesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPeeringRoutesPage
    extends AbstractPage<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, ExchangedPeeringRoute, ListPeeringRoutesPage> {
        private ListPeeringRoutesPage(PageContext<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, ExchangedPeeringRoute> context, ExchangedPeeringRoutesList response) {
            super(context, (Object)response);
        }

        private static ListPeeringRoutesPage createEmptyPage() {
            return new ListPeeringRoutesPage(null, null);
        }

        protected ListPeeringRoutesPage createPage(PageContext<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, ExchangedPeeringRoute> context, ExchangedPeeringRoutesList response) {
            return new ListPeeringRoutesPage(context, response);
        }

        public ApiFuture<ListPeeringRoutesPage> createPageAsync(PageContext<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, ExchangedPeeringRoute> context, ApiFuture<ExchangedPeeringRoutesList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPeeringRoutesPagedResponse
    extends AbstractPagedListResponse<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, ExchangedPeeringRoute, ListPeeringRoutesPage, ListPeeringRoutesFixedSizeCollection> {
        public static ApiFuture<ListPeeringRoutesPagedResponse> createAsync(PageContext<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, ExchangedPeeringRoute> context, ApiFuture<ExchangedPeeringRoutesList> futureResponse) {
            ApiFuture<ListPeeringRoutesPage> futurePage = ListPeeringRoutesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPeeringRoutesPagedResponse((ListPeeringRoutesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPeeringRoutesPagedResponse(ListPeeringRoutesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPeeringRoutesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNetworksRequest, NetworkList, Network, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListNetworksRequest, NetworkList, Network, ListPage> {
        private ListPage(PageContext<ListNetworksRequest, NetworkList, Network> context, NetworkList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListNetworksRequest, NetworkList, Network> context, NetworkList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListNetworksRequest, NetworkList, Network> context, ApiFuture<NetworkList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListNetworksRequest, NetworkList, Network, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListNetworksRequest, NetworkList, Network> context, ApiFuture<NetworkList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

