/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListTargetInstancesHttpRequest;
import com.google.cloud.compute.v1.DeleteTargetInstanceHttpRequest;
import com.google.cloud.compute.v1.GetTargetInstanceHttpRequest;
import com.google.cloud.compute.v1.InsertTargetInstanceHttpRequest;
import com.google.cloud.compute.v1.ListTargetInstancesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.TargetInstance;
import com.google.cloud.compute.v1.TargetInstanceAggregatedList;
import com.google.cloud.compute.v1.TargetInstanceClient;
import com.google.cloud.compute.v1.TargetInstanceList;
import com.google.cloud.compute.v1.TargetInstancesScopedList;
import com.google.cloud.compute.v1.stub.HttpJsonTargetInstanceStub;
import com.google.cloud.compute.v1.stub.TargetInstanceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class TargetInstanceStubSettings
extends StubSettings<TargetInstanceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList, TargetInstanceClient.AggregatedListTargetInstancesPagedResponse> aggregatedListTargetInstancesSettings;
    private final UnaryCallSettings<DeleteTargetInstanceHttpRequest, Operation> deleteTargetInstanceSettings;
    private final UnaryCallSettings<GetTargetInstanceHttpRequest, TargetInstance> getTargetInstanceSettings;
    private final UnaryCallSettings<InsertTargetInstanceHttpRequest, Operation> insertTargetInstanceSettings;
    private final PagedCallSettings<ListTargetInstancesHttpRequest, TargetInstanceList, TargetInstanceClient.ListTargetInstancesPagedResponse> listTargetInstancesSettings;
    private static final PagedListDescriptor<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList, TargetInstancesScopedList> AGGREGATED_LIST_TARGET_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList, TargetInstancesScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListTargetInstancesHttpRequest injectToken(AggregatedListTargetInstancesHttpRequest payload, String token) {
            return AggregatedListTargetInstancesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListTargetInstancesHttpRequest injectPageSize(AggregatedListTargetInstancesHttpRequest payload, int pageSize) {
            return AggregatedListTargetInstancesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListTargetInstancesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetInstanceAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetInstancesScopedList> extractResources(TargetInstanceAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListTargetInstancesHttpRequest, TargetInstanceList, TargetInstance> LIST_TARGET_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<ListTargetInstancesHttpRequest, TargetInstanceList, TargetInstance>(){

        public String emptyToken() {
            return "";
        }

        public ListTargetInstancesHttpRequest injectToken(ListTargetInstancesHttpRequest payload, String token) {
            return ListTargetInstancesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListTargetInstancesHttpRequest injectPageSize(ListTargetInstancesHttpRequest payload, int pageSize) {
            return ListTargetInstancesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListTargetInstancesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetInstanceList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetInstance> extractResources(TargetInstanceList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList, TargetInstanceClient.AggregatedListTargetInstancesPagedResponse> AGGREGATED_LIST_TARGET_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList, TargetInstanceClient.AggregatedListTargetInstancesPagedResponse>(){

        public ApiFuture<TargetInstanceClient.AggregatedListTargetInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList> callable, AggregatedListTargetInstancesHttpRequest request, ApiCallContext context, ApiFuture<TargetInstanceAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_TARGET_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetInstanceClient.AggregatedListTargetInstancesPagedResponse.createAsync((PageContext<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList, TargetInstancesScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTargetInstancesHttpRequest, TargetInstanceList, TargetInstanceClient.ListTargetInstancesPagedResponse> LIST_TARGET_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListTargetInstancesHttpRequest, TargetInstanceList, TargetInstanceClient.ListTargetInstancesPagedResponse>(){

        public ApiFuture<TargetInstanceClient.ListTargetInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTargetInstancesHttpRequest, TargetInstanceList> callable, ListTargetInstancesHttpRequest request, ApiCallContext context, ApiFuture<TargetInstanceList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TARGET_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetInstanceClient.ListTargetInstancesPagedResponse.createAsync((PageContext<ListTargetInstancesHttpRequest, TargetInstanceList, TargetInstance>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList, TargetInstanceClient.AggregatedListTargetInstancesPagedResponse> aggregatedListTargetInstancesSettings() {
        return this.aggregatedListTargetInstancesSettings;
    }

    public UnaryCallSettings<DeleteTargetInstanceHttpRequest, Operation> deleteTargetInstanceSettings() {
        return this.deleteTargetInstanceSettings;
    }

    public UnaryCallSettings<GetTargetInstanceHttpRequest, TargetInstance> getTargetInstanceSettings() {
        return this.getTargetInstanceSettings;
    }

    public UnaryCallSettings<InsertTargetInstanceHttpRequest, Operation> insertTargetInstanceSettings() {
        return this.insertTargetInstanceSettings;
    }

    public PagedCallSettings<ListTargetInstancesHttpRequest, TargetInstanceList, TargetInstanceClient.ListTargetInstancesPagedResponse> listTargetInstancesSettings() {
        return this.listTargetInstancesSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetInstanceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTargetInstanceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TargetInstanceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TargetInstanceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TargetInstanceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListTargetInstancesSettings = settingsBuilder.aggregatedListTargetInstancesSettings().build();
        this.deleteTargetInstanceSettings = settingsBuilder.deleteTargetInstanceSettings().build();
        this.getTargetInstanceSettings = settingsBuilder.getTargetInstanceSettings().build();
        this.insertTargetInstanceSettings = settingsBuilder.insertTargetInstanceSettings().build();
        this.listTargetInstancesSettings = settingsBuilder.listTargetInstancesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TargetInstanceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList, TargetInstanceClient.AggregatedListTargetInstancesPagedResponse> aggregatedListTargetInstancesSettings;
        private final UnaryCallSettings.Builder<DeleteTargetInstanceHttpRequest, Operation> deleteTargetInstanceSettings;
        private final UnaryCallSettings.Builder<GetTargetInstanceHttpRequest, TargetInstance> getTargetInstanceSettings;
        private final UnaryCallSettings.Builder<InsertTargetInstanceHttpRequest, Operation> insertTargetInstanceSettings;
        private final PagedCallSettings.Builder<ListTargetInstancesHttpRequest, TargetInstanceList, TargetInstanceClient.ListTargetInstancesPagedResponse> listTargetInstancesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListTargetInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_TARGET_INSTANCES_PAGE_STR_FACT);
            this.deleteTargetInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTargetInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertTargetInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTargetInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TARGET_INSTANCES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListTargetInstancesSettings, this.deleteTargetInstanceSettings, this.getTargetInstanceSettings, this.insertTargetInstanceSettings, this.listTargetInstancesSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TargetInstanceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TargetInstanceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TargetInstanceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TargetInstanceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListTargetInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteTargetInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getTargetInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertTargetInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTargetInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(TargetInstanceStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListTargetInstancesSettings = settings.aggregatedListTargetInstancesSettings.toBuilder();
            this.deleteTargetInstanceSettings = settings.deleteTargetInstanceSettings.toBuilder();
            this.getTargetInstanceSettings = settings.getTargetInstanceSettings.toBuilder();
            this.insertTargetInstanceSettings = settings.insertTargetInstanceSettings.toBuilder();
            this.listTargetInstancesSettings = settings.listTargetInstancesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListTargetInstancesSettings, this.deleteTargetInstanceSettings, this.getTargetInstanceSettings, this.insertTargetInstanceSettings, this.listTargetInstancesSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList, TargetInstanceClient.AggregatedListTargetInstancesPagedResponse> aggregatedListTargetInstancesSettings() {
            return this.aggregatedListTargetInstancesSettings;
        }

        public UnaryCallSettings.Builder<DeleteTargetInstanceHttpRequest, Operation> deleteTargetInstanceSettings() {
            return this.deleteTargetInstanceSettings;
        }

        public UnaryCallSettings.Builder<GetTargetInstanceHttpRequest, TargetInstance> getTargetInstanceSettings() {
            return this.getTargetInstanceSettings;
        }

        public UnaryCallSettings.Builder<InsertTargetInstanceHttpRequest, Operation> insertTargetInstanceSettings() {
            return this.insertTargetInstanceSettings;
        }

        public PagedCallSettings.Builder<ListTargetInstancesHttpRequest, TargetInstanceList, TargetInstanceClient.ListTargetInstancesPagedResponse> listTargetInstancesSettings() {
            return this.listTargetInstancesSettings;
        }

        public TargetInstanceStubSettings build() throws IOException {
            return new TargetInstanceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

