/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalOperationName
implements ResourceName {
    private final String operation;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/operations/{operation}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalOperationName(Builder builder) {
        this.operation = (String)Preconditions.checkNotNull((Object)builder.getOperation());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalOperationName of(String operation, String project) {
        return ProjectGlobalOperationName.newBuilder().setOperation(operation).setProject(project).build();
    }

    public static String format(String operation, String project) {
        return ProjectGlobalOperationName.of(operation, project).toString();
    }

    public String getOperation() {
        return this.operation;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalOperationName projectGlobalOperationName = this;
            synchronized (projectGlobalOperationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"operation", (Object)this.operation);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalOperationName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalOperationName>(){

            public ProjectGlobalOperationName parse(String formattedString) {
                return ProjectGlobalOperationName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalOperationName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalOperationName.parse: formattedString not in valid format");
        return ProjectGlobalOperationName.of((String)matchMap.get("operation"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"operation", this.operation, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalOperationName) {
            ProjectGlobalOperationName that = (ProjectGlobalOperationName)o;
            return Objects.equals(this.operation, that.getOperation()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.operation, this.project);
    }

    public static class Builder {
        private String operation;
        private String project;

        public String getOperation() {
            return this.operation;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setOperation(String operation) {
            this.operation = operation;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalOperationName projectGlobalOperationName) {
            this.operation = projectGlobalOperationName.operation;
            this.project = projectGlobalOperationName.project;
        }

        public ProjectGlobalOperationName build() {
            return new ProjectGlobalOperationName(this);
        }
    }
}

