/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Data;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Warning
implements ApiMessage {
    private final String code;
    private final List<Data> data;
    private final String message;
    private static final Warning DEFAULT_INSTANCE = new Warning();

    private Warning() {
        this.code = null;
        this.data = null;
        this.message = null;
    }

    private Warning(String code, List<Data> data, String message) {
        this.code = code;
        this.data = data;
        this.message = message;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("code")) {
            return this.code;
        }
        if (fieldName.equals("data")) {
            return this.data;
        }
        if (fieldName.equals("message")) {
            return this.message;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public List<Data> getDataList() {
        return this.data;
    }

    public String getMessage() {
        return this.message;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Warning prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Warning getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Warning{code=" + this.code + ", data=" + this.data + ", message=" + this.message + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Warning) {
            Warning that = (Warning)o;
            return Objects.equals(this.code, that.getCode()) && Objects.equals(this.data, that.getDataList()) && Objects.equals(this.message, that.getMessage());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.code, this.data, this.message);
    }

    public static class Builder {
        private String code;
        private List<Data> data;
        private String message;

        Builder() {
        }

        public Builder mergeFrom(Warning other) {
            if (other == Warning.getDefaultInstance()) {
                return this;
            }
            if (other.getCode() != null) {
                this.code = other.code;
            }
            if (other.getDataList() != null) {
                this.data = other.data;
            }
            if (other.getMessage() != null) {
                this.message = other.message;
            }
            return this;
        }

        Builder(Warning source) {
            this.code = source.code;
            this.data = source.data;
            this.message = source.message;
        }

        public String getCode() {
            return this.code;
        }

        public Builder setCode(String code) {
            this.code = code;
            return this;
        }

        public List<Data> getDataList() {
            return this.data;
        }

        public Builder addAllData(List<Data> data) {
            if (this.data == null) {
                this.data = new LinkedList<Data>();
            }
            this.data.addAll(data);
            return this;
        }

        public Builder addData(Data data) {
            if (this.data == null) {
                this.data = new LinkedList<Data>();
            }
            this.data.add(data);
            return this;
        }

        public String getMessage() {
            return this.message;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Warning build() {
            return new Warning(this.code, this.data, this.message);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCode(this.code);
            newBuilder.addAllData(this.data);
            newBuilder.setMessage(this.message);
            return newBuilder;
        }
    }
}

