/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.DeprecationStatus;
import com.google.cloud.compute.ImageConfiguration;
import com.google.cloud.compute.ImageId;
import com.google.cloud.compute.ImageInfo;
import com.google.cloud.compute.LicenseId;
import com.google.cloud.compute.Operation;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Objects;

public class Image
extends ImageInfo {
    private static final long serialVersionUID = 4623766590317494020L;
    private final ComputeOptions options;
    private transient Compute compute;

    Image(Compute compute, ImageInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.compute = (Compute)Preconditions.checkNotNull((Object)compute);
        this.options = (ComputeOptions)compute.getOptions();
    }

    public boolean exists() {
        return this.reload(Compute.ImageOption.fields(new Compute.ImageField[0])) != null;
    }

    public Image reload(Compute.ImageOption ... options) {
        return this.compute.getImage(this.getImageId(), options);
    }

    public Operation delete(Compute.OperationOption ... options) {
        return this.compute.deleteImage(this.getImageId(), options);
    }

    public Operation deprecate(DeprecationStatus<ImageId> deprecationStatus, Compute.OperationOption ... options) {
        return this.compute.deprecate(this.getImageId(), deprecationStatus, options);
    }

    @Deprecated
    public Compute compute() {
        return this.getCompute();
    }

    public Compute getCompute() {
        return this.compute;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Image.class)) {
            return false;
        }
        Image other = (Image)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.compute = (Compute)this.options.getService();
    }

    static Image fromPb(Compute compute, com.google.api.services.compute.model.Image imagePb) {
        return new Image(compute, new ImageInfo.BuilderImpl(imagePb));
    }

    public static class Builder
    extends ImageInfo.Builder {
        private final Compute compute;
        private final ImageInfo.BuilderImpl infoBuilder;

        Builder(Compute compute, ImageId imageId, ImageConfiguration configuration) {
            this.compute = compute;
            this.infoBuilder = new ImageInfo.BuilderImpl();
            this.infoBuilder.setImageId(imageId);
            this.infoBuilder.setConfiguration(configuration);
        }

        Builder(Image image) {
            this.compute = image.compute;
            this.infoBuilder = new ImageInfo.BuilderImpl(image);
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.infoBuilder.setGeneratedId(generatedId);
            return this;
        }

        @Override
        Builder getCreationTimestamp(Long creationTimestamp) {
            this.infoBuilder.getCreationTimestamp(creationTimestamp);
            return this;
        }

        @Override
        @Deprecated
        public Builder imageId(ImageId imageId) {
            return this.setImageId(imageId);
        }

        @Override
        public Builder setImageId(ImageId imageId) {
            this.infoBuilder.setImageId(imageId);
            return this;
        }

        @Override
        @Deprecated
        public Builder description(String description) {
            return this.setDescription(description);
        }

        @Override
        public Builder setDescription(String description) {
            this.infoBuilder.setDescription(description);
            return this;
        }

        @Override
        @Deprecated
        public Builder configuration(ImageConfiguration configuration) {
            return this.setConfiguration(configuration);
        }

        @Override
        public Builder setConfiguration(ImageConfiguration configuration) {
            this.infoBuilder.setConfiguration(configuration);
            return this;
        }

        @Override
        Builder setStatus(ImageInfo.Status status) {
            this.infoBuilder.setStatus(status);
            return this;
        }

        @Override
        Builder setDiskSizeGb(Long diskSizeGb) {
            this.infoBuilder.setDiskSizeGb(diskSizeGb);
            return this;
        }

        @Override
        Builder setLicenses(List<LicenseId> licenses) {
            this.infoBuilder.setLicenses((List)licenses);
            return this;
        }

        @Override
        Builder setDeprecationStatus(DeprecationStatus<ImageId> deprecationStatus) {
            this.infoBuilder.setDeprecationStatus((DeprecationStatus)deprecationStatus);
            return this;
        }

        @Override
        public Image build() {
            return new Image(this.compute, this.infoBuilder);
        }
    }
}

