/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.OperationId;
import com.google.cloud.compute.RegionId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegionOperationId
extends OperationId {
    private static final String REGEX = ".*?projects/([^/]+)/regions/([^/]+)/operations/([^/]+)";
    private static final Pattern PATTERN = Pattern.compile(".*?projects/([^/]+)/regions/([^/]+)/operations/([^/]+)");
    private static final long serialVersionUID = 5816161906501886782L;
    private final String region;

    private RegionOperationId(String project, String region, String operation) {
        super(project, operation);
        this.region = (String)Preconditions.checkNotNull((Object)region);
    }

    @Override
    public OperationId.Type type() {
        return OperationId.Type.REGION;
    }

    public String region() {
        return this.region;
    }

    public RegionId regionId() {
        return RegionId.of(this.project(), this.region);
    }

    @Override
    public String selfLink() {
        return super.selfLink() + "/regions/" + this.region + "/operations/" + this.operation();
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("region", (Object)this.region);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.region);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RegionOperationId)) {
            return false;
        }
        RegionOperationId other = (RegionOperationId)obj;
        return this.baseEquals(other) && Objects.equals(this.region, other.region);
    }

    @Override
    RegionOperationId setProjectId(String projectId) {
        if (this.project() != null) {
            return this;
        }
        return RegionOperationId.of(projectId, this.region, this.operation());
    }

    public static RegionOperationId of(RegionId regionId, String operation) {
        return new RegionOperationId(regionId.project(), regionId.region(), operation);
    }

    public static RegionOperationId of(String region, String operation) {
        return new RegionOperationId(null, region, operation);
    }

    public static RegionOperationId of(String project, String region, String operation) {
        return new RegionOperationId(project, region, operation);
    }

    static boolean matchesUrl(String url) {
        return PATTERN.matcher(url).matches();
    }

    static RegionOperationId fromUrl(String url) {
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(url + " is not a valid region operation URL");
        }
        return RegionOperationId.of(matcher.group(1), matcher.group(2), matcher.group(3));
    }
}

