/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.MachineType;
import com.google.cloud.compute.DeprecationStatus;
import com.google.cloud.compute.MachineTypeId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class MachineType
implements Serializable {
    static final Function<com.google.api.services.compute.model.MachineType, MachineType> FROM_PB_FUNCTION = new Function<com.google.api.services.compute.model.MachineType, MachineType>(){

        public MachineType apply(com.google.api.services.compute.model.MachineType pb) {
            return MachineType.fromPb(pb);
        }
    };
    static final Function<MachineType, com.google.api.services.compute.model.MachineType> TO_PB_FUNCTION = new Function<MachineType, com.google.api.services.compute.model.MachineType>(){

        public com.google.api.services.compute.model.MachineType apply(MachineType type) {
            return type.toPb();
        }
    };
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = ISODateTimeFormat.dateTime();
    private static final long serialVersionUID = -4210962597502860450L;
    private final MachineTypeId machineTypeId;
    private final String generatedId;
    private final Long creationTimestamp;
    private final String description;
    private final Integer cpus;
    private final Integer memoryMb;
    private final List<Integer> scratchDisksSizeGb;
    private final Integer maximumPersistentDisks;
    private final Long maximumPersistentDisksSizeGb;
    private final DeprecationStatus<MachineTypeId> deprecationStatus;

    private MachineType(Builder builder) {
        this.machineTypeId = builder.machineTypeId;
        this.generatedId = builder.generatedId;
        this.creationTimestamp = builder.creationTimestamp;
        this.description = builder.description;
        this.cpus = builder.cpus;
        this.memoryMb = builder.memoryMb;
        this.scratchDisksSizeGb = builder.scratchDisksSizeGb;
        this.maximumPersistentDisks = builder.maximumPersistentDisks;
        this.maximumPersistentDisksSizeGb = builder.maximumPersistentDisksSizeGb;
        this.deprecationStatus = builder.deprecationStatus;
    }

    public MachineTypeId machineTypeId() {
        return this.machineTypeId;
    }

    public String generatedId() {
        return this.generatedId;
    }

    public Long creationTimestamp() {
        return this.creationTimestamp;
    }

    public String description() {
        return this.description;
    }

    public Integer cpus() {
        return this.cpus;
    }

    public Integer memoryMb() {
        return this.memoryMb;
    }

    public List<Integer> scratchDisksSizeGb() {
        return this.scratchDisksSizeGb;
    }

    public Integer maximumPersistentDisks() {
        return this.maximumPersistentDisks;
    }

    public Long maximumPersistentDisksSizeGb() {
        return this.maximumPersistentDisksSizeGb;
    }

    public DeprecationStatus<MachineTypeId> deprecationStatus() {
        return this.deprecationStatus;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("machineTypeId", (Object)this.machineTypeId).add("generatedId", (Object)this.generatedId).add("creationTimestamp", (Object)this.creationTimestamp).add("description", (Object)this.description).add("cpus", (Object)this.cpus).add("memoryMb", (Object)this.memoryMb).add("scratchDisksSizeGb", this.scratchDisksSizeGb).add("maximumPersistentDisks", (Object)this.maximumPersistentDisks).add("maximumPersistentDisksSizeGb", (Object)this.maximumPersistentDisksSizeGb).add("deprecationStatus", this.deprecationStatus).toString();
    }

    public final int hashCode() {
        return Objects.hash(this.machineTypeId);
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(MachineType.class) && Objects.equals(this.toPb(), ((MachineType)obj).toPb());
    }

    com.google.api.services.compute.model.MachineType toPb() {
        com.google.api.services.compute.model.MachineType machineTypePb = new com.google.api.services.compute.model.MachineType();
        if (this.generatedId != null) {
            machineTypePb.setId(new BigInteger(this.generatedId));
        }
        if (this.creationTimestamp != null) {
            machineTypePb.setCreationTimestamp(TIMESTAMP_FORMATTER.print(this.creationTimestamp.longValue()));
        }
        machineTypePb.setName(this.machineTypeId.type());
        machineTypePb.setDescription(this.description);
        machineTypePb.setSelfLink(this.machineTypeId.selfLink());
        machineTypePb.setGuestCpus(this.cpus);
        machineTypePb.setMemoryMb(this.memoryMb);
        if (this.scratchDisksSizeGb != null) {
            machineTypePb.setScratchDisks(Lists.transform(this.scratchDisksSizeGb, (Function)new Function<Integer, MachineType.ScratchDisks>(){

                public MachineType.ScratchDisks apply(Integer diskSize) {
                    return new MachineType.ScratchDisks().setDiskGb(diskSize);
                }
            }));
        }
        machineTypePb.setMaximumPersistentDisks(this.maximumPersistentDisks);
        machineTypePb.setMaximumPersistentDisksSizeGb(this.maximumPersistentDisksSizeGb);
        machineTypePb.setZone(this.machineTypeId.zoneId().zone());
        if (this.deprecationStatus != null) {
            machineTypePb.setDeprecated(this.deprecationStatus.toPb());
        }
        return machineTypePb;
    }

    static Builder builder() {
        return new Builder();
    }

    static MachineType fromPb(com.google.api.services.compute.model.MachineType machineTypePb) {
        Builder builder = MachineType.builder();
        builder.machineTypeId(MachineTypeId.fromUrl(machineTypePb.getSelfLink()));
        if (machineTypePb.getId() != null) {
            builder.generatedId(machineTypePb.getId().toString());
        }
        if (machineTypePb.getCreationTimestamp() != null) {
            builder.creationTimestamp(TIMESTAMP_FORMATTER.parseMillis(machineTypePb.getCreationTimestamp()));
        }
        builder.description(machineTypePb.getDescription());
        builder.cpus(machineTypePb.getGuestCpus());
        builder.memoryMb(machineTypePb.getMemoryMb());
        if (machineTypePb.getScratchDisks() != null) {
            builder.scratchDisksSizeGb(Lists.transform((List)machineTypePb.getScratchDisks(), (Function)new Function<MachineType.ScratchDisks, Integer>(){

                public Integer apply(MachineType.ScratchDisks scratchDiskPb) {
                    return scratchDiskPb.getDiskGb();
                }
            }));
        }
        builder.maximumPersistentDisks(machineTypePb.getMaximumPersistentDisks());
        builder.maximumPersistentDisksSizeGb(machineTypePb.getMaximumPersistentDisksSizeGb());
        if (machineTypePb.getDeprecated() != null) {
            builder.deprecationStatus(DeprecationStatus.fromPb(machineTypePb.getDeprecated(), MachineTypeId.FROM_URL_FUNCTION));
        }
        return builder.build();
    }

    static final class Builder {
        private MachineTypeId machineTypeId;
        private String generatedId;
        private Long creationTimestamp;
        private String description;
        private Integer cpus;
        private Integer memoryMb;
        private List<Integer> scratchDisksSizeGb;
        private Integer maximumPersistentDisks;
        private Long maximumPersistentDisksSizeGb;
        private DeprecationStatus<MachineTypeId> deprecationStatus;

        private Builder() {
        }

        Builder machineTypeId(MachineTypeId machineTypeId) {
            this.machineTypeId = machineTypeId;
            return this;
        }

        Builder generatedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        Builder creationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        Builder description(String description) {
            this.description = description;
            return this;
        }

        Builder cpus(Integer cpus) {
            this.cpus = cpus;
            return this;
        }

        Builder memoryMb(Integer memoryMb) {
            this.memoryMb = memoryMb;
            return this;
        }

        Builder scratchDisksSizeGb(List<Integer> scratchDisksSizeGb) {
            this.scratchDisksSizeGb = scratchDisksSizeGb;
            return this;
        }

        Builder maximumPersistentDisks(Integer maximumPersistentDisks) {
            this.maximumPersistentDisks = maximumPersistentDisks;
            return this;
        }

        Builder maximumPersistentDisksSizeGb(Long maximumPersistentDisksSizeGb) {
            this.maximumPersistentDisksSizeGb = maximumPersistentDisksSizeGb;
            return this;
        }

        Builder deprecationStatus(DeprecationStatus<MachineTypeId> deprecationStatus) {
            this.deprecationStatus = deprecationStatus;
            return this;
        }

        MachineType build() {
            return new MachineType(this);
        }
    }
}

