/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.PerInstanceConfig;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class RegionInstanceGroupManagersCreateInstancesRequest
implements ApiMessage {
    private final List<PerInstanceConfig> instances;
    private static final RegionInstanceGroupManagersCreateInstancesRequest DEFAULT_INSTANCE = new RegionInstanceGroupManagersCreateInstancesRequest();

    private RegionInstanceGroupManagersCreateInstancesRequest() {
        this.instances = null;
    }

    private RegionInstanceGroupManagersCreateInstancesRequest(List<PerInstanceConfig> instances) {
        this.instances = instances;
    }

    public Object getFieldValue(String fieldName) {
        if ("instances".equals(fieldName)) {
            return this.instances;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<PerInstanceConfig> getInstancesList() {
        return this.instances;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(RegionInstanceGroupManagersCreateInstancesRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static RegionInstanceGroupManagersCreateInstancesRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "RegionInstanceGroupManagersCreateInstancesRequest{instances=" + this.instances + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RegionInstanceGroupManagersCreateInstancesRequest) {
            RegionInstanceGroupManagersCreateInstancesRequest that = (RegionInstanceGroupManagersCreateInstancesRequest)o;
            return Objects.equals(this.instances, that.getInstancesList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instances);
    }

    public static class Builder {
        private List<PerInstanceConfig> instances;

        Builder() {
        }

        public Builder mergeFrom(RegionInstanceGroupManagersCreateInstancesRequest other) {
            if (other == RegionInstanceGroupManagersCreateInstancesRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getInstancesList() != null) {
                this.instances = other.instances;
            }
            return this;
        }

        Builder(RegionInstanceGroupManagersCreateInstancesRequest source) {
            this.instances = source.instances;
        }

        public List<PerInstanceConfig> getInstancesList() {
            return this.instances;
        }

        public Builder addAllInstances(List<PerInstanceConfig> instances) {
            if (this.instances == null) {
                this.instances = new LinkedList<PerInstanceConfig>();
            }
            this.instances.addAll(instances);
            return this;
        }

        public Builder addInstances(PerInstanceConfig instances) {
            if (this.instances == null) {
                this.instances = new LinkedList<PerInstanceConfig>();
            }
            this.instances.add(instances);
            return this;
        }

        public RegionInstanceGroupManagersCreateInstancesRequest build() {
            return new RegionInstanceGroupManagersCreateInstancesRequest(this.instances);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllInstances(this.instances);
            return newBuilder;
        }
    }
}

