/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class FileContentBuffer
implements ApiMessage {
    private final String content;
    private final String fileType;
    private static final FileContentBuffer DEFAULT_INSTANCE = new FileContentBuffer();

    private FileContentBuffer() {
        this.content = null;
        this.fileType = null;
    }

    private FileContentBuffer(String content, String fileType) {
        this.content = content;
        this.fileType = fileType;
    }

    public Object getFieldValue(String fieldName) {
        if ("content".equals(fieldName)) {
            return this.content;
        }
        if ("fileType".equals(fieldName)) {
            return this.fileType;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getContent() {
        return this.content;
    }

    public String getFileType() {
        return this.fileType;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(FileContentBuffer prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static FileContentBuffer getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "FileContentBuffer{content=" + this.content + ", fileType=" + this.fileType + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FileContentBuffer) {
            FileContentBuffer that = (FileContentBuffer)o;
            return Objects.equals(this.content, that.getContent()) && Objects.equals(this.fileType, that.getFileType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.content, this.fileType);
    }

    public static class Builder {
        private String content;
        private String fileType;

        Builder() {
        }

        public Builder mergeFrom(FileContentBuffer other) {
            if (other == FileContentBuffer.getDefaultInstance()) {
                return this;
            }
            if (other.getContent() != null) {
                this.content = other.content;
            }
            if (other.getFileType() != null) {
                this.fileType = other.fileType;
            }
            return this;
        }

        Builder(FileContentBuffer source) {
            this.content = source.content;
            this.fileType = source.fileType;
        }

        public String getContent() {
            return this.content;
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public String getFileType() {
            return this.fileType;
        }

        public Builder setFileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        public FileContentBuffer build() {
            return new FileContentBuffer(this.content, this.fileType);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setContent(this.content);
            newBuilder.setFileType(this.fileType);
            return newBuilder;
        }
    }
}

