/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.DeleteZoneOperationHttpRequest;
import com.google.cloud.compute.v1.GetZoneOperationHttpRequest;
import com.google.cloud.compute.v1.ListZoneOperationsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.OperationList;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.ProjectZoneOperationName;
import com.google.cloud.compute.v1.WaitZoneOperationHttpRequest;
import com.google.cloud.compute.v1.ZoneOperationClient;
import com.google.cloud.compute.v1.stub.HttpJsonZoneOperationCallableFactory;
import com.google.cloud.compute.v1.stub.ZoneOperationStub;
import com.google.cloud.compute.v1.stub.ZoneOperationStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonZoneOperationStub
extends ZoneOperationStub {
    @InternalApi
    public static final ApiMethodDescriptor<DeleteZoneOperationHttpRequest, Void> deleteZoneOperationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.zoneOperations.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/operations/{operation}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectZoneOperationName.newFactory()).setResourceNameField("operation").build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetZoneOperationHttpRequest, Operation> getZoneOperationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.zoneOperations.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/operations/{operation}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectZoneOperationName.newFactory()).setResourceNameField("operation").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListZoneOperationsHttpRequest, OperationList> listZoneOperationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.zoneOperations.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/operations")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectZoneName.newFactory()).setResourceNameField("zone").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)OperationList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<WaitZoneOperationHttpRequest, Operation> waitZoneOperationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.zoneOperations.wait").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/operations/{operation}/wait")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectZoneOperationName.newFactory()).setResourceNameField("operation").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteZoneOperationHttpRequest, Void> deleteZoneOperationCallable;
    private final UnaryCallable<GetZoneOperationHttpRequest, Operation> getZoneOperationCallable;
    private final UnaryCallable<ListZoneOperationsHttpRequest, OperationList> listZoneOperationsCallable;
    private final UnaryCallable<ListZoneOperationsHttpRequest, ZoneOperationClient.ListZoneOperationsPagedResponse> listZoneOperationsPagedCallable;
    private final UnaryCallable<WaitZoneOperationHttpRequest, Operation> waitZoneOperationCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonZoneOperationStub create(ZoneOperationStubSettings settings) throws IOException {
        return new HttpJsonZoneOperationStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonZoneOperationStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonZoneOperationStub(ZoneOperationStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonZoneOperationStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonZoneOperationStub(ZoneOperationStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonZoneOperationStub(ZoneOperationStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonZoneOperationCallableFactory());
    }

    protected HttpJsonZoneOperationStub(ZoneOperationStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteZoneOperationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteZoneOperationMethodDescriptor).build();
        HttpJsonCallSettings getZoneOperationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getZoneOperationMethodDescriptor).build();
        HttpJsonCallSettings listZoneOperationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listZoneOperationsMethodDescriptor).build();
        HttpJsonCallSettings waitZoneOperationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(waitZoneOperationMethodDescriptor).build();
        this.deleteZoneOperationCallable = callableFactory.createUnaryCallable(deleteZoneOperationTransportSettings, settings.deleteZoneOperationSettings(), clientContext);
        this.getZoneOperationCallable = callableFactory.createUnaryCallable(getZoneOperationTransportSettings, settings.getZoneOperationSettings(), clientContext);
        this.listZoneOperationsCallable = callableFactory.createUnaryCallable(listZoneOperationsTransportSettings, settings.listZoneOperationsSettings(), clientContext);
        this.listZoneOperationsPagedCallable = callableFactory.createPagedCallable(listZoneOperationsTransportSettings, settings.listZoneOperationsSettings(), clientContext);
        this.waitZoneOperationCallable = callableFactory.createUnaryCallable(waitZoneOperationTransportSettings, settings.waitZoneOperationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteZoneOperationHttpRequest, Void> deleteZoneOperationCallable() {
        return this.deleteZoneOperationCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetZoneOperationHttpRequest, Operation> getZoneOperationCallable() {
        return this.getZoneOperationCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListZoneOperationsHttpRequest, ZoneOperationClient.ListZoneOperationsPagedResponse> listZoneOperationsPagedCallable() {
        return this.listZoneOperationsPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListZoneOperationsHttpRequest, OperationList> listZoneOperationsCallable() {
        return this.listZoneOperationsCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<WaitZoneOperationHttpRequest, Operation> waitZoneOperationCallable() {
        return this.waitZoneOperationCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

