/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Duration;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class NotificationEndpointGrpcSettings
implements ApiMessage {
    private final String authority;
    private final String endpoint;
    private final String payloadName;
    private final Duration resendInterval;
    private final Integer retryDurationSec;
    private static final NotificationEndpointGrpcSettings DEFAULT_INSTANCE = new NotificationEndpointGrpcSettings();

    private NotificationEndpointGrpcSettings() {
        this.authority = null;
        this.endpoint = null;
        this.payloadName = null;
        this.resendInterval = null;
        this.retryDurationSec = null;
    }

    private NotificationEndpointGrpcSettings(String authority, String endpoint, String payloadName, Duration resendInterval, Integer retryDurationSec) {
        this.authority = authority;
        this.endpoint = endpoint;
        this.payloadName = payloadName;
        this.resendInterval = resendInterval;
        this.retryDurationSec = retryDurationSec;
    }

    public Object getFieldValue(String fieldName) {
        if ("authority".equals(fieldName)) {
            return this.authority;
        }
        if ("endpoint".equals(fieldName)) {
            return this.endpoint;
        }
        if ("payloadName".equals(fieldName)) {
            return this.payloadName;
        }
        if ("resendInterval".equals(fieldName)) {
            return this.resendInterval;
        }
        if ("retryDurationSec".equals(fieldName)) {
            return this.retryDurationSec;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getPayloadName() {
        return this.payloadName;
    }

    public Duration getResendInterval() {
        return this.resendInterval;
    }

    public Integer getRetryDurationSec() {
        return this.retryDurationSec;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NotificationEndpointGrpcSettings prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static NotificationEndpointGrpcSettings getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "NotificationEndpointGrpcSettings{authority=" + this.authority + ", endpoint=" + this.endpoint + ", payloadName=" + this.payloadName + ", resendInterval=" + this.resendInterval + ", retryDurationSec=" + this.retryDurationSec + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NotificationEndpointGrpcSettings) {
            NotificationEndpointGrpcSettings that = (NotificationEndpointGrpcSettings)o;
            return Objects.equals(this.authority, that.getAuthority()) && Objects.equals(this.endpoint, that.getEndpoint()) && Objects.equals(this.payloadName, that.getPayloadName()) && Objects.equals(this.resendInterval, that.getResendInterval()) && Objects.equals(this.retryDurationSec, that.getRetryDurationSec());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.authority, this.endpoint, this.payloadName, this.resendInterval, this.retryDurationSec);
    }

    public static class Builder {
        private String authority;
        private String endpoint;
        private String payloadName;
        private Duration resendInterval;
        private Integer retryDurationSec;

        Builder() {
        }

        public Builder mergeFrom(NotificationEndpointGrpcSettings other) {
            if (other == NotificationEndpointGrpcSettings.getDefaultInstance()) {
                return this;
            }
            if (other.getAuthority() != null) {
                this.authority = other.authority;
            }
            if (other.getEndpoint() != null) {
                this.endpoint = other.endpoint;
            }
            if (other.getPayloadName() != null) {
                this.payloadName = other.payloadName;
            }
            if (other.getResendInterval() != null) {
                this.resendInterval = other.resendInterval;
            }
            if (other.getRetryDurationSec() != null) {
                this.retryDurationSec = other.retryDurationSec;
            }
            return this;
        }

        Builder(NotificationEndpointGrpcSettings source) {
            this.authority = source.authority;
            this.endpoint = source.endpoint;
            this.payloadName = source.payloadName;
            this.resendInterval = source.resendInterval;
            this.retryDurationSec = source.retryDurationSec;
        }

        public String getAuthority() {
            return this.authority;
        }

        public Builder setAuthority(String authority) {
            this.authority = authority;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public String getPayloadName() {
            return this.payloadName;
        }

        public Builder setPayloadName(String payloadName) {
            this.payloadName = payloadName;
            return this;
        }

        public Duration getResendInterval() {
            return this.resendInterval;
        }

        public Builder setResendInterval(Duration resendInterval) {
            this.resendInterval = resendInterval;
            return this;
        }

        public Integer getRetryDurationSec() {
            return this.retryDurationSec;
        }

        public Builder setRetryDurationSec(Integer retryDurationSec) {
            this.retryDurationSec = retryDurationSec;
            return this;
        }

        public NotificationEndpointGrpcSettings build() {
            return new NotificationEndpointGrpcSettings(this.authority, this.endpoint, this.payloadName, this.resendInterval, this.retryDurationSec);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAuthority(this.authority);
            newBuilder.setEndpoint(this.endpoint);
            newBuilder.setPayloadName(this.payloadName);
            newBuilder.setResendInterval(this.resendInterval);
            newBuilder.setRetryDurationSec(this.retryDurationSec);
            return newBuilder;
        }
    }
}

