/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListInterconnectAttachmentsHttpRequest;
import com.google.cloud.compute.v1.DeleteInterconnectAttachmentHttpRequest;
import com.google.cloud.compute.v1.GetInterconnectAttachmentHttpRequest;
import com.google.cloud.compute.v1.InsertInterconnectAttachmentHttpRequest;
import com.google.cloud.compute.v1.InterconnectAttachment;
import com.google.cloud.compute.v1.InterconnectAttachmentAggregatedList;
import com.google.cloud.compute.v1.InterconnectAttachmentClient;
import com.google.cloud.compute.v1.InterconnectAttachmentList;
import com.google.cloud.compute.v1.InterconnectAttachmentsScopedList;
import com.google.cloud.compute.v1.ListInterconnectAttachmentsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInterconnectAttachmentHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonInterconnectAttachmentStub;
import com.google.cloud.compute.v1.stub.InterconnectAttachmentStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class InterconnectAttachmentStubSettings
extends StubSettings<InterconnectAttachmentStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListInterconnectAttachmentsHttpRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentClient.AggregatedListInterconnectAttachmentsPagedResponse> aggregatedListInterconnectAttachmentsSettings;
    private final UnaryCallSettings<DeleteInterconnectAttachmentHttpRequest, Operation> deleteInterconnectAttachmentSettings;
    private final UnaryCallSettings<GetInterconnectAttachmentHttpRequest, InterconnectAttachment> getInterconnectAttachmentSettings;
    private final UnaryCallSettings<InsertInterconnectAttachmentHttpRequest, Operation> insertInterconnectAttachmentSettings;
    private final PagedCallSettings<ListInterconnectAttachmentsHttpRequest, InterconnectAttachmentList, InterconnectAttachmentClient.ListInterconnectAttachmentsPagedResponse> listInterconnectAttachmentsSettings;
    private final UnaryCallSettings<PatchInterconnectAttachmentHttpRequest, Operation> patchInterconnectAttachmentSettings;
    private static final PagedListDescriptor<AggregatedListInterconnectAttachmentsHttpRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentsScopedList> AGGREGATED_LIST_INTERCONNECT_ATTACHMENTS_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListInterconnectAttachmentsHttpRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentsScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListInterconnectAttachmentsHttpRequest injectToken(AggregatedListInterconnectAttachmentsHttpRequest payload, String token) {
            return AggregatedListInterconnectAttachmentsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListInterconnectAttachmentsHttpRequest injectPageSize(AggregatedListInterconnectAttachmentsHttpRequest payload, int pageSize) {
            return AggregatedListInterconnectAttachmentsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListInterconnectAttachmentsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InterconnectAttachmentAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InterconnectAttachmentsScopedList> extractResources(InterconnectAttachmentAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListInterconnectAttachmentsHttpRequest, InterconnectAttachmentList, InterconnectAttachment> LIST_INTERCONNECT_ATTACHMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListInterconnectAttachmentsHttpRequest, InterconnectAttachmentList, InterconnectAttachment>(){

        public String emptyToken() {
            return "";
        }

        public ListInterconnectAttachmentsHttpRequest injectToken(ListInterconnectAttachmentsHttpRequest payload, String token) {
            return ListInterconnectAttachmentsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListInterconnectAttachmentsHttpRequest injectPageSize(ListInterconnectAttachmentsHttpRequest payload, int pageSize) {
            return ListInterconnectAttachmentsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListInterconnectAttachmentsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InterconnectAttachmentList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InterconnectAttachment> extractResources(InterconnectAttachmentList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListInterconnectAttachmentsHttpRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentClient.AggregatedListInterconnectAttachmentsPagedResponse> AGGREGATED_LIST_INTERCONNECT_ATTACHMENTS_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListInterconnectAttachmentsHttpRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentClient.AggregatedListInterconnectAttachmentsPagedResponse>(){

        public ApiFuture<InterconnectAttachmentClient.AggregatedListInterconnectAttachmentsPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListInterconnectAttachmentsHttpRequest, InterconnectAttachmentAggregatedList> callable, AggregatedListInterconnectAttachmentsHttpRequest request, ApiCallContext context, ApiFuture<InterconnectAttachmentAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_INTERCONNECT_ATTACHMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InterconnectAttachmentClient.AggregatedListInterconnectAttachmentsPagedResponse.createAsync((PageContext<AggregatedListInterconnectAttachmentsHttpRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentsScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInterconnectAttachmentsHttpRequest, InterconnectAttachmentList, InterconnectAttachmentClient.ListInterconnectAttachmentsPagedResponse> LIST_INTERCONNECT_ATTACHMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListInterconnectAttachmentsHttpRequest, InterconnectAttachmentList, InterconnectAttachmentClient.ListInterconnectAttachmentsPagedResponse>(){

        public ApiFuture<InterconnectAttachmentClient.ListInterconnectAttachmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListInterconnectAttachmentsHttpRequest, InterconnectAttachmentList> callable, ListInterconnectAttachmentsHttpRequest request, ApiCallContext context, ApiFuture<InterconnectAttachmentList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INTERCONNECT_ATTACHMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InterconnectAttachmentClient.ListInterconnectAttachmentsPagedResponse.createAsync((PageContext<ListInterconnectAttachmentsHttpRequest, InterconnectAttachmentList, InterconnectAttachment>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListInterconnectAttachmentsHttpRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentClient.AggregatedListInterconnectAttachmentsPagedResponse> aggregatedListInterconnectAttachmentsSettings() {
        return this.aggregatedListInterconnectAttachmentsSettings;
    }

    public UnaryCallSettings<DeleteInterconnectAttachmentHttpRequest, Operation> deleteInterconnectAttachmentSettings() {
        return this.deleteInterconnectAttachmentSettings;
    }

    public UnaryCallSettings<GetInterconnectAttachmentHttpRequest, InterconnectAttachment> getInterconnectAttachmentSettings() {
        return this.getInterconnectAttachmentSettings;
    }

    public UnaryCallSettings<InsertInterconnectAttachmentHttpRequest, Operation> insertInterconnectAttachmentSettings() {
        return this.insertInterconnectAttachmentSettings;
    }

    public PagedCallSettings<ListInterconnectAttachmentsHttpRequest, InterconnectAttachmentList, InterconnectAttachmentClient.ListInterconnectAttachmentsPagedResponse> listInterconnectAttachmentsSettings() {
        return this.listInterconnectAttachmentsSettings;
    }

    public UnaryCallSettings<PatchInterconnectAttachmentHttpRequest, Operation> patchInterconnectAttachmentSettings() {
        return this.patchInterconnectAttachmentSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InterconnectAttachmentStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonInterconnectAttachmentStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return InterconnectAttachmentStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(InterconnectAttachmentStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected InterconnectAttachmentStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListInterconnectAttachmentsSettings = settingsBuilder.aggregatedListInterconnectAttachmentsSettings().build();
        this.deleteInterconnectAttachmentSettings = settingsBuilder.deleteInterconnectAttachmentSettings().build();
        this.getInterconnectAttachmentSettings = settingsBuilder.getInterconnectAttachmentSettings().build();
        this.insertInterconnectAttachmentSettings = settingsBuilder.insertInterconnectAttachmentSettings().build();
        this.listInterconnectAttachmentsSettings = settingsBuilder.listInterconnectAttachmentsSettings().build();
        this.patchInterconnectAttachmentSettings = settingsBuilder.patchInterconnectAttachmentSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<InterconnectAttachmentStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListInterconnectAttachmentsHttpRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentClient.AggregatedListInterconnectAttachmentsPagedResponse> aggregatedListInterconnectAttachmentsSettings;
        private final UnaryCallSettings.Builder<DeleteInterconnectAttachmentHttpRequest, Operation> deleteInterconnectAttachmentSettings;
        private final UnaryCallSettings.Builder<GetInterconnectAttachmentHttpRequest, InterconnectAttachment> getInterconnectAttachmentSettings;
        private final UnaryCallSettings.Builder<InsertInterconnectAttachmentHttpRequest, Operation> insertInterconnectAttachmentSettings;
        private final PagedCallSettings.Builder<ListInterconnectAttachmentsHttpRequest, InterconnectAttachmentList, InterconnectAttachmentClient.ListInterconnectAttachmentsPagedResponse> listInterconnectAttachmentsSettings;
        private final UnaryCallSettings.Builder<PatchInterconnectAttachmentHttpRequest, Operation> patchInterconnectAttachmentSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListInterconnectAttachmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_INTERCONNECT_ATTACHMENTS_PAGE_STR_FACT);
            this.deleteInterconnectAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getInterconnectAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertInterconnectAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listInterconnectAttachmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INTERCONNECT_ATTACHMENTS_PAGE_STR_FACT);
            this.patchInterconnectAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListInterconnectAttachmentsSettings, this.deleteInterconnectAttachmentSettings, this.getInterconnectAttachmentSettings, this.insertInterconnectAttachmentSettings, this.listInterconnectAttachmentsSettings, this.patchInterconnectAttachmentSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(InterconnectAttachmentStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)InterconnectAttachmentStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)InterconnectAttachmentStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(InterconnectAttachmentStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListInterconnectAttachmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteInterconnectAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getInterconnectAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertInterconnectAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listInterconnectAttachmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchInterconnectAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(InterconnectAttachmentStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListInterconnectAttachmentsSettings = settings.aggregatedListInterconnectAttachmentsSettings.toBuilder();
            this.deleteInterconnectAttachmentSettings = settings.deleteInterconnectAttachmentSettings.toBuilder();
            this.getInterconnectAttachmentSettings = settings.getInterconnectAttachmentSettings.toBuilder();
            this.insertInterconnectAttachmentSettings = settings.insertInterconnectAttachmentSettings.toBuilder();
            this.listInterconnectAttachmentsSettings = settings.listInterconnectAttachmentsSettings.toBuilder();
            this.patchInterconnectAttachmentSettings = settings.patchInterconnectAttachmentSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListInterconnectAttachmentsSettings, this.deleteInterconnectAttachmentSettings, this.getInterconnectAttachmentSettings, this.insertInterconnectAttachmentSettings, this.listInterconnectAttachmentsSettings, this.patchInterconnectAttachmentSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListInterconnectAttachmentsHttpRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentClient.AggregatedListInterconnectAttachmentsPagedResponse> aggregatedListInterconnectAttachmentsSettings() {
            return this.aggregatedListInterconnectAttachmentsSettings;
        }

        public UnaryCallSettings.Builder<DeleteInterconnectAttachmentHttpRequest, Operation> deleteInterconnectAttachmentSettings() {
            return this.deleteInterconnectAttachmentSettings;
        }

        public UnaryCallSettings.Builder<GetInterconnectAttachmentHttpRequest, InterconnectAttachment> getInterconnectAttachmentSettings() {
            return this.getInterconnectAttachmentSettings;
        }

        public UnaryCallSettings.Builder<InsertInterconnectAttachmentHttpRequest, Operation> insertInterconnectAttachmentSettings() {
            return this.insertInterconnectAttachmentSettings;
        }

        public PagedCallSettings.Builder<ListInterconnectAttachmentsHttpRequest, InterconnectAttachmentList, InterconnectAttachmentClient.ListInterconnectAttachmentsPagedResponse> listInterconnectAttachmentsSettings() {
            return this.listInterconnectAttachmentsSettings;
        }

        public UnaryCallSettings.Builder<PatchInterconnectAttachmentHttpRequest, Operation> patchInterconnectAttachmentSettings() {
            return this.patchInterconnectAttachmentSettings;
        }

        public InterconnectAttachmentStubSettings build() throws IOException {
            return new InterconnectAttachmentStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

