/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class TargetHttpsProxy
implements ApiMessage {
    private final String creationTimestamp;
    private final String description;
    private final String id;
    private final String kind;
    private final String name;
    private final String quicOverride;
    private final String region;
    private final String selfLink;
    private final List<String> sslCertificates;
    private final String sslPolicy;
    private final String urlMap;
    private static final TargetHttpsProxy DEFAULT_INSTANCE = new TargetHttpsProxy();

    private TargetHttpsProxy() {
        this.creationTimestamp = null;
        this.description = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.quicOverride = null;
        this.region = null;
        this.selfLink = null;
        this.sslCertificates = null;
        this.sslPolicy = null;
        this.urlMap = null;
    }

    private TargetHttpsProxy(String creationTimestamp, String description, String id, String kind, String name, String quicOverride, String region, String selfLink, List<String> sslCertificates, String sslPolicy, String urlMap) {
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.quicOverride = quicOverride;
        this.region = region;
        this.selfLink = selfLink;
        this.sslCertificates = sslCertificates;
        this.sslPolicy = sslPolicy;
        this.urlMap = urlMap;
    }

    public Object getFieldValue(String fieldName) {
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("quicOverride".equals(fieldName)) {
            return this.quicOverride;
        }
        if ("region".equals(fieldName)) {
            return this.region;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("sslCertificates".equals(fieldName)) {
            return this.sslCertificates;
        }
        if ("sslPolicy".equals(fieldName)) {
            return this.sslPolicy;
        }
        if ("urlMap".equals(fieldName)) {
            return this.urlMap;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getQuicOverride() {
        return this.quicOverride;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public List<String> getSslCertificatesList() {
        return this.sslCertificates;
    }

    public String getSslPolicy() {
        return this.sslPolicy;
    }

    public String getUrlMap() {
        return this.urlMap;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TargetHttpsProxy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static TargetHttpsProxy getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "TargetHttpsProxy{creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", quicOverride=" + this.quicOverride + ", region=" + this.region + ", selfLink=" + this.selfLink + ", sslCertificates=" + this.sslCertificates + ", sslPolicy=" + this.sslPolicy + ", urlMap=" + this.urlMap + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TargetHttpsProxy) {
            TargetHttpsProxy that = (TargetHttpsProxy)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.quicOverride, that.getQuicOverride()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.sslCertificates, that.getSslCertificatesList()) && Objects.equals(this.sslPolicy, that.getSslPolicy()) && Objects.equals(this.urlMap, that.getUrlMap());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.description, this.id, this.kind, this.name, this.quicOverride, this.region, this.selfLink, this.sslCertificates, this.sslPolicy, this.urlMap);
    }

    public static class Builder {
        private String creationTimestamp;
        private String description;
        private String id;
        private String kind;
        private String name;
        private String quicOverride;
        private String region;
        private String selfLink;
        private List<String> sslCertificates;
        private String sslPolicy;
        private String urlMap;

        Builder() {
        }

        public Builder mergeFrom(TargetHttpsProxy other) {
            if (other == TargetHttpsProxy.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getQuicOverride() != null) {
                this.quicOverride = other.quicOverride;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getSslCertificatesList() != null) {
                this.sslCertificates = other.sslCertificates;
            }
            if (other.getSslPolicy() != null) {
                this.sslPolicy = other.sslPolicy;
            }
            if (other.getUrlMap() != null) {
                this.urlMap = other.urlMap;
            }
            return this;
        }

        Builder(TargetHttpsProxy source) {
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.quicOverride = source.quicOverride;
            this.region = source.region;
            this.selfLink = source.selfLink;
            this.sslCertificates = source.sslCertificates;
            this.sslPolicy = source.sslPolicy;
            this.urlMap = source.urlMap;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getQuicOverride() {
            return this.quicOverride;
        }

        public Builder setQuicOverride(String quicOverride) {
            this.quicOverride = quicOverride;
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public List<String> getSslCertificatesList() {
            return this.sslCertificates;
        }

        public Builder addAllSslCertificates(List<String> sslCertificates) {
            if (this.sslCertificates == null) {
                this.sslCertificates = new LinkedList<String>();
            }
            this.sslCertificates.addAll(sslCertificates);
            return this;
        }

        public Builder addSslCertificates(String sslCertificates) {
            if (this.sslCertificates == null) {
                this.sslCertificates = new LinkedList<String>();
            }
            this.sslCertificates.add(sslCertificates);
            return this;
        }

        public String getSslPolicy() {
            return this.sslPolicy;
        }

        public Builder setSslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        public String getUrlMap() {
            return this.urlMap;
        }

        public Builder setUrlMap(String urlMap) {
            this.urlMap = urlMap;
            return this;
        }

        public TargetHttpsProxy build() {
            return new TargetHttpsProxy(this.creationTimestamp, this.description, this.id, this.kind, this.name, this.quicOverride, this.region, this.selfLink, this.sslCertificates, this.sslPolicy, this.urlMap);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setQuicOverride(this.quicOverride);
            newBuilder.setRegion(this.region);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.addAllSslCertificates(this.sslCertificates);
            newBuilder.setSslPolicy(this.sslPolicy);
            newBuilder.setUrlMap(this.urlMap);
            return newBuilder;
        }
    }
}

