/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListNetworkEndpointGroupsHttpRequest;
import com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.DeleteNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.DetachNetworkEndpointsNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.GetNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.InsertNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.ListNetworkEndpointGroupsHttpRequest;
import com.google.cloud.compute.v1.ListNetworkEndpointsNetworkEndpointGroupsHttpRequest;
import com.google.cloud.compute.v1.NetworkEndpointGroup;
import com.google.cloud.compute.v1.NetworkEndpointGroupAggregatedList;
import com.google.cloud.compute.v1.NetworkEndpointGroupList;
import com.google.cloud.compute.v1.NetworkEndpointGroupSettings;
import com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest;
import com.google.cloud.compute.v1.NetworkEndpointGroupsDetachEndpointsRequest;
import com.google.cloud.compute.v1.NetworkEndpointGroupsListEndpointsRequest;
import com.google.cloud.compute.v1.NetworkEndpointGroupsListNetworkEndpoints;
import com.google.cloud.compute.v1.NetworkEndpointGroupsScopedList;
import com.google.cloud.compute.v1.NetworkEndpointWithHealthStatus;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.ProjectZoneNetworkEndpointGroupName;
import com.google.cloud.compute.v1.ProjectZoneNetworkEndpointGroupResourceName;
import com.google.cloud.compute.v1.TestIamPermissionsNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.NetworkEndpointGroupStub;
import com.google.cloud.compute.v1.stub.NetworkEndpointGroupStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class NetworkEndpointGroupClient
implements BackgroundResource {
    private final NetworkEndpointGroupSettings settings;
    private final NetworkEndpointGroupStub stub;

    public static final NetworkEndpointGroupClient create() throws IOException {
        return NetworkEndpointGroupClient.create(NetworkEndpointGroupSettings.newBuilder().build());
    }

    public static final NetworkEndpointGroupClient create(NetworkEndpointGroupSettings settings) throws IOException {
        return new NetworkEndpointGroupClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final NetworkEndpointGroupClient create(NetworkEndpointGroupStub stub) {
        return new NetworkEndpointGroupClient(stub);
    }

    protected NetworkEndpointGroupClient(NetworkEndpointGroupSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NetworkEndpointGroupStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected NetworkEndpointGroupClient(NetworkEndpointGroupStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final NetworkEndpointGroupSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NetworkEndpointGroupStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListNetworkEndpointGroupsPagedResponse aggregatedListNetworkEndpointGroups(ProjectName project) {
        AggregatedListNetworkEndpointGroupsHttpRequest request = AggregatedListNetworkEndpointGroupsHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListNetworkEndpointGroups(request);
    }

    @BetaApi
    public final AggregatedListNetworkEndpointGroupsPagedResponse aggregatedListNetworkEndpointGroups(String project) {
        AggregatedListNetworkEndpointGroupsHttpRequest request = AggregatedListNetworkEndpointGroupsHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListNetworkEndpointGroups(request);
    }

    @BetaApi
    public final AggregatedListNetworkEndpointGroupsPagedResponse aggregatedListNetworkEndpointGroups(AggregatedListNetworkEndpointGroupsHttpRequest request) {
        return (AggregatedListNetworkEndpointGroupsPagedResponse)((Object)this.aggregatedListNetworkEndpointGroupsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListNetworkEndpointGroupsHttpRequest, AggregatedListNetworkEndpointGroupsPagedResponse> aggregatedListNetworkEndpointGroupsPagedCallable() {
        return this.stub.aggregatedListNetworkEndpointGroupsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupAggregatedList> aggregatedListNetworkEndpointGroupsCallable() {
        return this.stub.aggregatedListNetworkEndpointGroupsCallable();
    }

    @BetaApi
    public final Operation attachNetworkEndpointsNetworkEndpointGroup(ProjectZoneNetworkEndpointGroupName networkEndpointGroup, NetworkEndpointGroupsAttachEndpointsRequest networkEndpointGroupsAttachEndpointsRequestResource) {
        AttachNetworkEndpointsNetworkEndpointGroupHttpRequest request = AttachNetworkEndpointsNetworkEndpointGroupHttpRequest.newBuilder().setNetworkEndpointGroup(networkEndpointGroup == null ? null : networkEndpointGroup.toString()).setNetworkEndpointGroupsAttachEndpointsRequestResource(networkEndpointGroupsAttachEndpointsRequestResource).build();
        return this.attachNetworkEndpointsNetworkEndpointGroup(request);
    }

    @BetaApi
    public final Operation attachNetworkEndpointsNetworkEndpointGroup(String networkEndpointGroup, NetworkEndpointGroupsAttachEndpointsRequest networkEndpointGroupsAttachEndpointsRequestResource) {
        AttachNetworkEndpointsNetworkEndpointGroupHttpRequest request = AttachNetworkEndpointsNetworkEndpointGroupHttpRequest.newBuilder().setNetworkEndpointGroup(networkEndpointGroup).setNetworkEndpointGroupsAttachEndpointsRequestResource(networkEndpointGroupsAttachEndpointsRequestResource).build();
        return this.attachNetworkEndpointsNetworkEndpointGroup(request);
    }

    @BetaApi
    public final Operation attachNetworkEndpointsNetworkEndpointGroup(AttachNetworkEndpointsNetworkEndpointGroupHttpRequest request) {
        return (Operation)this.attachNetworkEndpointsNetworkEndpointGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<AttachNetworkEndpointsNetworkEndpointGroupHttpRequest, Operation> attachNetworkEndpointsNetworkEndpointGroupCallable() {
        return this.stub.attachNetworkEndpointsNetworkEndpointGroupCallable();
    }

    @BetaApi
    public final Operation deleteNetworkEndpointGroup(ProjectZoneNetworkEndpointGroupName networkEndpointGroup) {
        DeleteNetworkEndpointGroupHttpRequest request = DeleteNetworkEndpointGroupHttpRequest.newBuilder().setNetworkEndpointGroup(networkEndpointGroup == null ? null : networkEndpointGroup.toString()).build();
        return this.deleteNetworkEndpointGroup(request);
    }

    @BetaApi
    public final Operation deleteNetworkEndpointGroup(String networkEndpointGroup) {
        DeleteNetworkEndpointGroupHttpRequest request = DeleteNetworkEndpointGroupHttpRequest.newBuilder().setNetworkEndpointGroup(networkEndpointGroup).build();
        return this.deleteNetworkEndpointGroup(request);
    }

    @BetaApi
    public final Operation deleteNetworkEndpointGroup(DeleteNetworkEndpointGroupHttpRequest request) {
        return (Operation)this.deleteNetworkEndpointGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteNetworkEndpointGroupHttpRequest, Operation> deleteNetworkEndpointGroupCallable() {
        return this.stub.deleteNetworkEndpointGroupCallable();
    }

    @BetaApi
    public final Operation detachNetworkEndpointsNetworkEndpointGroup(ProjectZoneNetworkEndpointGroupName networkEndpointGroup, NetworkEndpointGroupsDetachEndpointsRequest networkEndpointGroupsDetachEndpointsRequestResource) {
        DetachNetworkEndpointsNetworkEndpointGroupHttpRequest request = DetachNetworkEndpointsNetworkEndpointGroupHttpRequest.newBuilder().setNetworkEndpointGroup(networkEndpointGroup == null ? null : networkEndpointGroup.toString()).setNetworkEndpointGroupsDetachEndpointsRequestResource(networkEndpointGroupsDetachEndpointsRequestResource).build();
        return this.detachNetworkEndpointsNetworkEndpointGroup(request);
    }

    @BetaApi
    public final Operation detachNetworkEndpointsNetworkEndpointGroup(String networkEndpointGroup, NetworkEndpointGroupsDetachEndpointsRequest networkEndpointGroupsDetachEndpointsRequestResource) {
        DetachNetworkEndpointsNetworkEndpointGroupHttpRequest request = DetachNetworkEndpointsNetworkEndpointGroupHttpRequest.newBuilder().setNetworkEndpointGroup(networkEndpointGroup).setNetworkEndpointGroupsDetachEndpointsRequestResource(networkEndpointGroupsDetachEndpointsRequestResource).build();
        return this.detachNetworkEndpointsNetworkEndpointGroup(request);
    }

    @BetaApi
    public final Operation detachNetworkEndpointsNetworkEndpointGroup(DetachNetworkEndpointsNetworkEndpointGroupHttpRequest request) {
        return (Operation)this.detachNetworkEndpointsNetworkEndpointGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DetachNetworkEndpointsNetworkEndpointGroupHttpRequest, Operation> detachNetworkEndpointsNetworkEndpointGroupCallable() {
        return this.stub.detachNetworkEndpointsNetworkEndpointGroupCallable();
    }

    @BetaApi
    public final NetworkEndpointGroup getNetworkEndpointGroup(ProjectZoneNetworkEndpointGroupName networkEndpointGroup) {
        GetNetworkEndpointGroupHttpRequest request = GetNetworkEndpointGroupHttpRequest.newBuilder().setNetworkEndpointGroup(networkEndpointGroup == null ? null : networkEndpointGroup.toString()).build();
        return this.getNetworkEndpointGroup(request);
    }

    @BetaApi
    public final NetworkEndpointGroup getNetworkEndpointGroup(String networkEndpointGroup) {
        GetNetworkEndpointGroupHttpRequest request = GetNetworkEndpointGroupHttpRequest.newBuilder().setNetworkEndpointGroup(networkEndpointGroup).build();
        return this.getNetworkEndpointGroup(request);
    }

    @BetaApi
    public final NetworkEndpointGroup getNetworkEndpointGroup(GetNetworkEndpointGroupHttpRequest request) {
        return (NetworkEndpointGroup)this.getNetworkEndpointGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetNetworkEndpointGroupHttpRequest, NetworkEndpointGroup> getNetworkEndpointGroupCallable() {
        return this.stub.getNetworkEndpointGroupCallable();
    }

    @BetaApi
    public final Operation insertNetworkEndpointGroup(ProjectZoneName zone, NetworkEndpointGroup networkEndpointGroupResource) {
        InsertNetworkEndpointGroupHttpRequest request = InsertNetworkEndpointGroupHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).setNetworkEndpointGroupResource(networkEndpointGroupResource).build();
        return this.insertNetworkEndpointGroup(request);
    }

    @BetaApi
    public final Operation insertNetworkEndpointGroup(String zone, NetworkEndpointGroup networkEndpointGroupResource) {
        InsertNetworkEndpointGroupHttpRequest request = InsertNetworkEndpointGroupHttpRequest.newBuilder().setZone(zone).setNetworkEndpointGroupResource(networkEndpointGroupResource).build();
        return this.insertNetworkEndpointGroup(request);
    }

    @BetaApi
    public final Operation insertNetworkEndpointGroup(InsertNetworkEndpointGroupHttpRequest request) {
        return (Operation)this.insertNetworkEndpointGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertNetworkEndpointGroupHttpRequest, Operation> insertNetworkEndpointGroupCallable() {
        return this.stub.insertNetworkEndpointGroupCallable();
    }

    @BetaApi
    public final ListNetworkEndpointGroupsPagedResponse listNetworkEndpointGroups(ProjectZoneName zone) {
        ListNetworkEndpointGroupsHttpRequest request = ListNetworkEndpointGroupsHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).build();
        return this.listNetworkEndpointGroups(request);
    }

    @BetaApi
    public final ListNetworkEndpointGroupsPagedResponse listNetworkEndpointGroups(String zone) {
        ListNetworkEndpointGroupsHttpRequest request = ListNetworkEndpointGroupsHttpRequest.newBuilder().setZone(zone).build();
        return this.listNetworkEndpointGroups(request);
    }

    @BetaApi
    public final ListNetworkEndpointGroupsPagedResponse listNetworkEndpointGroups(ListNetworkEndpointGroupsHttpRequest request) {
        return (ListNetworkEndpointGroupsPagedResponse)((Object)this.listNetworkEndpointGroupsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListNetworkEndpointGroupsHttpRequest, ListNetworkEndpointGroupsPagedResponse> listNetworkEndpointGroupsPagedCallable() {
        return this.stub.listNetworkEndpointGroupsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList> listNetworkEndpointGroupsCallable() {
        return this.stub.listNetworkEndpointGroupsCallable();
    }

    @BetaApi
    public final ListNetworkEndpointsNetworkEndpointGroupsPagedResponse listNetworkEndpointsNetworkEndpointGroups(ProjectZoneNetworkEndpointGroupName networkEndpointGroup, NetworkEndpointGroupsListEndpointsRequest networkEndpointGroupsListEndpointsRequestResource) {
        ListNetworkEndpointsNetworkEndpointGroupsHttpRequest request = ListNetworkEndpointsNetworkEndpointGroupsHttpRequest.newBuilder().setNetworkEndpointGroup(networkEndpointGroup == null ? null : networkEndpointGroup.toString()).setNetworkEndpointGroupsListEndpointsRequestResource(networkEndpointGroupsListEndpointsRequestResource).build();
        return this.listNetworkEndpointsNetworkEndpointGroups(request);
    }

    @BetaApi
    public final ListNetworkEndpointsNetworkEndpointGroupsPagedResponse listNetworkEndpointsNetworkEndpointGroups(String networkEndpointGroup, NetworkEndpointGroupsListEndpointsRequest networkEndpointGroupsListEndpointsRequestResource) {
        ListNetworkEndpointsNetworkEndpointGroupsHttpRequest request = ListNetworkEndpointsNetworkEndpointGroupsHttpRequest.newBuilder().setNetworkEndpointGroup(networkEndpointGroup).setNetworkEndpointGroupsListEndpointsRequestResource(networkEndpointGroupsListEndpointsRequestResource).build();
        return this.listNetworkEndpointsNetworkEndpointGroups(request);
    }

    @BetaApi
    public final ListNetworkEndpointsNetworkEndpointGroupsPagedResponse listNetworkEndpointsNetworkEndpointGroups(ListNetworkEndpointsNetworkEndpointGroupsHttpRequest request) {
        return (ListNetworkEndpointsNetworkEndpointGroupsPagedResponse)((Object)this.listNetworkEndpointsNetworkEndpointGroupsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, ListNetworkEndpointsNetworkEndpointGroupsPagedResponse> listNetworkEndpointsNetworkEndpointGroupsPagedCallable() {
        return this.stub.listNetworkEndpointsNetworkEndpointGroupsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints> listNetworkEndpointsNetworkEndpointGroupsCallable() {
        return this.stub.listNetworkEndpointsNetworkEndpointGroupsCallable();
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsNetworkEndpointGroup(ProjectZoneNetworkEndpointGroupResourceName resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsNetworkEndpointGroupHttpRequest request = TestIamPermissionsNetworkEndpointGroupHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsNetworkEndpointGroup(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsNetworkEndpointGroup(String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsNetworkEndpointGroupHttpRequest request = TestIamPermissionsNetworkEndpointGroupHttpRequest.newBuilder().setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsNetworkEndpointGroup(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsNetworkEndpointGroup(TestIamPermissionsNetworkEndpointGroupHttpRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsNetworkEndpointGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<TestIamPermissionsNetworkEndpointGroupHttpRequest, TestPermissionsResponse> testIamPermissionsNetworkEndpointGroupCallable() {
        return this.stub.testIamPermissionsNetworkEndpointGroupCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListNetworkEndpointsNetworkEndpointGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus, ListNetworkEndpointsNetworkEndpointGroupsPage, ListNetworkEndpointsNetworkEndpointGroupsFixedSizeCollection> {
        private ListNetworkEndpointsNetworkEndpointGroupsFixedSizeCollection(List<ListNetworkEndpointsNetworkEndpointGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNetworkEndpointsNetworkEndpointGroupsFixedSizeCollection createEmptyCollection() {
            return new ListNetworkEndpointsNetworkEndpointGroupsFixedSizeCollection(null, 0);
        }

        protected ListNetworkEndpointsNetworkEndpointGroupsFixedSizeCollection createCollection(List<ListNetworkEndpointsNetworkEndpointGroupsPage> pages, int collectionSize) {
            return new ListNetworkEndpointsNetworkEndpointGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNetworkEndpointsNetworkEndpointGroupsPage
    extends AbstractPage<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus, ListNetworkEndpointsNetworkEndpointGroupsPage> {
        private ListNetworkEndpointsNetworkEndpointGroupsPage(PageContext<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus> context, NetworkEndpointGroupsListNetworkEndpoints response) {
            super(context, (Object)response);
        }

        private static ListNetworkEndpointsNetworkEndpointGroupsPage createEmptyPage() {
            return new ListNetworkEndpointsNetworkEndpointGroupsPage(null, null);
        }

        protected ListNetworkEndpointsNetworkEndpointGroupsPage createPage(PageContext<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus> context, NetworkEndpointGroupsListNetworkEndpoints response) {
            return new ListNetworkEndpointsNetworkEndpointGroupsPage(context, response);
        }

        public ApiFuture<ListNetworkEndpointsNetworkEndpointGroupsPage> createPageAsync(PageContext<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus> context, ApiFuture<NetworkEndpointGroupsListNetworkEndpoints> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNetworkEndpointsNetworkEndpointGroupsPagedResponse
    extends AbstractPagedListResponse<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus, ListNetworkEndpointsNetworkEndpointGroupsPage, ListNetworkEndpointsNetworkEndpointGroupsFixedSizeCollection> {
        public static ApiFuture<ListNetworkEndpointsNetworkEndpointGroupsPagedResponse> createAsync(PageContext<ListNetworkEndpointsNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus> context, ApiFuture<NetworkEndpointGroupsListNetworkEndpoints> futureResponse) {
            ApiFuture<ListNetworkEndpointsNetworkEndpointGroupsPage> futurePage = ListNetworkEndpointsNetworkEndpointGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListNetworkEndpointsNetworkEndpointGroupsPage, ListNetworkEndpointsNetworkEndpointGroupsPagedResponse>(){

                public ListNetworkEndpointsNetworkEndpointGroupsPagedResponse apply(ListNetworkEndpointsNetworkEndpointGroupsPage input) {
                    return new ListNetworkEndpointsNetworkEndpointGroupsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListNetworkEndpointsNetworkEndpointGroupsPagedResponse(ListNetworkEndpointsNetworkEndpointGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNetworkEndpointsNetworkEndpointGroupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNetworkEndpointGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup, ListNetworkEndpointGroupsPage, ListNetworkEndpointGroupsFixedSizeCollection> {
        private ListNetworkEndpointGroupsFixedSizeCollection(List<ListNetworkEndpointGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNetworkEndpointGroupsFixedSizeCollection createEmptyCollection() {
            return new ListNetworkEndpointGroupsFixedSizeCollection(null, 0);
        }

        protected ListNetworkEndpointGroupsFixedSizeCollection createCollection(List<ListNetworkEndpointGroupsPage> pages, int collectionSize) {
            return new ListNetworkEndpointGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNetworkEndpointGroupsPage
    extends AbstractPage<ListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup, ListNetworkEndpointGroupsPage> {
        private ListNetworkEndpointGroupsPage(PageContext<ListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, NetworkEndpointGroupList response) {
            super(context, (Object)response);
        }

        private static ListNetworkEndpointGroupsPage createEmptyPage() {
            return new ListNetworkEndpointGroupsPage(null, null);
        }

        protected ListNetworkEndpointGroupsPage createPage(PageContext<ListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, NetworkEndpointGroupList response) {
            return new ListNetworkEndpointGroupsPage(context, response);
        }

        public ApiFuture<ListNetworkEndpointGroupsPage> createPageAsync(PageContext<ListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, ApiFuture<NetworkEndpointGroupList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNetworkEndpointGroupsPagedResponse
    extends AbstractPagedListResponse<ListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup, ListNetworkEndpointGroupsPage, ListNetworkEndpointGroupsFixedSizeCollection> {
        public static ApiFuture<ListNetworkEndpointGroupsPagedResponse> createAsync(PageContext<ListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup> context, ApiFuture<NetworkEndpointGroupList> futureResponse) {
            ApiFuture<ListNetworkEndpointGroupsPage> futurePage = ListNetworkEndpointGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListNetworkEndpointGroupsPage, ListNetworkEndpointGroupsPagedResponse>(){

                public ListNetworkEndpointGroupsPagedResponse apply(ListNetworkEndpointGroupsPage input) {
                    return new ListNetworkEndpointGroupsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListNetworkEndpointGroupsPagedResponse(ListNetworkEndpointGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNetworkEndpointGroupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListNetworkEndpointGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupsScopedList, AggregatedListNetworkEndpointGroupsPage, AggregatedListNetworkEndpointGroupsFixedSizeCollection> {
        private AggregatedListNetworkEndpointGroupsFixedSizeCollection(List<AggregatedListNetworkEndpointGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListNetworkEndpointGroupsFixedSizeCollection createEmptyCollection() {
            return new AggregatedListNetworkEndpointGroupsFixedSizeCollection(null, 0);
        }

        protected AggregatedListNetworkEndpointGroupsFixedSizeCollection createCollection(List<AggregatedListNetworkEndpointGroupsPage> pages, int collectionSize) {
            return new AggregatedListNetworkEndpointGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListNetworkEndpointGroupsPage
    extends AbstractPage<AggregatedListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupsScopedList, AggregatedListNetworkEndpointGroupsPage> {
        private AggregatedListNetworkEndpointGroupsPage(PageContext<AggregatedListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupsScopedList> context, NetworkEndpointGroupAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListNetworkEndpointGroupsPage createEmptyPage() {
            return new AggregatedListNetworkEndpointGroupsPage(null, null);
        }

        protected AggregatedListNetworkEndpointGroupsPage createPage(PageContext<AggregatedListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupsScopedList> context, NetworkEndpointGroupAggregatedList response) {
            return new AggregatedListNetworkEndpointGroupsPage(context, response);
        }

        public ApiFuture<AggregatedListNetworkEndpointGroupsPage> createPageAsync(PageContext<AggregatedListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupsScopedList> context, ApiFuture<NetworkEndpointGroupAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListNetworkEndpointGroupsPagedResponse
    extends AbstractPagedListResponse<AggregatedListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupsScopedList, AggregatedListNetworkEndpointGroupsPage, AggregatedListNetworkEndpointGroupsFixedSizeCollection> {
        public static ApiFuture<AggregatedListNetworkEndpointGroupsPagedResponse> createAsync(PageContext<AggregatedListNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupsScopedList> context, ApiFuture<NetworkEndpointGroupAggregatedList> futureResponse) {
            ApiFuture<AggregatedListNetworkEndpointGroupsPage> futurePage = AggregatedListNetworkEndpointGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListNetworkEndpointGroupsPage, AggregatedListNetworkEndpointGroupsPagedResponse>(){

                public AggregatedListNetworkEndpointGroupsPagedResponse apply(AggregatedListNetworkEndpointGroupsPage input) {
                    return new AggregatedListNetworkEndpointGroupsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListNetworkEndpointGroupsPagedResponse(AggregatedListNetworkEndpointGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListNetworkEndpointGroupsFixedSizeCollection.createEmptyCollection());
        }
    }
}

