/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class NetworkEndpointGroup
implements ApiMessage {
    private final String creationTimestamp;
    private final Integer defaultPort;
    private final String description;
    private final String id;
    private final String kind;
    private final String name;
    private final String network;
    private final String networkEndpointType;
    private final String selfLink;
    private final Integer size;
    private final String subnetwork;
    private final String zone;
    private static final NetworkEndpointGroup DEFAULT_INSTANCE = new NetworkEndpointGroup();

    private NetworkEndpointGroup() {
        this.creationTimestamp = null;
        this.defaultPort = null;
        this.description = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.network = null;
        this.networkEndpointType = null;
        this.selfLink = null;
        this.size = null;
        this.subnetwork = null;
        this.zone = null;
    }

    private NetworkEndpointGroup(String creationTimestamp, Integer defaultPort, String description, String id, String kind, String name, String network, String networkEndpointType, String selfLink, Integer size, String subnetwork, String zone) {
        this.creationTimestamp = creationTimestamp;
        this.defaultPort = defaultPort;
        this.description = description;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.network = network;
        this.networkEndpointType = networkEndpointType;
        this.selfLink = selfLink;
        this.size = size;
        this.subnetwork = subnetwork;
        this.zone = zone;
    }

    public Object getFieldValue(String fieldName) {
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("defaultPort".equals(fieldName)) {
            return this.defaultPort;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("network".equals(fieldName)) {
            return this.network;
        }
        if ("networkEndpointType".equals(fieldName)) {
            return this.networkEndpointType;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("size".equals(fieldName)) {
            return this.size;
        }
        if ("subnetwork".equals(fieldName)) {
            return this.subnetwork;
        }
        if ("zone".equals(fieldName)) {
            return this.zone;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public Integer getDefaultPort() {
        return this.defaultPort;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getNetworkEndpointType() {
        return this.networkEndpointType;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public Integer getSize() {
        return this.size;
    }

    public String getSubnetwork() {
        return this.subnetwork;
    }

    public String getZone() {
        return this.zone;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NetworkEndpointGroup prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static NetworkEndpointGroup getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "NetworkEndpointGroup{creationTimestamp=" + this.creationTimestamp + ", defaultPort=" + this.defaultPort + ", description=" + this.description + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", network=" + this.network + ", networkEndpointType=" + this.networkEndpointType + ", selfLink=" + this.selfLink + ", size=" + this.size + ", subnetwork=" + this.subnetwork + ", zone=" + this.zone + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NetworkEndpointGroup) {
            NetworkEndpointGroup that = (NetworkEndpointGroup)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.defaultPort, that.getDefaultPort()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.network, that.getNetwork()) && Objects.equals(this.networkEndpointType, that.getNetworkEndpointType()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.size, that.getSize()) && Objects.equals(this.subnetwork, that.getSubnetwork()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.defaultPort, this.description, this.id, this.kind, this.name, this.network, this.networkEndpointType, this.selfLink, this.size, this.subnetwork, this.zone);
    }

    public static class Builder {
        private String creationTimestamp;
        private Integer defaultPort;
        private String description;
        private String id;
        private String kind;
        private String name;
        private String network;
        private String networkEndpointType;
        private String selfLink;
        private Integer size;
        private String subnetwork;
        private String zone;

        Builder() {
        }

        public Builder mergeFrom(NetworkEndpointGroup other) {
            if (other == NetworkEndpointGroup.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDefaultPort() != null) {
                this.defaultPort = other.defaultPort;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNetwork() != null) {
                this.network = other.network;
            }
            if (other.getNetworkEndpointType() != null) {
                this.networkEndpointType = other.networkEndpointType;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getSize() != null) {
                this.size = other.size;
            }
            if (other.getSubnetwork() != null) {
                this.subnetwork = other.subnetwork;
            }
            if (other.getZone() != null) {
                this.zone = other.zone;
            }
            return this;
        }

        Builder(NetworkEndpointGroup source) {
            this.creationTimestamp = source.creationTimestamp;
            this.defaultPort = source.defaultPort;
            this.description = source.description;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.network = source.network;
            this.networkEndpointType = source.networkEndpointType;
            this.selfLink = source.selfLink;
            this.size = source.size;
            this.subnetwork = source.subnetwork;
            this.zone = source.zone;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public Integer getDefaultPort() {
            return this.defaultPort;
        }

        public Builder setDefaultPort(Integer defaultPort) {
            this.defaultPort = defaultPort;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getNetwork() {
            return this.network;
        }

        public Builder setNetwork(String network) {
            this.network = network;
            return this;
        }

        public String getNetworkEndpointType() {
            return this.networkEndpointType;
        }

        public Builder setNetworkEndpointType(String networkEndpointType) {
            this.networkEndpointType = networkEndpointType;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public Integer getSize() {
            return this.size;
        }

        public Builder setSize(Integer size) {
            this.size = size;
            return this;
        }

        public String getSubnetwork() {
            return this.subnetwork;
        }

        public Builder setSubnetwork(String subnetwork) {
            this.subnetwork = subnetwork;
            return this;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public NetworkEndpointGroup build() {
            return new NetworkEndpointGroup(this.creationTimestamp, this.defaultPort, this.description, this.id, this.kind, this.name, this.network, this.networkEndpointType, this.selfLink, this.size, this.subnetwork, this.zone);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDefaultPort(this.defaultPort);
            newBuilder.setDescription(this.description);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setNetwork(this.network);
            newBuilder.setNetworkEndpointType(this.networkEndpointType);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setSize(this.size);
            newBuilder.setSubnetwork(this.subnetwork);
            newBuilder.setZone(this.zone);
            return newBuilder;
        }
    }
}

