/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.billing.v1.BillingAccount;
import com.google.cloud.billing.v1.CloudBillingClient;
import com.google.cloud.billing.v1.CreateBillingAccountRequest;
import com.google.cloud.billing.v1.GetBillingAccountRequest;
import com.google.cloud.billing.v1.GetProjectBillingInfoRequest;
import com.google.cloud.billing.v1.ListBillingAccountsRequest;
import com.google.cloud.billing.v1.ListBillingAccountsResponse;
import com.google.cloud.billing.v1.ListProjectBillingInfoRequest;
import com.google.cloud.billing.v1.ListProjectBillingInfoResponse;
import com.google.cloud.billing.v1.MoveBillingAccountRequest;
import com.google.cloud.billing.v1.ProjectBillingInfo;
import com.google.cloud.billing.v1.UpdateBillingAccountRequest;
import com.google.cloud.billing.v1.UpdateProjectBillingInfoRequest;
import com.google.cloud.billing.v1.stub.CloudBillingStub;
import com.google.cloud.billing.v1.stub.CloudBillingStubSettings;
import com.google.cloud.billing.v1.stub.GrpcCloudBillingCallableFactory;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcCloudBillingStub
extends CloudBillingStub {
    private static final MethodDescriptor<GetBillingAccountRequest, BillingAccount> getBillingAccountMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.billing.v1.CloudBilling/GetBillingAccount").setRequestMarshaller(ProtoUtils.marshaller((Message)GetBillingAccountRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BillingAccount.getDefaultInstance())).build();
    private static final MethodDescriptor<ListBillingAccountsRequest, ListBillingAccountsResponse> listBillingAccountsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.billing.v1.CloudBilling/ListBillingAccounts").setRequestMarshaller(ProtoUtils.marshaller((Message)ListBillingAccountsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListBillingAccountsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateBillingAccountRequest, BillingAccount> updateBillingAccountMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.billing.v1.CloudBilling/UpdateBillingAccount").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateBillingAccountRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BillingAccount.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateBillingAccountRequest, BillingAccount> createBillingAccountMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.billing.v1.CloudBilling/CreateBillingAccount").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateBillingAccountRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BillingAccount.getDefaultInstance())).build();
    private static final MethodDescriptor<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse> listProjectBillingInfoMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.billing.v1.CloudBilling/ListProjectBillingInfo").setRequestMarshaller(ProtoUtils.marshaller((Message)ListProjectBillingInfoRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListProjectBillingInfoResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetProjectBillingInfoRequest, ProjectBillingInfo> getProjectBillingInfoMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.billing.v1.CloudBilling/GetProjectBillingInfo").setRequestMarshaller(ProtoUtils.marshaller((Message)GetProjectBillingInfoRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ProjectBillingInfo.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateProjectBillingInfoRequest, ProjectBillingInfo> updateProjectBillingInfoMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.billing.v1.CloudBilling/UpdateProjectBillingInfo").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateProjectBillingInfoRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ProjectBillingInfo.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.billing.v1.CloudBilling/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.billing.v1.CloudBilling/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.billing.v1.CloudBilling/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<MoveBillingAccountRequest, BillingAccount> moveBillingAccountMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.billing.v1.CloudBilling/MoveBillingAccount").setRequestMarshaller(ProtoUtils.marshaller((Message)MoveBillingAccountRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BillingAccount.getDefaultInstance())).build();
    private final UnaryCallable<GetBillingAccountRequest, BillingAccount> getBillingAccountCallable;
    private final UnaryCallable<ListBillingAccountsRequest, ListBillingAccountsResponse> listBillingAccountsCallable;
    private final UnaryCallable<ListBillingAccountsRequest, CloudBillingClient.ListBillingAccountsPagedResponse> listBillingAccountsPagedCallable;
    private final UnaryCallable<UpdateBillingAccountRequest, BillingAccount> updateBillingAccountCallable;
    private final UnaryCallable<CreateBillingAccountRequest, BillingAccount> createBillingAccountCallable;
    private final UnaryCallable<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse> listProjectBillingInfoCallable;
    private final UnaryCallable<ListProjectBillingInfoRequest, CloudBillingClient.ListProjectBillingInfoPagedResponse> listProjectBillingInfoPagedCallable;
    private final UnaryCallable<GetProjectBillingInfoRequest, ProjectBillingInfo> getProjectBillingInfoCallable;
    private final UnaryCallable<UpdateProjectBillingInfoRequest, ProjectBillingInfo> updateProjectBillingInfoCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final UnaryCallable<MoveBillingAccountRequest, BillingAccount> moveBillingAccountCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCloudBillingStub create(CloudBillingStubSettings settings) throws IOException {
        return new GrpcCloudBillingStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCloudBillingStub create(ClientContext clientContext) throws IOException {
        return new GrpcCloudBillingStub(CloudBillingStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCloudBillingStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCloudBillingStub(CloudBillingStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCloudBillingStub(CloudBillingStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCloudBillingCallableFactory());
    }

    protected GrpcCloudBillingStub(CloudBillingStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getBillingAccountTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getBillingAccountMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listBillingAccountsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listBillingAccountsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateBillingAccountTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateBillingAccountMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createBillingAccountTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createBillingAccountMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listProjectBillingInfoTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listProjectBillingInfoMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getProjectBillingInfoTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getProjectBillingInfoMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateProjectBillingInfoTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateProjectBillingInfoMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings moveBillingAccountTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(moveBillingAccountMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("destination_parent", String.valueOf(request.getDestinationParent()));
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.getBillingAccountCallable = callableFactory.createUnaryCallable(getBillingAccountTransportSettings, settings.getBillingAccountSettings(), clientContext);
        this.listBillingAccountsCallable = callableFactory.createUnaryCallable(listBillingAccountsTransportSettings, settings.listBillingAccountsSettings(), clientContext);
        this.listBillingAccountsPagedCallable = callableFactory.createPagedCallable(listBillingAccountsTransportSettings, settings.listBillingAccountsSettings(), clientContext);
        this.updateBillingAccountCallable = callableFactory.createUnaryCallable(updateBillingAccountTransportSettings, settings.updateBillingAccountSettings(), clientContext);
        this.createBillingAccountCallable = callableFactory.createUnaryCallable(createBillingAccountTransportSettings, settings.createBillingAccountSettings(), clientContext);
        this.listProjectBillingInfoCallable = callableFactory.createUnaryCallable(listProjectBillingInfoTransportSettings, settings.listProjectBillingInfoSettings(), clientContext);
        this.listProjectBillingInfoPagedCallable = callableFactory.createPagedCallable(listProjectBillingInfoTransportSettings, settings.listProjectBillingInfoSettings(), clientContext);
        this.getProjectBillingInfoCallable = callableFactory.createUnaryCallable(getProjectBillingInfoTransportSettings, settings.getProjectBillingInfoSettings(), clientContext);
        this.updateProjectBillingInfoCallable = callableFactory.createUnaryCallable(updateProjectBillingInfoTransportSettings, settings.updateProjectBillingInfoSettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.moveBillingAccountCallable = callableFactory.createUnaryCallable(moveBillingAccountTransportSettings, settings.moveBillingAccountSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetBillingAccountRequest, BillingAccount> getBillingAccountCallable() {
        return this.getBillingAccountCallable;
    }

    @Override
    public UnaryCallable<ListBillingAccountsRequest, ListBillingAccountsResponse> listBillingAccountsCallable() {
        return this.listBillingAccountsCallable;
    }

    @Override
    public UnaryCallable<ListBillingAccountsRequest, CloudBillingClient.ListBillingAccountsPagedResponse> listBillingAccountsPagedCallable() {
        return this.listBillingAccountsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateBillingAccountRequest, BillingAccount> updateBillingAccountCallable() {
        return this.updateBillingAccountCallable;
    }

    @Override
    public UnaryCallable<CreateBillingAccountRequest, BillingAccount> createBillingAccountCallable() {
        return this.createBillingAccountCallable;
    }

    @Override
    public UnaryCallable<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse> listProjectBillingInfoCallable() {
        return this.listProjectBillingInfoCallable;
    }

    @Override
    public UnaryCallable<ListProjectBillingInfoRequest, CloudBillingClient.ListProjectBillingInfoPagedResponse> listProjectBillingInfoPagedCallable() {
        return this.listProjectBillingInfoPagedCallable;
    }

    @Override
    public UnaryCallable<GetProjectBillingInfoRequest, ProjectBillingInfo> getProjectBillingInfoCallable() {
        return this.getProjectBillingInfoCallable;
    }

    @Override
    public UnaryCallable<UpdateProjectBillingInfoRequest, ProjectBillingInfo> updateProjectBillingInfoCallable() {
        return this.updateProjectBillingInfoCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public UnaryCallable<MoveBillingAccountRequest, BillingAccount> moveBillingAccountCallable() {
        return this.moveBillingAccountCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

