/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.mutaterows;

import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.RetryingExecutor;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsAttemptCallable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;

@InternalApi
public class MutateRowsRetryingCallable
extends UnaryCallable<MutateRowsRequest, Void> {
    private final ApiCallContext callContextPrototype;
    private final ServerStreamingCallable<MutateRowsRequest, MutateRowsResponse> callable;
    private final RetryingExecutor<Void> executor;
    private final ImmutableSet<StatusCode.Code> retryCodes;

    public MutateRowsRetryingCallable(@Nonnull ApiCallContext callContextPrototype, @Nonnull ServerStreamingCallable<MutateRowsRequest, MutateRowsResponse> callable, @Nonnull RetryingExecutor<Void> executor, @Nonnull Set<StatusCode.Code> retryCodes) {
        this.callContextPrototype = (ApiCallContext)Preconditions.checkNotNull((Object)callContextPrototype);
        this.callable = (ServerStreamingCallable)Preconditions.checkNotNull(callable);
        this.executor = (RetryingExecutor)Preconditions.checkNotNull(executor);
        this.retryCodes = ImmutableSet.copyOf(retryCodes);
    }

    public RetryingFuture<Void> futureCall(MutateRowsRequest request, ApiCallContext inputContext) {
        ApiCallContext context = this.callContextPrototype.nullToSelf(inputContext);
        MutateRowsAttemptCallable retryCallable = new MutateRowsAttemptCallable((UnaryCallable<MutateRowsRequest, List<MutateRowsResponse>>)this.callable.all(), request, context, (Set<StatusCode.Code>)this.retryCodes);
        RetryingFuture retryingFuture = this.executor.createFuture((Callable)retryCallable);
        retryCallable.setExternalFuture((RetryingFuture<Void>)retryingFuture);
        retryCallable.call();
        return retryingFuture;
    }

    public String toString() {
        return String.format("retrying(%s)", this.callable);
    }
}

