/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.cloud.bigtable.data.v2.models.AutoValue_Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;

@InternalExtensionOnly
public abstract class Row
implements Comparable<Row>,
Serializable {
    @InternalApi
    public static Row create(ByteString key, List<RowCell> cells) {
        return new AutoValue_Row(key, cells);
    }

    @Nonnull
    public abstract ByteString getKey();

    public abstract List<RowCell> getCells();

    @Override
    public int compareTo(@Nonnull Row row) {
        int sizeA = this.getKey().size();
        int sizeB = row.getKey().size();
        int size = Math.min(sizeA, sizeB);
        for (int i = 0; i < size; ++i) {
            int byteB;
            int byteA = this.getKey().byteAt(i) & 0xFF;
            if (byteA == (byteB = row.getKey().byteAt(i) & 0xFF)) continue;
            return byteA < byteB ? -1 : 1;
        }
        if (sizeA == sizeB) {
            return 0;
        }
        return sizeA < sizeB ? -1 : 1;
    }
}

