/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.bigtable.admin.v2.ProjectName;
import com.google.cloud.bigtable.admin.v2.stub.BigtableInstanceAdminStubSettings;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class BigtableInstanceAdminSettings {
    private final String projectId;
    private final BigtableInstanceAdminStubSettings stubSettings;

    private BigtableInstanceAdminSettings(Builder builder) throws IOException {
        Preconditions.checkNotNull((Object)builder.projectId, (Object)"Project ud must be set");
        Verify.verifyNotNull((Object)((Object)builder.stubSettings), (String)"stubSettings should never be null", (Object[])new Object[0]);
        this.projectId = builder.projectId;
        this.stubSettings = builder.stubSettings.build();
    }

    @Nonnull
    public String getProjectId() {
        return this.projectId;
    }

    @Deprecated
    @Nonnull
    public ProjectName getProjectName() {
        return ProjectName.of((String)this.projectId);
    }

    @Nonnull
    public BigtableInstanceAdminStubSettings getStubSettings() {
        return this.stubSettings;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private String projectId;
        private final BigtableInstanceAdminStubSettings.Builder stubSettings;

        private Builder() {
            this.stubSettings = BigtableInstanceAdminStubSettings.newBuilder();
        }

        private Builder(BigtableInstanceAdminSettings settings) {
            this.projectId = settings.projectId;
            this.stubSettings = settings.stubSettings.toBuilder();
        }

        public Builder setProjectId(@Nonnull String projectId) {
            Preconditions.checkNotNull((Object)projectId);
            this.projectId = projectId;
            return this;
        }

        @Nullable
        public String getProjectId() {
            return this.projectId;
        }

        @Deprecated
        public Builder setProjectName(@Nonnull ProjectName projectName) {
            return this.setProjectId(projectName.getProject());
        }

        @Deprecated
        @Nullable
        public ProjectName getProjectName() {
            if (this.projectId != null) {
                return ProjectName.of((String)this.projectId);
            }
            return null;
        }

        public BigtableInstanceAdminStubSettings.Builder stubSettings() {
            return this.stubSettings;
        }

        public BigtableInstanceAdminSettings build() throws IOException {
            return new BigtableInstanceAdminSettings(this);
        }
    }
}

