/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.pathtemplate.ValidationException;
import com.google.cloud.bigquery.storage.v1.BigDecimalByteStringEncoder;
import com.google.cloud.bigquery.storage.v1.BigQuerySchemaUtil;
import com.google.cloud.bigquery.storage.v1.CivilTimeEncoder;
import com.google.cloud.bigquery.storage.v1.Exceptions;
import com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.cloud.bigquery.storage.v1.ToProtoConverter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UninitializedMessageException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonToProtoMessage
implements ToProtoConverter<Object> {
    public static final JsonToProtoMessage INSTANCE = new JsonToProtoMessage();
    private static final int NUMERIC_SCALE = 9;
    private static final ImmutableMap<Descriptors.FieldDescriptor.Type, String> FIELD_TYPE_TO_DEBUG_MESSAGE = new ImmutableMap.Builder().put((Object)Descriptors.FieldDescriptor.Type.BOOL, (Object)"boolean").put((Object)Descriptors.FieldDescriptor.Type.BYTES, (Object)"bytes").put((Object)Descriptors.FieldDescriptor.Type.INT32, (Object)"int32").put((Object)Descriptors.FieldDescriptor.Type.DOUBLE, (Object)"double").put((Object)Descriptors.FieldDescriptor.Type.INT64, (Object)"int64").put((Object)Descriptors.FieldDescriptor.Type.STRING, (Object)"string").put((Object)Descriptors.FieldDescriptor.Type.MESSAGE, (Object)"object").build();
    private static final DateTimeFormatter TO_TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().parseLenient().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').optionalEnd().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 6, 9, true).optionalEnd().optionalStart().appendOffset("+HHMM", "+00:00").optionalEnd().toFormatter().withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter FROM_TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().parseLenient().append(DateTimeFormatter.ofPattern("yyyy[/][-]MM[/][-]dd")).optionalStart().appendLiteral('T').optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().optionalStart().appendValue(ChronoField.MILLI_OF_SECOND, 3).optionalEnd().optionalStart().appendFraction(ChronoField.MICRO_OF_SECOND, 3, 6, true).optionalEnd().optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 6, 9, true).optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendZoneOrOffsetId().optionalEnd().optionalStart().appendZoneText(TextStyle.SHORT).optionalEnd().toFormatter().withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter DATETIME_FORMATTER = new DateTimeFormatterBuilder().parseLenient().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().optionalStart().parseCaseInsensitive().appendLiteral('T').optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().append(DateTimeFormatter.ISO_LOCAL_TIME).optionalEnd().parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter();
    private static final Pattern ISO8601_TIMESTAMP_HIGH_PRECISION_PATTERN = Pattern.compile("\\.(\\d{10,})(?:\\D|$)");
    private static final long MICROS_PER_SECOND = 1000000L;
    private static final int NANOS_PER_MICRO = 1000;

    public static DynamicMessage convertJsonToProtoMessage(Descriptors.Descriptor protoSchema, TableSchema tableSchema, JSONObject json, boolean ignoreUnknownFields) {
        return INSTANCE.convertToProtoMessage(protoSchema, tableSchema, json, ignoreUnknownFields);
    }

    public static DynamicMessage convertJsonToProtoMessage(Descriptors.Descriptor protoSchema, JSONObject json) {
        return INSTANCE.convertToProtoMessage(protoSchema, json);
    }

    public static DynamicMessage convertJsonToProtoMessage(Descriptors.Descriptor protoSchema, TableSchema tableSchema, JSONObject json) {
        return INSTANCE.convertToProtoMessage(protoSchema, tableSchema, json);
    }

    public DynamicMessage convertToProtoMessage(Descriptors.Descriptor protoSchema, TableSchema tableSchema, Object json, boolean ignoreUnknownFields) {
        return this.convertToProtoMessage(protoSchema, tableSchema, (JSONObject)json, ignoreUnknownFields);
    }

    @Override
    public List<DynamicMessage> convertToProtoMessage(Descriptors.Descriptor protoSchema, TableSchema tableSchema, Iterable<Object> jsonArray, boolean ignoreUnknownFields) {
        return this.convertToProtoMessage(protoSchema, tableSchema, (JSONArray)jsonArray, ignoreUnknownFields);
    }

    public DynamicMessage convertToProtoMessage(Descriptors.Descriptor protoSchema, JSONObject json) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)json, (Object)"JSONObject is null.");
        Preconditions.checkNotNull((Object)protoSchema, (Object)"Protobuf descriptor is null.");
        Preconditions.checkState((json.length() != 0 ? 1 : 0) != 0, (Object)"JSONObject is empty.");
        return this.convertToProtoMessage(protoSchema, null, json, "root", false);
    }

    public DynamicMessage convertToProtoMessage(Descriptors.Descriptor protoSchema, TableSchema tableSchema, JSONObject json) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)json, (Object)"JSONObject is null.");
        Preconditions.checkNotNull((Object)protoSchema, (Object)"Protobuf descriptor is null.");
        Preconditions.checkNotNull((Object)tableSchema, (Object)"TableSchema is null.");
        Preconditions.checkState((json.length() != 0 ? 1 : 0) != 0, (Object)"JSONObject is empty.");
        return this.convertToProtoMessage(protoSchema, (List<TableFieldSchema>)tableSchema.getFieldsList(), json, "root", false);
    }

    public DynamicMessage convertToProtoMessage(Descriptors.Descriptor protoSchema, TableSchema tableSchema, JSONObject json, boolean ignoreUnknownFields) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)json, (Object)"JSONObject is null.");
        Preconditions.checkNotNull((Object)protoSchema, (Object)"Protobuf descriptor is null.");
        Preconditions.checkNotNull((Object)tableSchema, (Object)"TableSchema is null.");
        Preconditions.checkState((json.length() != 0 ? 1 : 0) != 0, (Object)"JSONObject is empty.");
        return this.convertToProtoMessage(protoSchema, (List<TableFieldSchema>)tableSchema.getFieldsList(), json, "root", ignoreUnknownFields);
    }

    public List<DynamicMessage> convertToProtoMessage(Descriptors.Descriptor protoSchema, TableSchema tableSchema, JSONArray jsonArray, boolean ignoreUnknownFields) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)jsonArray, (Object)"jsonArray is null.");
        Preconditions.checkNotNull((Object)protoSchema, (Object)"Protobuf descriptor is null.");
        Preconditions.checkNotNull((Object)tableSchema, (Object)"tableSchema is null.");
        Preconditions.checkState((jsonArray.length() != 0 ? 1 : 0) != 0, (Object)"jsonArray is empty.");
        return this.convertToProtoMessage(protoSchema, (List<TableFieldSchema>)tableSchema.getFieldsList(), jsonArray, "root", ignoreUnknownFields);
    }

    private DynamicMessage convertToProtoMessage(Descriptors.Descriptor protoSchema, List<TableFieldSchema> tableSchema, JSONObject jsonObject, String jsonScope, boolean ignoreUnknownFields) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.put((Object)jsonObject);
        return this.convertToProtoMessage(protoSchema, tableSchema, jsonArray, jsonScope, ignoreUnknownFields).get(0);
    }

    private List<DynamicMessage> convertToProtoMessage(Descriptors.Descriptor protoSchema, List<TableFieldSchema> tableSchema, JSONArray jsonArray, String jsonScope, boolean ignoreUnknownFields) throws Exceptions.RowIndexToErrorException {
        ArrayList<DynamicMessage> messageList = new ArrayList<DynamicMessage>();
        HashMap<String, FieldDescriptorAndFieldTableSchema> jsonNameToMetadata = new HashMap<String, FieldDescriptorAndFieldTableSchema>();
        HashMap<Integer, String> rowIndexToErrorMessage = new HashMap<Integer, String>();
        boolean hasDataUnknownError = false;
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                DynamicMessage msg;
                DynamicMessage.Builder protoMsg = DynamicMessage.newBuilder((Descriptors.Descriptor)protoSchema);
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String[] jsonNames = JSONObject.getNames((JSONObject)jsonObject);
                if (jsonNames == null) {
                    messageList.add(protoMsg.build());
                    continue;
                }
                for (String jsonName : jsonNames) {
                    String currentScope = jsonScope + "." + jsonName;
                    FieldDescriptorAndFieldTableSchema fieldDescriptorAndFieldTableSchema = jsonNameToMetadata.computeIfAbsent(currentScope, k -> this.computeDescriptorAndSchema(currentScope, ignoreUnknownFields, jsonName, protoSchema, tableSchema));
                    if (fieldDescriptorAndFieldTableSchema == null) continue;
                    Descriptors.FieldDescriptor field = fieldDescriptorAndFieldTableSchema.fieldDescriptor;
                    TableFieldSchema tableFieldSchema = fieldDescriptorAndFieldTableSchema.tableFieldSchema;
                    try {
                        if (!field.isRepeated()) {
                            this.fillField(protoMsg, field, tableFieldSchema, jsonObject, jsonName, currentScope, ignoreUnknownFields);
                            continue;
                        }
                        this.fillRepeatedField(protoMsg, field, tableFieldSchema, jsonObject, jsonName, currentScope, ignoreUnknownFields);
                    }
                    catch (Exceptions.FieldParseError ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        throw new Exceptions.FieldParseError(currentScope, tableFieldSchema != null ? tableFieldSchema.getType().name() : field.getType().name(), ex);
                    }
                }
                try {
                    msg = protoMsg.build();
                }
                catch (UninitializedMessageException e) {
                    String errorMsg = e.getMessage();
                    int idxOfColon = errorMsg.indexOf(":");
                    String missingFieldName = errorMsg.substring(idxOfColon + 2);
                    throw new IllegalArgumentException(String.format("JSONObject does not have the required field %s.%s.", jsonScope, missingFieldName));
                }
                messageList.add(msg);
                continue;
            }
            catch (IllegalArgumentException exception) {
                if (exception instanceof Exceptions.DataHasUnknownFieldException) {
                    hasDataUnknownError = true;
                }
                if (exception instanceof Exceptions.FieldParseError) {
                    Exceptions.FieldParseError ex = (Exceptions.FieldParseError)exception;
                    rowIndexToErrorMessage.put(i, "Field " + ex.getFieldName() + " failed to convert to " + ex.getBqType() + ". Error: " + ex.getCause().getMessage());
                    continue;
                }
                rowIndexToErrorMessage.put(i, exception.getMessage());
            }
        }
        if (!rowIndexToErrorMessage.isEmpty()) {
            throw new Exceptions.RowIndexToErrorException(rowIndexToErrorMessage, hasDataUnknownError);
        }
        return messageList;
    }

    private FieldDescriptorAndFieldTableSchema computeDescriptorAndSchema(String currentScope, boolean ignoreUnknownFields, String jsonName, Descriptors.Descriptor protoSchema, List<TableFieldSchema> tableFieldSchemaList) {
        Descriptors.FieldDescriptor field;
        String jsonFieldLocator = jsonName.toLowerCase();
        if (!BigQuerySchemaUtil.isProtoCompatible(jsonFieldLocator)) {
            jsonFieldLocator = BigQuerySchemaUtil.generatePlaceholderFieldName(jsonFieldLocator);
        }
        if ((field = protoSchema.findFieldByName(jsonFieldLocator)) == null && !ignoreUnknownFields) {
            throw new Exceptions.DataHasUnknownFieldException(currentScope);
        }
        if (field == null) {
            return null;
        }
        TableFieldSchema fieldSchema = null;
        if (tableFieldSchemaList != null) {
            fieldSchema = tableFieldSchemaList.get(field.getIndex());
            if (fieldSchema.getType() == TableFieldSchema.Type.RANGE) {
                switch (fieldSchema.getRangeElementType().getType()) {
                    case DATE: 
                    case DATETIME: 
                    case TIMESTAMP: {
                        fieldSchema = fieldSchema.toBuilder().addFields(TableFieldSchema.newBuilder().setName("start").setType(fieldSchema.getRangeElementType().getType()).build()).addFields(TableFieldSchema.newBuilder().setName("end").setType(fieldSchema.getRangeElementType().getType()).build()).build();
                        break;
                    }
                    default: {
                        throw new ValidationException("Field at index " + field.getIndex() + " with name (" + fieldSchema.getName() + ") with type (RANGE) has an unsupported range element type (" + fieldSchema.getRangeElementType() + ")", new Object[0]);
                    }
                }
            }
            if (!fieldSchema.getName().toLowerCase().equals(BigQuerySchemaUtil.getFieldName(field))) {
                throw new ValidationException("Field at index " + field.getIndex() + " has mismatch names (" + fieldSchema.getName() + ") (" + field.getName() + ")", new Object[0]);
            }
        }
        FieldDescriptorAndFieldTableSchema fieldDescriptorAndFieldTableSchema = new FieldDescriptorAndFieldTableSchema();
        fieldDescriptorAndFieldTableSchema.fieldDescriptor = field;
        fieldDescriptorAndFieldTableSchema.tableFieldSchema = fieldSchema;
        return fieldDescriptorAndFieldTableSchema;
    }

    private void fillField(DynamicMessage.Builder protoMsg, Descriptors.FieldDescriptor fieldDescriptor, TableFieldSchema fieldSchema, JSONObject json, String exactJsonKeyName, String currentScope, boolean ignoreUnknownFields) throws IllegalArgumentException {
        Object val = json.get(exactJsonKeyName);
        if (val == JSONObject.NULL) {
            return;
        }
        switch (fieldDescriptor.getType()) {
            case BOOL: {
                if (val instanceof Boolean) {
                    protoMsg.setField(fieldDescriptor, val);
                    return;
                }
                if (!(val instanceof String) || !"true".equalsIgnoreCase((String)val) && !"false".equalsIgnoreCase((String)val)) break;
                protoMsg.setField(fieldDescriptor, (Object)Boolean.parseBoolean((String)val));
                return;
            }
            case BYTES: {
                if (fieldSchema != null) {
                    if (fieldSchema.getType() == TableFieldSchema.Type.NUMERIC) {
                        if (val instanceof String) {
                            protoMsg.setField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToNumericByteString(new BigDecimal((String)val)));
                            return;
                        }
                        if (val instanceof Short || val instanceof Integer || val instanceof Long) {
                            protoMsg.setField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToNumericByteString(new BigDecimal(((Number)val).longValue())));
                            return;
                        }
                        if (val instanceof Float || val instanceof Double) {
                            BigDecimal bigDecimal = new BigDecimal(String.valueOf(val));
                            if (bigDecimal.scale() > 9) {
                                bigDecimal = bigDecimal.setScale(9, RoundingMode.HALF_UP);
                            }
                            protoMsg.setField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToNumericByteString(bigDecimal));
                            return;
                        }
                        if (val instanceof BigDecimal) {
                            protoMsg.setField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)val));
                            return;
                        }
                    } else if (fieldSchema.getType() == TableFieldSchema.Type.BIGNUMERIC) {
                        if (val instanceof String) {
                            protoMsg.setField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToBigNumericByteString(new BigDecimal((String)val)));
                            return;
                        }
                        if (val instanceof Short || val instanceof Integer || val instanceof Long) {
                            protoMsg.setField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToBigNumericByteString(new BigDecimal(((Number)val).longValue())));
                            return;
                        }
                        if (val instanceof Float || val instanceof Double) {
                            protoMsg.setField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToBigNumericByteString(new BigDecimal(String.valueOf(val))));
                            return;
                        }
                        if (val instanceof BigDecimal) {
                            protoMsg.setField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)val));
                            return;
                        }
                    }
                }
                if (val instanceof ByteString) {
                    protoMsg.setField(fieldDescriptor, (Object)((ByteString)val).toByteArray());
                    return;
                }
                if (!(val instanceof JSONArray)) break;
                byte[] bytes = new byte[((JSONArray)val).length()];
                for (int j = 0; j < ((JSONArray)val).length(); ++j) {
                    bytes[j] = (byte)((JSONArray)val).getInt(j);
                    if (bytes[j] == ((JSONArray)val).getInt(j)) continue;
                    throw new IllegalArgumentException(String.format("Error: " + currentScope + "[" + j + "] could not be converted to byte[].", new Object[0]));
                }
                protoMsg.setField(fieldDescriptor, (Object)bytes);
                return;
            }
            case INT64: {
                Long parsed;
                if (fieldSchema != null) {
                    if (fieldSchema.getType() == TableFieldSchema.Type.DATETIME) {
                        if (val instanceof String) {
                            protoMsg.setField(fieldDescriptor, (Object)CivilTimeEncoder.encodePacked64DatetimeMicrosLocalDateTime(LocalDateTime.parse((String)val, DATETIME_FORMATTER)));
                            return;
                        }
                        if (val instanceof Long) {
                            protoMsg.setField(fieldDescriptor, val);
                            return;
                        }
                    } else if (fieldSchema.getType() == TableFieldSchema.Type.TIME) {
                        if (val instanceof String) {
                            protoMsg.setField(fieldDescriptor, (Object)CivilTimeEncoder.encodePacked64TimeMicrosLocalTime(LocalTime.parse((String)val)));
                            return;
                        }
                        if (val instanceof Long) {
                            protoMsg.setField(fieldDescriptor, val);
                            return;
                        }
                    } else if (fieldSchema.getType() == TableFieldSchema.Type.TIMESTAMP) {
                        protoMsg.setField(fieldDescriptor, (Object)this.getTimestampAsLong(val));
                        return;
                    }
                }
                if (val instanceof Integer) {
                    protoMsg.setField(fieldDescriptor, (Object)((Integer)val));
                    return;
                }
                if (val instanceof Long) {
                    protoMsg.setField(fieldDescriptor, val);
                    return;
                }
                if (val instanceof Byte) {
                    protoMsg.setField(fieldDescriptor, (Object)((Byte)val));
                    return;
                }
                if (val instanceof Short) {
                    protoMsg.setField(fieldDescriptor, (Object)((Short)val));
                    return;
                }
                if (!(val instanceof String) || (parsed = Longs.tryParse((String)((String)val))) == null) break;
                protoMsg.setField(fieldDescriptor, (Object)parsed);
                return;
            }
            case INT32: {
                Integer parsed;
                if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.DATE) {
                    if (val instanceof String) {
                        protoMsg.setField(fieldDescriptor, (Object)((int)LocalDate.parse((String)val).toEpochDay()));
                        return;
                    }
                    if (val instanceof Integer || val instanceof Long) {
                        protoMsg.setField(fieldDescriptor, (Object)((Number)val).intValue());
                        return;
                    }
                }
                if (val instanceof Integer) {
                    protoMsg.setField(fieldDescriptor, val);
                    return;
                }
                if (!(val instanceof String) || (parsed = Ints.tryParse((String)((String)val))) == null) break;
                protoMsg.setField(fieldDescriptor, (Object)parsed);
                return;
            }
            case STRING: {
                if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.TIMESTAMP) {
                    protoMsg.setField(fieldDescriptor, (Object)JsonToProtoMessage.getTimestampAsString(val));
                    return;
                }
                if (val instanceof String) {
                    protoMsg.setField(fieldDescriptor, val);
                    return;
                }
                if (!(val instanceof Short) && !(val instanceof Integer) && !(val instanceof Long) && !(val instanceof Boolean)) break;
                protoMsg.setField(fieldDescriptor, (Object)String.valueOf(val));
                return;
            }
            case DOUBLE: {
                Double parsed;
                if (val instanceof Number) {
                    protoMsg.setField(fieldDescriptor, (Object)((Number)val).doubleValue());
                    return;
                }
                if (!(val instanceof String) || (parsed = Doubles.tryParse((String)((String)val))) == null) break;
                protoMsg.setField(fieldDescriptor, (Object)parsed);
                return;
            }
            case MESSAGE: {
                if (!(val instanceof JSONObject)) break;
                protoMsg.setField(fieldDescriptor, (Object)this.convertToProtoMessage(fieldDescriptor.getMessageType(), (List<TableFieldSchema>)(fieldSchema == null ? null : fieldSchema.getFieldsList()), json.getJSONObject(exactJsonKeyName), currentScope, ignoreUnknownFields));
                return;
            }
        }
        throw new IllegalArgumentException(String.format("JSONObject does not have a %s field at %s.", FIELD_TYPE_TO_DEBUG_MESSAGE.get((Object)fieldDescriptor.getType()), currentScope));
    }

    private void fillRepeatedField(DynamicMessage.Builder protoMsg, Descriptors.FieldDescriptor fieldDescriptor, TableFieldSchema fieldSchema, JSONObject json, String exactJsonKeyName, String currentScope, boolean ignoreUnknownFields) throws IllegalArgumentException {
        JSONArray jsonArray;
        try {
            jsonArray = json.getJSONArray(exactJsonKeyName);
        }
        catch (JSONException e) {
            Object val = json.get(exactJsonKeyName);
            if (val == JSONObject.NULL) {
                return;
            }
            throw new IllegalArgumentException("JSONObject does not have a array field at " + currentScope + ".");
        }
        block13: for (int i = 0; i < jsonArray.length(); ++i) {
            Object val = jsonArray.get(i);
            int index = i;
            switch (fieldDescriptor.getType()) {
                case BOOL: {
                    if (val instanceof Boolean) {
                        protoMsg.addRepeatedField(fieldDescriptor, val);
                        continue block13;
                    }
                    if (val instanceof String && ("true".equalsIgnoreCase((String)val) || "false".equalsIgnoreCase((String)val))) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)Boolean.parseBoolean((String)val));
                        continue block13;
                    }
                    JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                    continue block13;
                }
                case BYTES: {
                    boolean added = false;
                    if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.NUMERIC) {
                        if (val instanceof String) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToNumericByteString(new BigDecimal((String)val)));
                            added = true;
                        } else if (val instanceof Short || val instanceof Integer || val instanceof Long) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToNumericByteString(new BigDecimal(((Number)val).longValue())));
                            added = true;
                        } else if (val instanceof Float || val instanceof Double) {
                            BigDecimal bigDecimal = new BigDecimal(String.valueOf(val));
                            if (bigDecimal.scale() > 9) {
                                bigDecimal = bigDecimal.setScale(9, RoundingMode.HALF_UP);
                            }
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToNumericByteString(bigDecimal));
                            added = true;
                        } else if (val instanceof BigDecimal) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)val));
                            added = true;
                        }
                    } else if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.BIGNUMERIC) {
                        if (val instanceof String) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToBigNumericByteString(new BigDecimal((String)val)));
                            added = true;
                        } else if (val instanceof Short || val instanceof Integer || val instanceof Long) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToBigNumericByteString(new BigDecimal(((Number)val).longValue())));
                            added = true;
                        } else if (val instanceof Float || val instanceof Double) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToBigNumericByteString(new BigDecimal(String.valueOf(val))));
                            added = true;
                        } else if (val instanceof BigDecimal) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)val));
                            added = true;
                        }
                    }
                    if (added) continue block13;
                    if (val instanceof ByteString) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)((ByteString)val).toByteArray());
                        continue block13;
                    }
                    if (val instanceof byte[]) {
                        protoMsg.addRepeatedField(fieldDescriptor, val);
                        continue block13;
                    }
                    if (val instanceof JSONArray) {
                        try {
                            byte[] bytes = new byte[((JSONArray)val).length()];
                            for (int j = 0; j < ((JSONArray)val).length(); ++j) {
                                bytes[j] = (byte)((JSONArray)val).getInt(j);
                                if (bytes[j] == ((JSONArray)val).getInt(j)) continue;
                                throw new IllegalArgumentException(String.format("Error: " + currentScope + "[" + index + "] could not be converted to byte[].", new Object[0]));
                            }
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)bytes);
                            continue block13;
                        }
                        catch (JSONException e) {
                            throw new IllegalArgumentException(String.format("Error: " + currentScope + "[" + index + "] could not be converted to byte[].", new Object[0]));
                        }
                    }
                    JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                    continue block13;
                }
                case INT64: {
                    Number parsed;
                    if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.DATETIME) {
                        if (val instanceof String) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)CivilTimeEncoder.encodePacked64DatetimeMicrosLocalDateTime(LocalDateTime.parse((String)val, DATETIME_FORMATTER)));
                            continue block13;
                        }
                        if (val instanceof Long) {
                            protoMsg.addRepeatedField(fieldDescriptor, val);
                            continue block13;
                        }
                        JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                        continue block13;
                    }
                    if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.TIME) {
                        if (val instanceof String) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)CivilTimeEncoder.encodePacked64TimeMicrosLocalTime(LocalTime.parse((String)val)));
                            continue block13;
                        }
                        if (val instanceof Long) {
                            protoMsg.addRepeatedField(fieldDescriptor, val);
                            continue block13;
                        }
                        JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                        continue block13;
                    }
                    if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.TIMESTAMP) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)this.getTimestampAsLong(val));
                        continue block13;
                    }
                    if (val instanceof Integer) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)((Integer)val));
                        continue block13;
                    }
                    if (val instanceof Long) {
                        protoMsg.addRepeatedField(fieldDescriptor, val);
                        continue block13;
                    }
                    if (val instanceof Byte) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)((Byte)val));
                        continue block13;
                    }
                    if (val instanceof Short) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)((Short)val));
                        continue block13;
                    }
                    if (val instanceof String) {
                        parsed = Longs.tryParse((String)((String)val));
                        if (parsed != null) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)parsed);
                            continue block13;
                        }
                        JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                        continue block13;
                    }
                    JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                    continue block13;
                }
                case INT32: {
                    Number parsed;
                    if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.DATE) {
                        if (val instanceof String) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)((int)LocalDate.parse((String)val).toEpochDay()));
                            continue block13;
                        }
                        if (val instanceof Integer || val instanceof Long) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)((Number)val).intValue());
                            continue block13;
                        }
                        JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                        continue block13;
                    }
                    if (val instanceof Integer) {
                        protoMsg.addRepeatedField(fieldDescriptor, val);
                        continue block13;
                    }
                    if (val instanceof String) {
                        parsed = Ints.tryParse((String)((String)val));
                        if (parsed != null) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)parsed);
                            continue block13;
                        }
                        JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                        continue block13;
                    }
                    JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                    continue block13;
                }
                case STRING: {
                    if (fieldSchema != null && fieldSchema.getType() == TableFieldSchema.Type.TIMESTAMP) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)JsonToProtoMessage.getTimestampAsString(val));
                        return;
                    }
                    if (val instanceof String) {
                        protoMsg.addRepeatedField(fieldDescriptor, val);
                        continue block13;
                    }
                    if (val instanceof Short || val instanceof Integer || val instanceof Long || val instanceof Boolean) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)String.valueOf(val));
                        return;
                    }
                    JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                    continue block13;
                }
                case DOUBLE: {
                    Number parsed;
                    if (val instanceof Number) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)((Number)val).doubleValue());
                        continue block13;
                    }
                    if (val instanceof String) {
                        parsed = Doubles.tryParse((String)((String)val));
                        if (parsed != null) {
                            protoMsg.addRepeatedField(fieldDescriptor, (Object)parsed);
                            continue block13;
                        }
                        JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                        continue block13;
                    }
                    JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                    continue block13;
                }
                case MESSAGE: {
                    if (val instanceof JSONObject) {
                        protoMsg.addRepeatedField(fieldDescriptor, (Object)this.convertToProtoMessage(fieldDescriptor.getMessageType(), (List<TableFieldSchema>)(fieldSchema == null ? null : fieldSchema.getFieldsList()), jsonArray.getJSONObject(i), currentScope, ignoreUnknownFields));
                        continue block13;
                    }
                    JsonToProtoMessage.throwWrongFieldType(fieldDescriptor, currentScope, index);
                }
            }
        }
    }

    @VisibleForTesting
    static Instant fromEpochMicros(long micros) {
        long seconds = Math.floorDiv(micros, 1000000L);
        int nanos = (int)Math.floorMod(micros, 1000000L) * 1000;
        return Instant.ofEpochSecond(seconds, nanos);
    }

    @VisibleForTesting
    static String getTimestampAsString(Object val) {
        if (val instanceof String) {
            String value = (String)val;
            Double parsed = Doubles.tryParse((String)value);
            if (parsed != null) {
                return JsonToProtoMessage.getTimestampAsString(parsed.longValue());
            }
            JsonToProtoMessage.validateTimestamp(value);
            Matcher matcher = ISO8601_TIMESTAMP_HIGH_PRECISION_PATTERN.matcher(value);
            if (matcher.find()) {
                return value;
            }
            Instant instant = FROM_TIMESTAMP_FORMATTER.parse((CharSequence)value, Instant::from);
            return TO_TIMESTAMP_FORMATTER.format(instant);
        }
        if (val instanceof Number) {
            Instant instant = JsonToProtoMessage.fromEpochMicros(((Number)val).longValue());
            return TO_TIMESTAMP_FORMATTER.format(instant);
        }
        if (val instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)val;
            return TO_TIMESTAMP_FORMATTER.format(Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos()));
        }
        throw new IllegalArgumentException("The timestamp value passed in is not from a valid type");
    }

    private long getTimestampAsLong(Object val) {
        if (val instanceof String) {
            Double parsed = Doubles.tryParse((String)((String)val));
            if (parsed != null) {
                return parsed.longValue();
            }
            TemporalAccessor parsedTime = FROM_TIMESTAMP_FORMATTER.parse((String)val);
            return parsedTime.getLong(ChronoField.INSTANT_SECONDS) * 1000000L + parsedTime.getLong(ChronoField.MICRO_OF_SECOND);
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        throw new IllegalArgumentException("The timestamp value passed in is not from a valid type");
    }

    private static void throwWrongFieldType(Descriptors.FieldDescriptor fieldDescriptor, String currentScope, int index) {
        throw new IllegalArgumentException(String.format("JSONObject does not have a %s field at %s[%d].", FIELD_TYPE_TO_DEBUG_MESSAGE.get((Object)fieldDescriptor.getType()), currentScope, index));
    }

    @VisibleForTesting
    static void validateTimestamp(String timestamp) {
        Matcher matcher = ISO8601_TIMESTAMP_HIGH_PRECISION_PATTERN.matcher(timestamp);
        if (matcher.find()) {
            String fraction = matcher.group(1);
            if (fraction.length() > 12) {
                throw new IllegalArgumentException("Fractional second portion of ISO8601 only supports up to picosecond (12 digits) in BigQuery");
            }
            String truncatedFraction = fraction.substring(0, 9);
            timestamp = new StringBuilder(timestamp).replace(matcher.start(1), matcher.end(1), truncatedFraction).toString();
        }
        try {
            FROM_TIMESTAMP_FORMATTER.parse(timestamp);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static final class FieldDescriptorAndFieldTableSchema {
        TableFieldSchema tableFieldSchema;
        Descriptors.FieldDescriptor fieldDescriptor;

        private FieldDescriptorAndFieldTableSchema() {
        }
    }
}

