package com.google.cloud.bigquery;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ExternalTableDefinition extends ExternalTableDefinition {

  private final TableDefinition.Type type;

  @Nullable
  private final Schema schema;

  @Nullable
  private final String compression;

  @Nullable
  private final String connectionId;

  @Nullable
  private final Boolean ignoreUnknownValues;

  @Nullable
  private final Integer maxBadRecords;

  @Nullable
  private final String fileSetSpecTypeInner;

  @Nullable
  private final ImmutableList<String> sourceUrisImmut;

  @Nullable
  private final String objectMetadataInner;

  @Nullable
  private final String metadataCacheModeInner;

  @Nullable
  private final String maxStalenessInner;

  @Nullable
  private final FormatOptions formatOptionsInner;

  @Nullable
  private final ImmutableList<String> decimalTargetTypes;

  @Nullable
  private final Boolean autodetect;

  @Nullable
  private final String referenceFileSchemaUri;

  @Nullable
  private final String timeZone;

  @Nullable
  private final String dateFormat;

  @Nullable
  private final String datetimeFormat;

  @Nullable
  private final String timeFormat;

  @Nullable
  private final String timestampFormat;

  @Nullable
  private final ExternalTableDefinition.SourceColumnMatch sourceColumnMatch;

  @Nullable
  private final List<String> nullMarkers;

  @Nullable
  private final HivePartitioningOptions hivePartitioningOptionsInner;

  private AutoValue_ExternalTableDefinition(
      TableDefinition.Type type,
      @Nullable Schema schema,
      @Nullable String compression,
      @Nullable String connectionId,
      @Nullable Boolean ignoreUnknownValues,
      @Nullable Integer maxBadRecords,
      @Nullable String fileSetSpecTypeInner,
      @Nullable ImmutableList<String> sourceUrisImmut,
      @Nullable String objectMetadataInner,
      @Nullable String metadataCacheModeInner,
      @Nullable String maxStalenessInner,
      @Nullable FormatOptions formatOptionsInner,
      @Nullable ImmutableList<String> decimalTargetTypes,
      @Nullable Boolean autodetect,
      @Nullable String referenceFileSchemaUri,
      @Nullable String timeZone,
      @Nullable String dateFormat,
      @Nullable String datetimeFormat,
      @Nullable String timeFormat,
      @Nullable String timestampFormat,
      @Nullable ExternalTableDefinition.SourceColumnMatch sourceColumnMatch,
      @Nullable List<String> nullMarkers,
      @Nullable HivePartitioningOptions hivePartitioningOptionsInner) {
    this.type = type;
    this.schema = schema;
    this.compression = compression;
    this.connectionId = connectionId;
    this.ignoreUnknownValues = ignoreUnknownValues;
    this.maxBadRecords = maxBadRecords;
    this.fileSetSpecTypeInner = fileSetSpecTypeInner;
    this.sourceUrisImmut = sourceUrisImmut;
    this.objectMetadataInner = objectMetadataInner;
    this.metadataCacheModeInner = metadataCacheModeInner;
    this.maxStalenessInner = maxStalenessInner;
    this.formatOptionsInner = formatOptionsInner;
    this.decimalTargetTypes = decimalTargetTypes;
    this.autodetect = autodetect;
    this.referenceFileSchemaUri = referenceFileSchemaUri;
    this.timeZone = timeZone;
    this.dateFormat = dateFormat;
    this.datetimeFormat = datetimeFormat;
    this.timeFormat = timeFormat;
    this.timestampFormat = timestampFormat;
    this.sourceColumnMatch = sourceColumnMatch;
    this.nullMarkers = nullMarkers;
    this.hivePartitioningOptionsInner = hivePartitioningOptionsInner;
  }

  @Override
  public TableDefinition.Type getType() {
    return type;
  }

  @Nullable
  @Override
  public Schema getSchema() {
    return schema;
  }

  @Nullable
  @Override
  public String getCompression() {
    return compression;
  }

  @Nullable
  @Override
  public String getConnectionId() {
    return connectionId;
  }

  @Nullable
  @Override
  public Boolean getIgnoreUnknownValues() {
    return ignoreUnknownValues;
  }

  @Nullable
  @Override
  public Integer getMaxBadRecords() {
    return maxBadRecords;
  }

  @Nullable
  @Override
  String getFileSetSpecTypeInner() {
    return fileSetSpecTypeInner;
  }

  @Nullable
  @Override
  public ImmutableList<String> getSourceUrisImmut() {
    return sourceUrisImmut;
  }

  @Nullable
  @Override
  String getObjectMetadataInner() {
    return objectMetadataInner;
  }

  @Nullable
  @Override
  String getMetadataCacheModeInner() {
    return metadataCacheModeInner;
  }

  @Nullable
  @Override
  String getMaxStalenessInner() {
    return maxStalenessInner;
  }

  @Nullable
  @Override
  FormatOptions getFormatOptionsInner() {
    return formatOptionsInner;
  }

  @Nullable
  @Override
  public ImmutableList<String> getDecimalTargetTypes() {
    return decimalTargetTypes;
  }

  @Nullable
  @Override
  public Boolean getAutodetect() {
    return autodetect;
  }

  @Nullable
  @Override
  public String getReferenceFileSchemaUri() {
    return referenceFileSchemaUri;
  }

  @Nullable
  @Override
  public String getTimeZone() {
    return timeZone;
  }

  @Nullable
  @Override
  public String getDateFormat() {
    return dateFormat;
  }

  @Nullable
  @Override
  public String getDatetimeFormat() {
    return datetimeFormat;
  }

  @Nullable
  @Override
  public String getTimeFormat() {
    return timeFormat;
  }

  @Nullable
  @Override
  public String getTimestampFormat() {
    return timestampFormat;
  }

  @Nullable
  @Override
  public ExternalTableDefinition.SourceColumnMatch getSourceColumnMatch() {
    return sourceColumnMatch;
  }

  @Nullable
  @Override
  public List<String> getNullMarkers() {
    return nullMarkers;
  }

  @Nullable
  @Override
  HivePartitioningOptions getHivePartitioningOptionsInner() {
    return hivePartitioningOptionsInner;
  }

  @Override
  public String toString() {
    return "ExternalTableDefinition{"
        + "type=" + type + ", "
        + "schema=" + schema + ", "
        + "compression=" + compression + ", "
        + "connectionId=" + connectionId + ", "
        + "ignoreUnknownValues=" + ignoreUnknownValues + ", "
        + "maxBadRecords=" + maxBadRecords + ", "
        + "fileSetSpecTypeInner=" + fileSetSpecTypeInner + ", "
        + "sourceUrisImmut=" + sourceUrisImmut + ", "
        + "objectMetadataInner=" + objectMetadataInner + ", "
        + "metadataCacheModeInner=" + metadataCacheModeInner + ", "
        + "maxStalenessInner=" + maxStalenessInner + ", "
        + "formatOptionsInner=" + formatOptionsInner + ", "
        + "decimalTargetTypes=" + decimalTargetTypes + ", "
        + "autodetect=" + autodetect + ", "
        + "referenceFileSchemaUri=" + referenceFileSchemaUri + ", "
        + "timeZone=" + timeZone + ", "
        + "dateFormat=" + dateFormat + ", "
        + "datetimeFormat=" + datetimeFormat + ", "
        + "timeFormat=" + timeFormat + ", "
        + "timestampFormat=" + timestampFormat + ", "
        + "sourceColumnMatch=" + sourceColumnMatch + ", "
        + "nullMarkers=" + nullMarkers + ", "
        + "hivePartitioningOptionsInner=" + hivePartitioningOptionsInner
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ExternalTableDefinition) {
      ExternalTableDefinition that = (ExternalTableDefinition) o;
      return this.type.equals(that.getType())
          && (this.schema == null ? that.getSchema() == null : this.schema.equals(that.getSchema()))
          && (this.compression == null ? that.getCompression() == null : this.compression.equals(that.getCompression()))
          && (this.connectionId == null ? that.getConnectionId() == null : this.connectionId.equals(that.getConnectionId()))
          && (this.ignoreUnknownValues == null ? that.getIgnoreUnknownValues() == null : this.ignoreUnknownValues.equals(that.getIgnoreUnknownValues()))
          && (this.maxBadRecords == null ? that.getMaxBadRecords() == null : this.maxBadRecords.equals(that.getMaxBadRecords()))
          && (this.fileSetSpecTypeInner == null ? that.getFileSetSpecTypeInner() == null : this.fileSetSpecTypeInner.equals(that.getFileSetSpecTypeInner()))
          && (this.sourceUrisImmut == null ? that.getSourceUrisImmut() == null : this.sourceUrisImmut.equals(that.getSourceUrisImmut()))
          && (this.objectMetadataInner == null ? that.getObjectMetadataInner() == null : this.objectMetadataInner.equals(that.getObjectMetadataInner()))
          && (this.metadataCacheModeInner == null ? that.getMetadataCacheModeInner() == null : this.metadataCacheModeInner.equals(that.getMetadataCacheModeInner()))
          && (this.maxStalenessInner == null ? that.getMaxStalenessInner() == null : this.maxStalenessInner.equals(that.getMaxStalenessInner()))
          && (this.formatOptionsInner == null ? that.getFormatOptionsInner() == null : this.formatOptionsInner.equals(that.getFormatOptionsInner()))
          && (this.decimalTargetTypes == null ? that.getDecimalTargetTypes() == null : this.decimalTargetTypes.equals(that.getDecimalTargetTypes()))
          && (this.autodetect == null ? that.getAutodetect() == null : this.autodetect.equals(that.getAutodetect()))
          && (this.referenceFileSchemaUri == null ? that.getReferenceFileSchemaUri() == null : this.referenceFileSchemaUri.equals(that.getReferenceFileSchemaUri()))
          && (this.timeZone == null ? that.getTimeZone() == null : this.timeZone.equals(that.getTimeZone()))
          && (this.dateFormat == null ? that.getDateFormat() == null : this.dateFormat.equals(that.getDateFormat()))
          && (this.datetimeFormat == null ? that.getDatetimeFormat() == null : this.datetimeFormat.equals(that.getDatetimeFormat()))
          && (this.timeFormat == null ? that.getTimeFormat() == null : this.timeFormat.equals(that.getTimeFormat()))
          && (this.timestampFormat == null ? that.getTimestampFormat() == null : this.timestampFormat.equals(that.getTimestampFormat()))
          && (this.sourceColumnMatch == null ? that.getSourceColumnMatch() == null : this.sourceColumnMatch.equals(that.getSourceColumnMatch()))
          && (this.nullMarkers == null ? that.getNullMarkers() == null : this.nullMarkers.equals(that.getNullMarkers()))
          && (this.hivePartitioningOptionsInner == null ? that.getHivePartitioningOptionsInner() == null : this.hivePartitioningOptionsInner.equals(that.getHivePartitioningOptionsInner()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= (schema == null) ? 0 : schema.hashCode();
    h$ *= 1000003;
    h$ ^= (compression == null) ? 0 : compression.hashCode();
    h$ *= 1000003;
    h$ ^= (connectionId == null) ? 0 : connectionId.hashCode();
    h$ *= 1000003;
    h$ ^= (ignoreUnknownValues == null) ? 0 : ignoreUnknownValues.hashCode();
    h$ *= 1000003;
    h$ ^= (maxBadRecords == null) ? 0 : maxBadRecords.hashCode();
    h$ *= 1000003;
    h$ ^= (fileSetSpecTypeInner == null) ? 0 : fileSetSpecTypeInner.hashCode();
    h$ *= 1000003;
    h$ ^= (sourceUrisImmut == null) ? 0 : sourceUrisImmut.hashCode();
    h$ *= 1000003;
    h$ ^= (objectMetadataInner == null) ? 0 : objectMetadataInner.hashCode();
    h$ *= 1000003;
    h$ ^= (metadataCacheModeInner == null) ? 0 : metadataCacheModeInner.hashCode();
    h$ *= 1000003;
    h$ ^= (maxStalenessInner == null) ? 0 : maxStalenessInner.hashCode();
    h$ *= 1000003;
    h$ ^= (formatOptionsInner == null) ? 0 : formatOptionsInner.hashCode();
    h$ *= 1000003;
    h$ ^= (decimalTargetTypes == null) ? 0 : decimalTargetTypes.hashCode();
    h$ *= 1000003;
    h$ ^= (autodetect == null) ? 0 : autodetect.hashCode();
    h$ *= 1000003;
    h$ ^= (referenceFileSchemaUri == null) ? 0 : referenceFileSchemaUri.hashCode();
    h$ *= 1000003;
    h$ ^= (timeZone == null) ? 0 : timeZone.hashCode();
    h$ *= 1000003;
    h$ ^= (dateFormat == null) ? 0 : dateFormat.hashCode();
    h$ *= 1000003;
    h$ ^= (datetimeFormat == null) ? 0 : datetimeFormat.hashCode();
    h$ *= 1000003;
    h$ ^= (timeFormat == null) ? 0 : timeFormat.hashCode();
    h$ *= 1000003;
    h$ ^= (timestampFormat == null) ? 0 : timestampFormat.hashCode();
    h$ *= 1000003;
    h$ ^= (sourceColumnMatch == null) ? 0 : sourceColumnMatch.hashCode();
    h$ *= 1000003;
    h$ ^= (nullMarkers == null) ? 0 : nullMarkers.hashCode();
    h$ *= 1000003;
    h$ ^= (hivePartitioningOptionsInner == null) ? 0 : hivePartitioningOptionsInner.hashCode();
    return h$;
  }

  private static final long serialVersionUID = -5951580238459622025L;

  @Override
  public ExternalTableDefinition.Builder toBuilder() {
    return new AutoValue_ExternalTableDefinition.Builder(this);
  }

  static final class Builder extends ExternalTableDefinition.Builder {
    private TableDefinition.Type type;
    private Schema schema;
    private String compression;
    private String connectionId;
    private Boolean ignoreUnknownValues;
    private Integer maxBadRecords;
    private String fileSetSpecTypeInner;
    private ImmutableList<String> sourceUrisImmut;
    private String objectMetadataInner;
    private String metadataCacheModeInner;
    private String maxStalenessInner;
    private FormatOptions formatOptionsInner;
    private ImmutableList<String> decimalTargetTypes;
    private Boolean autodetect;
    private String referenceFileSchemaUri;
    private String timeZone;
    private String dateFormat;
    private String datetimeFormat;
    private String timeFormat;
    private String timestampFormat;
    private ExternalTableDefinition.SourceColumnMatch sourceColumnMatch;
    private List<String> nullMarkers;
    private HivePartitioningOptions hivePartitioningOptionsInner;
    Builder() {
    }
    Builder(ExternalTableDefinition source) {
      this.type = source.getType();
      this.schema = source.getSchema();
      this.compression = source.getCompression();
      this.connectionId = source.getConnectionId();
      this.ignoreUnknownValues = source.getIgnoreUnknownValues();
      this.maxBadRecords = source.getMaxBadRecords();
      this.fileSetSpecTypeInner = source.getFileSetSpecTypeInner();
      this.sourceUrisImmut = source.getSourceUrisImmut();
      this.objectMetadataInner = source.getObjectMetadataInner();
      this.metadataCacheModeInner = source.getMetadataCacheModeInner();
      this.maxStalenessInner = source.getMaxStalenessInner();
      this.formatOptionsInner = source.getFormatOptionsInner();
      this.decimalTargetTypes = source.getDecimalTargetTypes();
      this.autodetect = source.getAutodetect();
      this.referenceFileSchemaUri = source.getReferenceFileSchemaUri();
      this.timeZone = source.getTimeZone();
      this.dateFormat = source.getDateFormat();
      this.datetimeFormat = source.getDatetimeFormat();
      this.timeFormat = source.getTimeFormat();
      this.timestampFormat = source.getTimestampFormat();
      this.sourceColumnMatch = source.getSourceColumnMatch();
      this.nullMarkers = source.getNullMarkers();
      this.hivePartitioningOptionsInner = source.getHivePartitioningOptionsInner();
    }
    @Override
    public ExternalTableDefinition.Builder setType(TableDefinition.Type type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setSchema(Schema schema) {
      this.schema = schema;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setCompression(String compression) {
      this.compression = compression;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setConnectionId(String connectionId) {
      this.connectionId = connectionId;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setIgnoreUnknownValues(Boolean ignoreUnknownValues) {
      this.ignoreUnknownValues = ignoreUnknownValues;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setMaxBadRecords(Integer maxBadRecords) {
      this.maxBadRecords = maxBadRecords;
      return this;
    }
    @Override
    ExternalTableDefinition.Builder setFileSetSpecTypeInner(String fileSetSpecTypeInner) {
      this.fileSetSpecTypeInner = fileSetSpecTypeInner;
      return this;
    }
    @Override
    ExternalTableDefinition.Builder setSourceUrisImmut(ImmutableList<String> sourceUrisImmut) {
      this.sourceUrisImmut = sourceUrisImmut;
      return this;
    }
    @Override
    ExternalTableDefinition.Builder setObjectMetadataInner(String objectMetadataInner) {
      this.objectMetadataInner = objectMetadataInner;
      return this;
    }
    @Override
    ExternalTableDefinition.Builder setMetadataCacheModeInner(String metadataCacheModeInner) {
      this.metadataCacheModeInner = metadataCacheModeInner;
      return this;
    }
    @Override
    ExternalTableDefinition.Builder setMaxStalenessInner(String maxStalenessInner) {
      this.maxStalenessInner = maxStalenessInner;
      return this;
    }
    @Override
    ExternalTableDefinition.Builder setFormatOptionsInner(FormatOptions formatOptionsInner) {
      this.formatOptionsInner = formatOptionsInner;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setDecimalTargetTypes(List<String> decimalTargetTypes) {
      this.decimalTargetTypes = (decimalTargetTypes == null ? null : ImmutableList.copyOf(decimalTargetTypes));
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setAutodetect(Boolean autodetect) {
      this.autodetect = autodetect;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setReferenceFileSchemaUri(String referenceFileSchemaUri) {
      this.referenceFileSchemaUri = referenceFileSchemaUri;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setTimeZone(String timeZone) {
      this.timeZone = timeZone;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setDateFormat(String dateFormat) {
      this.dateFormat = dateFormat;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setDatetimeFormat(String datetimeFormat) {
      this.datetimeFormat = datetimeFormat;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setTimeFormat(String timeFormat) {
      this.timeFormat = timeFormat;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setTimestampFormat(String timestampFormat) {
      this.timestampFormat = timestampFormat;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setSourceColumnMatch(ExternalTableDefinition.SourceColumnMatch sourceColumnMatch) {
      this.sourceColumnMatch = sourceColumnMatch;
      return this;
    }
    @Override
    public ExternalTableDefinition.Builder setNullMarkers(List<String> nullMarkers) {
      this.nullMarkers = nullMarkers;
      return this;
    }
    @Override
    ExternalTableDefinition.Builder setHivePartitioningOptionsInner(HivePartitioningOptions hivePartitioningOptionsInner) {
      this.hivePartitioningOptionsInner = hivePartitioningOptionsInner;
      return this;
    }
    @Override
    public ExternalTableDefinition build() {
      if (this.type == null) {
        String missing = " type";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ExternalTableDefinition(
          this.type,
          this.schema,
          this.compression,
          this.connectionId,
          this.ignoreUnknownValues,
          this.maxBadRecords,
          this.fileSetSpecTypeInner,
          this.sourceUrisImmut,
          this.objectMetadataInner,
          this.metadataCacheModeInner,
          this.maxStalenessInner,
          this.formatOptionsInner,
          this.decimalTargetTypes,
          this.autodetect,
          this.referenceFileSchemaUri,
          this.timeZone,
          this.dateFormat,
          this.datetimeFormat,
          this.timeFormat,
          this.timestampFormat,
          this.sourceColumnMatch,
          this.nullMarkers,
          this.hivePartitioningOptionsInner);
    }
  }

}
