/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.v2;

import com.google.cloud.spanner.r2dbc.util.Assert;
import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibraryRow;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class SpannerClientLibraryResult
implements Result {
    private final Flux<SpannerClientLibraryRow> resultRows;
    private final int numRowsUpdated;
    private RowMetadata rowMetadata;

    public SpannerClientLibraryResult(Flux<SpannerClientLibraryRow> resultRows, int numRowsUpdated) {
        this.resultRows = Assert.requireNonNull(resultRows, "A non-null flux of rows is required.");
        this.numRowsUpdated = numRowsUpdated;
    }

    public Publisher<Integer> getRowsUpdated() {
        return Mono.just((Object)this.numRowsUpdated);
    }

    public <T> Publisher<T> map(BiFunction<Row, RowMetadata, ? extends T> mappingFunction) {
        return this.resultRows.map(row -> {
            if (this.rowMetadata == null) {
                this.rowMetadata = row.generateMetadata();
            }
            return mappingFunction.apply((Row)row, this.rowMetadata);
        });
    }

    public Result filter(Predicate<Result.Segment> filter) {
        throw new UnsupportedOperationException();
    }

    public <T> Publisher<T> flatMap(Function<Result.Segment, ? extends Publisher<? extends T>> mappingFunction) {
        return Mono.error((Throwable)new UnsupportedOperationException());
    }
}

