/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.v2;

import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.ValueBinder;
import com.google.cloud.spanner.r2dbc.SpannerType;
import com.google.cloud.spanner.r2dbc.util.Assert;
import com.google.cloud.spanner.r2dbc.v2.ClientLibraryTypeBinder;
import java.util.function.BiConsumer;

class SingleTypeBinder<T>
implements ClientLibraryTypeBinder {
    private Class<T> type;
    private BiConsumer<ValueBinder<Statement.Builder>, T> bindingConsumer;

    public SingleTypeBinder(Class<T> type, BiConsumer<ValueBinder<Statement.Builder>, T> bindingConsumer) {
        this.type = type;
        this.bindingConsumer = bindingConsumer;
    }

    @Override
    public boolean canBind(Class<?> type, SpannerType unusedSpannerType) {
        Assert.requireNonNull(type, "type to encode must not be null");
        return this.type.isAssignableFrom(type);
    }

    @Override
    public void bind(Statement.Builder builder, String name, Object value, SpannerType unusedSpannerType) {
        this.bindingConsumer.accept((ValueBinder<Statement.Builder>)builder.bind(name), (ValueBinder<Statement.Builder>)value);
    }
}

