/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class CredentialsHelper {
    CredentialsHelper() {
    }

    GoogleCredentials getOauthCredentials(String oauthToken) {
        return new GoogleCredentials(new AccessToken(oauthToken, null));
    }

    GoogleCredentials getDefaultCredentials() {
        try {
            return GoogleCredentials.getApplicationDefault();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Error loading default credentials", e));
        }
    }

    GoogleCredentials getFileCredentials(String filePath) {
        GoogleCredentials googleCredentials;
        File credentialsFile = new File(filePath);
        if (!credentialsFile.isFile()) {
            throw new IllegalArgumentException(String.format("Error reading credential file %s: File does not exist", filePath));
        }
        FileInputStream credentialsStream = new FileInputStream(credentialsFile);
        try {
            googleCredentials = GoogleCredentials.fromStream((InputStream)credentialsStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)credentialsStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Error reading credential file %s", filePath), e);
            }
        }
        ((InputStream)credentialsStream).close();
        return googleCredentials;
    }
}

