/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.v2;

import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibraryRow;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class SpannerClientLibraryResult
implements Result {
    private final Flux<SpannerClientLibraryRow> resultRows;
    private final int numRowsUpdated;
    private RowMetadata rowMetadata;

    public SpannerClientLibraryResult(Flux<SpannerClientLibraryRow> resultRows, int numRowsUpdated) {
        this.resultRows = resultRows;
        this.numRowsUpdated = numRowsUpdated;
    }

    public Publisher<Integer> getRowsUpdated() {
        return Mono.just((Object)this.numRowsUpdated);
    }

    public <T> Publisher<T> map(BiFunction<Row, RowMetadata, ? extends T> mappingFunction) {
        if (this.resultRows == null) {
            return Flux.empty();
        }
        return this.resultRows.map(row -> {
            if (this.rowMetadata == null) {
                this.rowMetadata = row.generateMetadata();
            }
            return mappingFunction.apply((Row)row, this.rowMetadata);
        });
    }
}

