/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.v2;

import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.r2dbc.SpannerConnectionConfiguration;
import com.google.cloud.spanner.r2dbc.SpannerConnectionFactoryMetadata;
import com.google.cloud.spanner.r2dbc.util.Assert;
import com.google.cloud.spanner.r2dbc.v2.DatabaseClientReactiveAdapter;
import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibraryConnection;
import io.r2dbc.spi.Closeable;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class SpannerClientLibraryConnectionFactory
implements ConnectionFactory,
Closeable {
    private SpannerConnectionConfiguration config;
    private Spanner spannerClient;

    public SpannerClientLibraryConnectionFactory(SpannerConnectionConfiguration config) {
        this.config = Assert.requireNonNull(config, "Spanner configuration must not be null");
        this.spannerClient = (Spanner)config.buildSpannerOptions().getService();
    }

    public Publisher<? extends Connection> create() {
        return Mono.just((Object)new SpannerClientLibraryConnection(new DatabaseClientReactiveAdapter(this.spannerClient, this.config), this.config));
    }

    public ConnectionFactoryMetadata getMetadata() {
        return SpannerConnectionFactoryMetadata.INSTANCE;
    }

    public Mono<Void> close() {
        return Mono.fromRunnable(() -> this.spannerClient.close());
    }
}

