/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.codecs;

import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.Type;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ValueUtils {
    static final DateTimeFormatter TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().appendOptional(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalStart().appendOffsetId().optionalEnd().toFormatter().withZone(ZoneOffset.UTC);
    private static final Pattern FORMAT_REGEXP = Pattern.compile("(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)");

    ValueUtils() {
    }

    static Object decodeValue(Type fieldType, Value proto) {
        if (proto.getKindCase() == Value.KindCase.NULL_VALUE) {
            return null;
        }
        switch (fieldType.getCode()) {
            case BOOL: {
                ValueUtils.checkType(fieldType, proto, Value.KindCase.BOOL_VALUE);
                return ValueUtils.parseBoolean(proto);
            }
            case INT64: {
                ValueUtils.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                return ValueUtils.parseLong(proto);
            }
            case FLOAT64: {
                return ValueUtils.valueProtoToFloat64(proto);
            }
            case STRING: {
                ValueUtils.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                return proto.getStringValue();
            }
            case BYTES: {
                ValueUtils.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                return ValueUtils.parseBytes(proto);
            }
            case TIMESTAMP: {
                ValueUtils.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                return ValueUtils.parseTimestamp(proto);
            }
            case DATE: {
                ValueUtils.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                return ValueUtils.parseDate(proto);
            }
            case ARRAY: {
                ValueUtils.checkType(fieldType, proto, Value.KindCase.LIST_VALUE);
                ListValue listValue = proto.getListValue();
                return ValueUtils.decodeArrayValue(fieldType.getArrayElementType(), listValue);
            }
        }
        throw new AssertionError((Object)("Unhandled type code: " + fieldType.getCode()));
    }

    private static Object decodeArrayValue(Type elementType, ListValue listValue) {
        switch (elementType.getCode()) {
            case BOOL: {
                return listValue.getValuesList().stream().map(ValueUtils::parseBoolean).toArray(Boolean[]::new);
            }
            case INT64: {
                return listValue.getValuesList().stream().map(ValueUtils::parseLong).toArray(Long[]::new);
            }
            case FLOAT64: {
                return listValue.getValuesList().stream().map(ValueUtils::valueProtoToFloat64).toArray(Double[]::new);
            }
            case STRING: {
                return listValue.getValuesList().stream().map(ValueUtils::parseString).toArray(String[]::new);
            }
            case BYTES: {
                return listValue.getValuesList().stream().map(ValueUtils::parseBytes).toArray(ByteBuffer[]::new);
            }
            case TIMESTAMP: {
                return listValue.getValuesList().stream().map(ValueUtils::parseTimestamp).toArray(LocalDateTime[]::new);
            }
            case DATE: {
                return listValue.getValuesList().stream().map(ValueUtils::parseDate).toArray(LocalDate[]::new);
            }
        }
        throw new AssertionError((Object)("Unhandled type code: " + elementType.getCode()));
    }

    private static Long parseLong(Value proto) {
        return proto.getKindCase() == Value.KindCase.NULL_VALUE ? null : Long.valueOf(Long.parseLong(proto.getStringValue()));
    }

    private static String parseString(Value input) {
        return input.getKindCase() == Value.KindCase.NULL_VALUE ? null : input.getStringValue();
    }

    private static Boolean parseBoolean(Value input) {
        return input.getKindCase() == Value.KindCase.NULL_VALUE ? null : Boolean.valueOf(input.getBoolValue());
    }

    private static ByteBuffer parseBytes(Value value) {
        if (value.getKindCase() == Value.KindCase.NULL_VALUE || value.getStringValue() == null) {
            return null;
        }
        return ByteBuffer.wrap(value.getStringValueBytes().toByteArray());
    }

    private static LocalDateTime parseTimestamp(Value proto) {
        if (proto.getKindCase() == Value.KindCase.NULL_VALUE || proto.getStringValue() == null) {
            return null;
        }
        TemporalAccessor temporalAccessor = TIMESTAMP_FORMATTER.parse(proto.getStringValue());
        return LocalDateTime.ofInstant(Instant.from(temporalAccessor), ZoneOffset.UTC);
    }

    private static LocalDate parseDate(Value proto) {
        String date = proto.getStringValue();
        if (proto.getKindCase() == Value.KindCase.NULL_VALUE || date == null) {
            return null;
        }
        Matcher matcher = FORMAT_REGEXP.matcher(date);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid date: " + date);
        }
        int year = Integer.parseInt(matcher.group(1));
        int month = Integer.parseInt(matcher.group(2));
        int dayOfMonth = Integer.parseInt(matcher.group(3));
        return LocalDate.of(year, month, dayOfMonth);
    }

    private static void checkType(Type fieldType, Value proto, Value.KindCase expected) {
        if (proto.getKindCase() != expected) {
            throw new IllegalArgumentException("Invalid value for column type " + fieldType + " expected " + expected + " but was " + proto.getKindCase());
        }
    }

    private static Double valueProtoToFloat64(Value proto) {
        if (proto.getKindCase() == Value.KindCase.NULL_VALUE) {
            return null;
        }
        if (proto.getKindCase() == Value.KindCase.STRING_VALUE) {
            switch (proto.getStringValue()) {
                case "-Infinity": {
                    return Double.NEGATIVE_INFINITY;
                }
                case "Infinity": {
                    return Double.POSITIVE_INFINITY;
                }
                case "NaN": {
                    return Double.NaN;
                }
            }
        }
        if (proto.getKindCase() != Value.KindCase.NUMBER_VALUE) {
            throw new IllegalArgumentException("Invalid value for column type Float64 expected NUMBER_VALUE or STRING_VALUE with value one of \"Infinity\", \"-Infinity\", or \"NaN\" but was " + proto.getKindCase() + (proto.getKindCase() == Value.KindCase.STRING_VALUE ? " with value \"" + proto.getStringValue() + "\"" : ""));
        }
        return proto.getNumberValue();
    }
}

