/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.codecs;

import com.google.cloud.spanner.r2dbc.codecs.ArrayCodec;
import com.google.cloud.spanner.r2dbc.codecs.Codec;
import com.google.cloud.spanner.r2dbc.codecs.Codecs;
import com.google.cloud.spanner.r2dbc.codecs.SpannerCodec;
import com.google.cloud.spanner.r2dbc.codecs.ValueUtils;
import com.google.cloud.spanner.r2dbc.util.Assert;
import com.google.protobuf.ByteString;
import com.google.protobuf.NullValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.List;
import reactor.util.annotation.Nullable;

public final class DefaultCodecs
implements Codecs {
    static final Value NULL_VALUE = Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
    private final List<Codec<?>> codecs = Arrays.asList(new ArrayCodec(this, Boolean[].class, TypeCode.BOOL), new ArrayCodec(this, ByteBuffer[].class, TypeCode.BYTES), new ArrayCodec(this, LocalDate[].class, TypeCode.DATE), new ArrayCodec(this, Double[].class, TypeCode.FLOAT64), new ArrayCodec(this, Long[].class, TypeCode.INT64), new ArrayCodec(this, String[].class, TypeCode.STRING), new ArrayCodec(this, LocalDateTime[].class, TypeCode.TIMESTAMP), new SpannerCodec<Boolean>(Boolean.class, TypeCode.BOOL, v -> Value.newBuilder().setBoolValue(v.booleanValue()).build()), new SpannerCodec<ByteBuffer>(ByteBuffer.class, TypeCode.BYTES, v -> Value.newBuilder().setStringValueBytes(ByteString.copyFrom((byte[])v.array())).build()), new SpannerCodec<LocalDate>(LocalDate.class, TypeCode.DATE, v -> Value.newBuilder().setStringValue(DateTimeFormatter.ISO_LOCAL_DATE.format((TemporalAccessor)v)).build()), new SpannerCodec<Double>(Double.class, TypeCode.FLOAT64, v -> {
        Value result = v.isNaN() ? Value.newBuilder().setStringValue("NaN").build() : (v == Double.NEGATIVE_INFINITY ? Value.newBuilder().setStringValue("-Infinity").build() : (v == Double.POSITIVE_INFINITY ? Value.newBuilder().setStringValue("Infinity").build() : Value.newBuilder().setNumberValue(v.doubleValue()).build()));
        return result;
    }), new SpannerCodec<Long>(Long.class, TypeCode.INT64, v -> Value.newBuilder().setStringValue(Long.toString(v)).build()), new SpannerCodec<Integer>(Integer.class, TypeCode.INT64, v -> Value.newBuilder().setStringValue(Integer.toString(v)).build(), (val, spannerType) -> Math.toIntExact((Long)ValueUtils.decodeValue(spannerType, val))), new SpannerCodec<String>(String.class, TypeCode.STRING, v -> Value.newBuilder().setStringValue(v).build()), new SpannerCodec<LocalDateTime>(LocalDateTime.class, TypeCode.TIMESTAMP, v -> Value.newBuilder().setStringValue(ValueUtils.TIMESTAMP_FORMATTER.format(v.toInstant(ZoneOffset.UTC))).build()));

    @Override
    @Nullable
    public <T> T decode(Value value, Type spannerType, Class<? extends T> type) {
        Assert.requireNonNull(value, "value must not be null");
        Assert.requireNonNull(spannerType, "spannerType must not be null");
        Assert.requireNonNull(type, "type must not be null");
        for (Codec<T> codec : this.codecs) {
            if (!codec.canDecode(spannerType, type)) continue;
            return (T)codec.decode(value, spannerType);
        }
        throw new IllegalArgumentException(String.format("Cannot decode value of type %s to %s", spannerType, type.getName()));
    }

    public Codec getCodec(Class type) {
        for (Codec<?> codec : this.codecs) {
            if (!codec.canEncode(type)) continue;
            return codec;
        }
        throw new IllegalArgumentException(String.format("Cannot encode parameter of type %s", type.getName()));
    }

    @Override
    public Value encode(Object value) {
        if (value == null) {
            return NULL_VALUE;
        }
        Codec codec = this.getCodec((Class)value.getClass());
        return codec.encode(value);
    }
}

