/*
 * Decompiled with CFR 0.152.
 */
package com.google.capillary.android;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.capillary.HybridRsaUtils;
import com.google.capillary.NoSuchKeyException;
import com.google.capillary.RsaEcdsaConstants;
import com.google.capillary.android.AndroidKeyStoreRsaUtils;
import com.google.capillary.android.KeyManager;
import com.google.capillary.android.Utils;
import com.google.capillary.internal.WrappedWebPushPrivateKey;
import com.google.capillary.internal.WrappedWebPushPublicKey;
import com.google.crypto.tink.HybridDecrypt;
import com.google.crypto.tink.apps.webpush.WebPushHybridDecrypt;
import com.google.crypto.tink.subtle.Base64;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.Random;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.MGF1ParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public class WebPushKeyManager
extends KeyManager {
    private static final String KEY_CHAIN_ID_PREFIX = "web_push_";
    private static final String PRIVATE_KEY_KEY_SUFFIX = "_encrypted_web_push_private_key";
    private static final String PUBLIC_KEY_KEY_SUFFIX = "_web_push_public_key";
    private static final OAEPParameterSpec OAEP_PARAMETER_SPEC = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT);
    private static Map<String, WebPushKeyManager> instances = new HashMap<String, WebPushKeyManager>();
    private final KeyStore keyStore;
    private final SharedPreferences sharedPreferences;

    private WebPushKeyManager(Context context, Utils utils, String keychainId) throws GeneralSecurityException {
        super(context, utils, KEY_CHAIN_ID_PREFIX + keychainId);
        this.keyStore = utils.loadKeyStore();
        Context storageContext = utils.getDeviceProtectedStorageContext(context);
        String prefName = String.format("%s_%s_preferences", this.getClass().getCanonicalName(), keychainId);
        this.sharedPreferences = storageContext.getSharedPreferences(prefName, 0);
    }

    public static synchronized WebPushKeyManager getInstance(Context context, String keychainId) throws GeneralSecurityException {
        if (instances.containsKey(keychainId)) {
            return instances.get(keychainId);
        }
        WebPushKeyManager newInstance = new WebPushKeyManager(context, Utils.getInstance(), keychainId);
        instances.put(keychainId, newInstance);
        return newInstance;
    }

    private static String toKeyPrefKey(boolean isAuth, boolean isPublic) {
        String prefix = isAuth ? "auth" : "no_auth";
        String suffix = isPublic ? PUBLIC_KEY_KEY_SUFFIX : PRIVATE_KEY_KEY_SUFFIX;
        return prefix + suffix;
    }

    @Override
    synchronized void rawGenerateKeyPair(boolean isAuth) throws GeneralSecurityException {
        PublicKey rsaPublicKey;
        AndroidKeyStoreRsaUtils.generateKeyPair(this.context, this.keychainId, isAuth);
        byte[] authSecret = Random.randBytes((int)16);
        KeyPair ecKeyPair = EllipticCurves.generateKeyPair((EllipticCurves.CurveType)EllipticCurves.CurveType.NIST_P256);
        ECPublicKey ecPublicKey = (ECPublicKey)ecKeyPair.getPublic();
        byte[] ecPublicKeyBytes = EllipticCurves.pointEncode((EllipticCurves.CurveType)EllipticCurves.CurveType.NIST_P256, (EllipticCurves.PointFormatType)EllipticCurves.PointFormatType.UNCOMPRESSED, (ECPoint)ecPublicKey.getW());
        WrappedWebPushPublicKey webPushPublicKey = WrappedWebPushPublicKey.newBuilder().setAuthSecret(ByteString.copyFrom((byte[])authSecret)).setKeyBytes(ByteString.copyFrom((byte[])ecPublicKeyBytes)).build();
        byte[] webPushPublicKeyBytes = webPushPublicKey.toByteArray();
        ECPrivateKey ecPrivateKey = (ECPrivateKey)ecKeyPair.getPrivate();
        byte[] ecPrivateKeyBytes = ecPrivateKey.getS().toByteArray();
        WrappedWebPushPrivateKey webPushPrivateKey = WrappedWebPushPrivateKey.newBuilder().setAuthSecret(ByteString.copyFrom((byte[])authSecret)).setPublicKeyBytes(ByteString.copyFrom((byte[])ecPublicKeyBytes)).setPrivateKeyBytes(ByteString.copyFrom((byte[])ecPrivateKeyBytes)).build();
        byte[] webPushPrivateKeyBytes = webPushPrivateKey.toByteArray();
        try {
            rsaPublicKey = AndroidKeyStoreRsaUtils.getPublicKey(this.keyStore, this.keychainId, isAuth);
        }
        catch (NoSuchKeyException e) {
            throw new GeneralSecurityException("unable to load rsa public key", e);
        }
        byte[] encryptedWebPushPrivateKeyBytes = HybridRsaUtils.encrypt((byte[])webPushPrivateKeyBytes, (PublicKey)rsaPublicKey, (RsaEcdsaConstants.Padding)AndroidKeyStoreRsaUtils.getCompatibleRsaPadding(), (OAEPParameterSpec)OAEP_PARAMETER_SPEC);
        this.sharedPreferences.edit().putString(WebPushKeyManager.toKeyPrefKey(isAuth, true), Base64.encode((byte[])webPushPublicKeyBytes)).putString(WebPushKeyManager.toKeyPrefKey(isAuth, false), Base64.encode((byte[])encryptedWebPushPrivateKeyBytes)).apply();
    }

    private void checkKeyExists(boolean isAuth) throws NoSuchKeyException, KeyStoreException {
        if (!this.sharedPreferences.contains(WebPushKeyManager.toKeyPrefKey(isAuth, true)) || !this.sharedPreferences.contains(WebPushKeyManager.toKeyPrefKey(isAuth, false))) {
            throw new NoSuchKeyException(WebPushKeyManager.toKeyTypeString(isAuth) + " web push key not initialized");
        }
    }

    @Override
    synchronized byte[] rawGetPublicKey(boolean isAuth) throws NoSuchKeyException, GeneralSecurityException {
        AndroidKeyStoreRsaUtils.checkKeyExists(this.keyStore, this.keychainId, isAuth);
        this.checkKeyExists(isAuth);
        return Base64.decode((String)this.sharedPreferences.getString(WebPushKeyManager.toKeyPrefKey(isAuth, true), null));
    }

    @Override
    synchronized HybridDecrypt rawGetDecrypter(boolean isAuth) throws NoSuchKeyException, GeneralSecurityException {
        WrappedWebPushPrivateKey webPushPrivateKey;
        this.checkKeyExists(isAuth);
        byte[] encryptedWebPushPrivateKeyBytes = Base64.decode((String)this.sharedPreferences.getString(WebPushKeyManager.toKeyPrefKey(isAuth, false), null));
        PrivateKey rsaPrivateKey = AndroidKeyStoreRsaUtils.getPrivateKey(this.keyStore, this.keychainId, isAuth);
        byte[] webPushPrivateKeyBytes = HybridRsaUtils.decrypt((byte[])encryptedWebPushPrivateKeyBytes, (PrivateKey)rsaPrivateKey, (RsaEcdsaConstants.Padding)AndroidKeyStoreRsaUtils.getCompatibleRsaPadding(), (OAEPParameterSpec)OAEP_PARAMETER_SPEC);
        try {
            webPushPrivateKey = WrappedWebPushPrivateKey.parseFrom((byte[])webPushPrivateKeyBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("unable to load web push private key", e);
        }
        return new WebPushHybridDecrypt.Builder().withAuthSecret(webPushPrivateKey.getAuthSecret().toByteArray()).withRecipientPublicKey(webPushPrivateKey.getPublicKeyBytes().toByteArray()).withRecipientPrivateKey(webPushPrivateKey.getPrivateKeyBytes().toByteArray()).build();
    }

    @Override
    synchronized void rawDeleteKeyPair(boolean isAuth) throws NoSuchKeyException, GeneralSecurityException {
        this.checkKeyExists(isAuth);
        AndroidKeyStoreRsaUtils.deleteKeyPair(this.keyStore, this.keychainId, isAuth);
    }
}

