/*
 * Decompiled with CFR 0.152.
 */
package com.google.capillary.android;

import android.content.Context;
import android.os.Build;
import android.security.keystore.KeyPermanentlyInvalidatedException;
import android.security.keystore.UserNotAuthenticatedException;
import com.google.capillary.AuthModeUnavailableException;
import com.google.capillary.NoSuchKeyException;
import com.google.capillary.android.CapillaryHandler;
import com.google.capillary.android.CapillaryHandlerErrorCode;
import com.google.capillary.android.CiphertextStorage;
import com.google.capillary.android.KeyManager;
import com.google.capillary.android.Utils;
import com.google.capillary.internal.CapillaryCiphertext;
import com.google.crypto.tink.HybridDecrypt;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;
import java.security.UnrecoverableKeyException;
import java.util.List;

public final class DecrypterManager {
    private final Context context;
    private final CiphertextStorage ciphertextStorage;
    private final KeyManager keyManager;
    private final Utils utils;

    DecrypterManager(Context context, KeyManager keyManager, CiphertextStorage ciphertextStorage, Utils utils) {
        this.context = context;
        this.ciphertextStorage = ciphertextStorage;
        this.keyManager = keyManager;
        this.utils = utils;
    }

    public synchronized void decryptSaved(CapillaryHandler handler, Object extra) {
        List<byte[]> ciphertexts = this.ciphertextStorage.get();
        this.ciphertextStorage.clear();
        for (byte[] data : ciphertexts) {
            this.decrypt(data, handler, extra);
        }
    }

    public synchronized void decrypt(byte[] ciphertext, CapillaryHandler handler, Object extra) {
        byte[] data;
        CapillaryCiphertext capillaryCiphertext;
        try {
            capillaryCiphertext = CapillaryCiphertext.parseFrom((byte[])ciphertext);
        }
        catch (InvalidProtocolBufferException e) {
            handler.error(CapillaryHandlerErrorCode.MALFORMED_CIPHERTEXT, ciphertext, extra);
            return;
        }
        if (capillaryCiphertext.getIsAuthKey() && this.utils.isScreenLocked(this.context)) {
            this.ciphertextStorage.save(ciphertext);
            handler.authCiphertextSavedForLater(ciphertext, extra);
            return;
        }
        byte[] rawCiphertext = capillaryCiphertext.getCiphertext().toByteArray();
        try {
            HybridDecrypt decrypter = this.keyManager.getDecrypter(capillaryCiphertext.getKeychainUniqueId(), capillaryCiphertext.getKeySerialNumber(), capillaryCiphertext.getIsAuthKey());
            data = decrypter.decrypt(rawCiphertext, null);
        }
        catch (AuthModeUnavailableException e) {
            handler.error(CapillaryHandlerErrorCode.AUTH_CIPHER_IN_NO_AUTH_DEVICE, ciphertext, extra);
            return;
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT >= 23 && e instanceof UserNotAuthenticatedException) {
                this.ciphertextStorage.save(ciphertext);
                handler.authCiphertextSavedForLater(ciphertext, extra);
                return;
            }
            if (e instanceof NoSuchKeyException || Build.VERSION.SDK_INT >= 23 && e instanceof KeyPermanentlyInvalidatedException || Build.VERSION.SDK_INT >= 26 && e instanceof UnrecoverableKeyException) {
                this.regenerateKeyAndRequestMessage(capillaryCiphertext, handler, extra);
                return;
            }
            handler.error(CapillaryHandlerErrorCode.UNKNOWN_ERROR, ciphertext, extra);
            return;
        }
        handler.handleData(capillaryCiphertext.getIsAuthKey(), data, extra);
    }

    private void regenerateKeyAndRequestMessage(CapillaryCiphertext capillaryCiphertext, CapillaryHandler handler, Object extra) {
        boolean isAuthKey = capillaryCiphertext.getIsAuthKey();
        byte[] ciphertext = capillaryCiphertext.toByteArray();
        try {
            boolean isKeyPairGenerated = this.keyManager.generateKeyPair(capillaryCiphertext.getKeySerialNumber() + 1, isAuthKey);
            if (!isKeyPairGenerated) {
                handler.error(CapillaryHandlerErrorCode.STALE_CIPHERTEXT, ciphertext, extra);
                return;
            }
            handler.handlePublicKey(isAuthKey, this.keyManager.getPublicKey(isAuthKey), ciphertext, extra);
        }
        catch (AuthModeUnavailableException | NoSuchKeyException | GeneralSecurityException e) {
            handler.error(CapillaryHandlerErrorCode.UNKNOWN_ERROR, ciphertext, extra);
        }
    }
}

