/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google$.auto.common.$AnnotationMirrors;
import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.auto.common.$MoreTypes;
import autovalue.shaded.com.google$.common.collect.$ImmutableBiMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableListMultimap;
import autovalue.shaded.com.google$.common.collect.$ImmutableMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import autovalue.shaded.com.google$.common.collect.$Iterables;
import com.google.auto.value.processor.AbortProcessingException;
import com.google.auto.value.processor.AutoOneOfTemplateVars;
import com.google.auto.value.processor.AutoValueOrOneOfProcessor;
import com.google.auto.value.processor.MissingTypeException;
import com.google.auto.value.processor.Reformatter;
import com.google.auto.value.processor.TypeEncoder;
import com.google.auto.value.processor.TypeSimplifier;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

@SupportedAnnotationTypes(value={"com.google.auto.value.AutoOneOf"})
public class AutoOneOfProcessor
extends AutoValueOrOneOfProcessor {
    public AutoOneOfProcessor() {
        super("com.google.auto.value.AutoOneOf");
    }

    @Override
    boolean propertiesCanBeVoid() {
        return true;
    }

    @Override
    void processType(TypeElement autoOneOfType) {
        if (autoOneOfType.getKind() != ElementKind.CLASS) {
            this.errorReporter().abortWithError("@com.google.auto.value.AutoOneOf only applies to classes", autoOneOfType);
        }
        this.checkModifiersIfNested(autoOneOfType);
        DeclaredType kindMirror = this.mirrorForKindType(autoOneOfType);
        $ImmutableSet<ExecutableElement> methods = $MoreElements.getLocalAndInheritedMethods(autoOneOfType, this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils());
        $ImmutableSet<ExecutableElement> abstractMethods = AutoOneOfProcessor.abstractMethodsIn(methods);
        ExecutableElement kindGetter = this.findKindGetterOrAbort(autoOneOfType, kindMirror, abstractMethods);
        LinkedHashSet<ExecutableElement> otherMethods = new LinkedHashSet<ExecutableElement>(abstractMethods);
        otherMethods.remove(kindGetter);
        $ImmutableSet<ExecutableElement> propertyMethods = this.propertyMethodsIn(otherMethods);
        $ImmutableBiMap<String, ExecutableElement> properties = this.propertyNameToMethodMap(propertyMethods);
        this.validateMethods(autoOneOfType, abstractMethods, propertyMethods, kindGetter);
        $ImmutableMap<String, String> propertyToKind = this.propertyToKindMap(kindMirror, ($ImmutableSet<String>)properties.keySet());
        String subclass = AutoOneOfProcessor.generatedClassName(autoOneOfType, "AutoOneOf_");
        AutoOneOfTemplateVars vars = new AutoOneOfTemplateVars();
        vars.generatedClass = TypeSimplifier.simpleNameOf(subclass);
        vars.propertyToKind = propertyToKind;
        this.defineSharedVarsForType(autoOneOfType, methods, vars);
        this.defineVarsForType(autoOneOfType, vars, propertyMethods, kindGetter);
        String text = vars.toText();
        text = TypeEncoder.decode(text, this.processingEnv, vars.pkg, autoOneOfType.asType());
        text = Reformatter.fixup(text);
        this.writeSourceFile(subclass, text, autoOneOfType);
    }

    private DeclaredType mirrorForKindType(TypeElement autoOneOfType) {
        AnnotationValue kindValue;
        Object value;
        Optional<AnnotationMirror> oneOfAnnotation = AutoOneOfProcessor.getAnnotationMirror(autoOneOfType, "com.google.auto.value.AutoOneOf");
        if (!oneOfAnnotation.isPresent()) {
            this.errorReporter().abortWithError("annotation processor for @AutoOneOf was invoked with a type that does not have that annotation; this is probably a compiler bug", autoOneOfType);
        }
        if ((value = (kindValue = $AnnotationMirrors.getAnnotationValue(oneOfAnnotation.get(), "value")).getValue()) instanceof TypeMirror && ((TypeMirror)value).getKind().equals((Object)TypeKind.DECLARED)) {
            return $MoreTypes.asDeclared((TypeMirror)value);
        }
        throw new MissingTypeException();
    }

    private $ImmutableMap<String, String> propertyToKindMap(DeclaredType kindMirror, $ImmutableSet<String> propertyNames) {
        TypeElement kindElement = $MoreElements.asType(kindMirror.asElement());
        Map<String, String> transformedPropertyNames = propertyNames.stream().collect(Collectors.toMap(this::transformName, s -> s));
        Map<String, Element> transformedEnumConstants = kindElement.getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)ElementKind.ENUM_CONSTANT)).collect(Collectors.toMap(e -> this.transformName(e.getSimpleName().toString()), e -> e));
        if (transformedPropertyNames.keySet().equals(transformedEnumConstants.keySet())) {
            $ImmutableMap.Builder<String, String> mapBuilder = $ImmutableMap.builder();
            for (String transformed2 : transformedPropertyNames.keySet()) {
                mapBuilder.put(transformedPropertyNames.get(transformed2), transformedEnumConstants.get(transformed2).getSimpleName().toString());
            }
            return mapBuilder.build();
        }
        transformedPropertyNames.forEach((transformed, property) -> {
            if (!transformedEnumConstants.containsKey(transformed)) {
                this.errorReporter().reportError("Enum has no constant with name corresponding to property '" + property + "'", kindElement);
            }
        });
        transformedEnumConstants.forEach((transformed, constant) -> {
            if (!transformedPropertyNames.containsKey(transformed)) {
                this.errorReporter().reportError("Name of enum constant '" + constant.getSimpleName() + "' does not correspond to any property name", (Element)constant);
            }
        });
        throw new AbortProcessingException();
    }

    private String transformName(String s) {
        return s.toLowerCase(Locale.ROOT).replace("_", "");
    }

    private ExecutableElement findKindGetterOrAbort(TypeElement autoOneOfType, TypeMirror kindMirror, $ImmutableSet<ExecutableElement> abstractMethods) {
        Set kindGetters = abstractMethods.stream().filter(e -> AutoOneOfProcessor.sameType(kindMirror, e.getReturnType())).filter(e -> e.getParameters().isEmpty()).collect(Collectors.toSet());
        switch (kindGetters.size()) {
            case 0: {
                this.errorReporter().reportError(autoOneOfType + " must have a no-arg abstract method returning " + kindMirror, autoOneOfType);
                break;
            }
            case 1: {
                return (ExecutableElement)$Iterables.getOnlyElement(kindGetters);
            }
            default: {
                for (ExecutableElement getter : kindGetters) {
                    this.errorReporter().reportError("More than one abstract method returns " + kindMirror, getter);
                }
            }
        }
        throw new AbortProcessingException();
    }

    private void validateMethods(TypeElement type, $ImmutableSet<ExecutableElement> abstractMethods, $ImmutableSet<ExecutableElement> propertyMethods, ExecutableElement kindGetter) {
        for (ExecutableElement method : abstractMethods) {
            if (propertyMethods.contains(method)) {
                this.checkReturnType(type, method);
                continue;
            }
            if (method.equals(kindGetter) || AutoOneOfProcessor.objectMethodToOverride(method) != AutoValueOrOneOfProcessor.ObjectMethod.NONE) continue;
            this.errorReporter().reportWarning("Abstract methods in @AutoOneOf classes must be non-void with no parameters", method);
        }
        this.errorReporter().abortIfAnyError();
    }

    private void defineVarsForType(TypeElement type, AutoOneOfTemplateVars vars, $ImmutableSet<ExecutableElement> propertyMethods, ExecutableElement kindGetter) {
        vars.props = this.propertySet(type, propertyMethods, $ImmutableListMultimap.of(), $ImmutableListMultimap.of());
        vars.kindGetter = kindGetter.getSimpleName().toString();
        vars.kindType = TypeEncoder.encode(kindGetter.getReturnType());
        TypeElement javaIoSerializable = this.elementUtils().getTypeElement("java.io.Serializable");
        vars.serializable = javaIoSerializable != null && this.typeUtils().isAssignable(type.asType(), javaIoSerializable.asType());
    }

    @Override
    Optional<String> nullableAnnotationForMethod(ExecutableElement propertyMethod) {
        if (AutoOneOfProcessor.nullableAnnotationFor(propertyMethod, propertyMethod.getReturnType()).isPresent()) {
            this.errorReporter().reportError("@AutoOneOf properties cannot be @Nullable", propertyMethod);
        }
        return Optional.empty();
    }

    private static boolean sameType(TypeMirror t1, TypeMirror t2) {
        return $MoreTypes.equivalence().equivalent(t1, t2);
    }
}

