/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.format;

import com.google.appengine.repackaged.org.joda.time.format.PeriodFormatter;
import com.google.appengine.repackaged.org.joda.time.format.PeriodFormatterBuilder;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PeriodFormat {
    private static final String BUNDLE_NAME = "com.google.appengine.repackaged.org.joda.time.format.messages";
    private static final ConcurrentMap<Locale, PeriodFormatter> FORMATTERS = new ConcurrentHashMap<Locale, PeriodFormatter>();

    protected PeriodFormat() {
    }

    public static PeriodFormatter getDefault() {
        return PeriodFormat.wordBased(Locale.ENGLISH);
    }

    public static PeriodFormatter wordBased() {
        return PeriodFormat.wordBased(Locale.getDefault());
    }

    public static PeriodFormatter wordBased(Locale locale) {
        PeriodFormatter pf = (PeriodFormatter)FORMATTERS.get(locale);
        if (pf == null) {
            ResourceBundle b = ResourceBundle.getBundle(BUNDLE_NAME, locale);
            String[] variants = new String[]{b.getString("PeriodFormat.space"), b.getString("PeriodFormat.comma"), b.getString("PeriodFormat.commandand"), b.getString("PeriodFormat.commaspaceand")};
            pf = new PeriodFormatterBuilder().appendYears().appendSuffix(b.getString("PeriodFormat.year"), b.getString("PeriodFormat.years")).appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants).appendMonths().appendSuffix(b.getString("PeriodFormat.month"), b.getString("PeriodFormat.months")).appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants).appendWeeks().appendSuffix(b.getString("PeriodFormat.week"), b.getString("PeriodFormat.weeks")).appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants).appendDays().appendSuffix(b.getString("PeriodFormat.day"), b.getString("PeriodFormat.days")).appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants).appendHours().appendSuffix(b.getString("PeriodFormat.hour"), b.getString("PeriodFormat.hours")).appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants).appendMinutes().appendSuffix(b.getString("PeriodFormat.minute"), b.getString("PeriodFormat.minutes")).appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants).appendSeconds().appendSuffix(b.getString("PeriodFormat.second"), b.getString("PeriodFormat.seconds")).appendSeparator(b.getString("PeriodFormat.commaspace"), b.getString("PeriodFormat.spaceandspace"), variants).appendMillis().appendSuffix(b.getString("PeriodFormat.millisecond"), b.getString("PeriodFormat.milliseconds")).toFormatter();
            FORMATTERS.putIfAbsent(locale, pf);
        }
        return pf;
    }
}

