/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.base.shell;

import com.google.appengine.repackaged.com.google.common.time.Durations;
import com.google.appengine.repackaged.com.google.common.time.Sleeper;
import com.google.appengine.repackaged.com.google.io.base.shell.Killable;
import com.google.appengine.repackaged.com.google.io.base.shell.KillableObserver;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TimeoutKillableObserver
implements KillableObserver {
    private static final Logger log = Logger.getLogger("com.google.appengine.repackaged.com.google.io.base.shell.TimeoutKillableObserver");
    private static final Sleeper sleeper = Sleeper.defaultSleeper();
    private final Duration timeout;
    private Killable killable;
    private SleeperThread sleeperThread;
    private boolean timedOut;

    public TimeoutKillableObserver(Duration timeout) {
        this.timeout = Durations.checkNotNegative(timeout);
    }

    @Override
    public synchronized void startObserving(Killable killable) {
        this.timedOut = false;
        this.killable = killable;
        this.sleeperThread = new SleeperThread();
        this.sleeperThread.start();
    }

    @Override
    public synchronized void stopObserving(Killable killable) {
        if (!this.killable.equals(killable)) {
            throw new IllegalStateException("start/stopObservering called with different Killables");
        }
        if (this.sleeperThread.isAlive()) {
            this.sleeperThread.interrupt();
        }
        this.killable = null;
        this.sleeperThread = null;
    }

    public synchronized boolean hasTimedOut() {
        return this.timedOut;
    }

    private final class SleeperThread
    extends Thread {
        private SleeperThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object;
                if (log.isLoggable(Level.FINE)) {
                    object = String.valueOf(TimeoutKillableObserver.this.timeout);
                    log.logp(Level.FINE, "com.google.appengine.repackaged.com.google.io.base.shell.TimeoutKillableObserver$SleeperThread", "run", new StringBuilder(28 + String.valueOf(object).length()).append("Waiting for ").append((String)object).append(" to kill process").toString());
                }
                sleeper.sleep(TimeoutKillableObserver.this.timeout);
                object = TimeoutKillableObserver.this;
                synchronized (object) {
                    if (TimeoutKillableObserver.this.killable != null) {
                        log.logp(Level.FINE, "com.google.appengine.repackaged.com.google.io.base.shell.TimeoutKillableObserver$SleeperThread", "run", "Killing process");
                        TimeoutKillableObserver.this.killable.kill();
                        TimeoutKillableObserver.this.timedOut = true;
                    }
                }
            }
            catch (InterruptedException ie) {
                log.logp(Level.FINE, "com.google.appengine.repackaged.com.google.io.base.shell.TimeoutKillableObserver$SleeperThread", "run", "Wait interrupted since process finished; continuing...");
            }
        }
    }
}

