/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTime;
import com.google.appengine.repackaged.org.joda.time.DateTimeField;
import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.DurationFieldType;
import com.google.appengine.repackaged.org.joda.time.LocalDate;
import com.google.appengine.repackaged.org.joda.time.LocalTime;
import com.google.appengine.repackaged.org.joda.time.ReadableDuration;
import com.google.appengine.repackaged.org.joda.time.ReadablePartial;
import com.google.appengine.repackaged.org.joda.time.ReadablePeriod;
import com.google.appengine.repackaged.org.joda.time.base.BaseLocal;
import com.google.appengine.repackaged.org.joda.time.chrono.ISOChronology;
import com.google.appengine.repackaged.org.joda.time.convert.ConverterManager;
import com.google.appengine.repackaged.org.joda.time.convert.PartialConverter;
import com.google.appengine.repackaged.org.joda.time.field.AbstractReadableInstantFieldProperty;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormat;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormatter;
import com.google.appengine.repackaged.org.joda.time.format.ISODateTimeFormat;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class LocalDateTime
extends BaseLocal
implements ReadablePartial,
Serializable {
    private static final long serialVersionUID = -268716875315837168L;
    private static final int YEAR = 0;
    private static final int MONTH_OF_YEAR = 1;
    private static final int DAY_OF_MONTH = 2;
    private static final int MILLIS_OF_DAY = 3;
    private final long iLocalMillis;
    private final Chronology iChronology;

    public static LocalDateTime now() {
        return new LocalDateTime();
    }

    public static LocalDateTime now(DateTimeZone zone) {
        if (zone == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new LocalDateTime(zone);
    }

    public static LocalDateTime now(Chronology chronology) {
        if (chronology == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new LocalDateTime(chronology);
    }

    @FromString
    public static LocalDateTime parse(String str) {
        return LocalDateTime.parse(str, ISODateTimeFormat.localDateOptionalTimeParser());
    }

    public static LocalDateTime parse(String str, DateTimeFormatter formatter) {
        return formatter.parseLocalDateTime(str);
    }

    public static LocalDateTime fromCalendarFields(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new LocalDateTime(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public static LocalDateTime fromDateFields(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new LocalDateTime(date.getYear() + 1900, date.getMonth() + 1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), (int)(date.getTime() % 1000L));
    }

    public LocalDateTime() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance());
    }

    public LocalDateTime(DateTimeZone zone) {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance(zone));
    }

    public LocalDateTime(Chronology chronology) {
        this(DateTimeUtils.currentTimeMillis(), chronology);
    }

    public LocalDateTime(long instant) {
        this(instant, (Chronology)ISOChronology.getInstance());
    }

    public LocalDateTime(long instant, DateTimeZone zone) {
        this(instant, (Chronology)ISOChronology.getInstance(zone));
    }

    public LocalDateTime(long instant, Chronology chronology) {
        long localMillis;
        chronology = DateTimeUtils.getChronology(chronology);
        this.iLocalMillis = localMillis = chronology.getZone().getMillisKeepLocal(DateTimeZone.UTC, instant);
        this.iChronology = chronology.withUTC();
    }

    public LocalDateTime(Object instant) {
        this(instant, (Chronology)null);
    }

    public LocalDateTime(Object instant, DateTimeZone zone) {
        PartialConverter converter = ConverterManager.getInstance().getPartialConverter(instant);
        Chronology chronology = converter.getChronology(instant, zone);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        int[] values = converter.getPartialValues(this, instant, chronology, ISODateTimeFormat.localDateOptionalTimeParser());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(values[0], values[1], values[2], values[3]);
    }

    public LocalDateTime(Object instant, Chronology chronology) {
        PartialConverter converter = ConverterManager.getInstance().getPartialConverter(instant);
        chronology = converter.getChronology(instant, chronology);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        int[] values = converter.getPartialValues(this, instant, chronology, ISODateTimeFormat.localDateOptionalTimeParser());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(values[0], values[1], values[2], values[3]);
    }

    public LocalDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour) {
        this(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, 0, 0, ISOChronology.getInstanceUTC());
    }

    public LocalDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute) {
        this(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, 0, ISOChronology.getInstanceUTC());
    }

    public LocalDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        this(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, ISOChronology.getInstanceUTC());
    }

    public LocalDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology).withUTC();
        long instant = chronology.getDateTimeMillis(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
        this.iChronology = chronology;
        this.iLocalMillis = instant;
    }

    private Object readResolve() {
        if (this.iChronology == null) {
            return new LocalDateTime(this.iLocalMillis, (Chronology)ISOChronology.getInstanceUTC());
        }
        if (!DateTimeZone.UTC.equals(this.iChronology.getZone())) {
            return new LocalDateTime(this.iLocalMillis, this.iChronology.withUTC());
        }
        return this;
    }

    @Override
    public int size() {
        return 4;
    }

    @Override
    protected DateTimeField getField(int index, Chronology chrono) {
        switch (index) {
            case 0: {
                return chrono.year();
            }
            case 1: {
                return chrono.monthOfYear();
            }
            case 2: {
                return chrono.dayOfMonth();
            }
            case 3: {
                return chrono.millisOfDay();
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + index);
    }

    @Override
    public int getValue(int index) {
        switch (index) {
            case 0: {
                return this.getChronology().year().get(this.getLocalMillis());
            }
            case 1: {
                return this.getChronology().monthOfYear().get(this.getLocalMillis());
            }
            case 2: {
                return this.getChronology().dayOfMonth().get(this.getLocalMillis());
            }
            case 3: {
                return this.getChronology().millisOfDay().get(this.getLocalMillis());
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + index);
    }

    @Override
    public int get(DateTimeFieldType type) {
        if (type == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        return type.getField(this.getChronology()).get(this.getLocalMillis());
    }

    @Override
    public boolean isSupported(DateTimeFieldType type) {
        if (type == null) {
            return false;
        }
        return type.getField(this.getChronology()).isSupported();
    }

    public boolean isSupported(DurationFieldType type) {
        if (type == null) {
            return false;
        }
        return type.getField(this.getChronology()).isSupported();
    }

    @Override
    protected long getLocalMillis() {
        return this.iLocalMillis;
    }

    @Override
    public Chronology getChronology() {
        return this.iChronology;
    }

    @Override
    public boolean equals(Object partial) {
        if (this == partial) {
            return true;
        }
        if (partial instanceof LocalDateTime) {
            LocalDateTime other = (LocalDateTime)partial;
            if (this.iChronology.equals(other.iChronology)) {
                return this.iLocalMillis == other.iLocalMillis;
            }
        }
        return super.equals(partial);
    }

    @Override
    public int compareTo(ReadablePartial partial) {
        if (this == partial) {
            return 0;
        }
        if (partial instanceof LocalDateTime) {
            LocalDateTime other = (LocalDateTime)partial;
            if (this.iChronology.equals(other.iChronology)) {
                return this.iLocalMillis < other.iLocalMillis ? -1 : (this.iLocalMillis == other.iLocalMillis ? 0 : 1);
            }
        }
        return super.compareTo(partial);
    }

    public DateTime toDateTime() {
        return this.toDateTime((DateTimeZone)null);
    }

    public DateTime toDateTime(DateTimeZone zone) {
        zone = DateTimeUtils.getZone(zone);
        Chronology chrono = this.iChronology.withZone(zone);
        return new DateTime(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), this.getHourOfDay(), this.getMinuteOfHour(), this.getSecondOfMinute(), this.getMillisOfSecond(), chrono);
    }

    public LocalDate toLocalDate() {
        return new LocalDate(this.getLocalMillis(), this.getChronology());
    }

    public LocalTime toLocalTime() {
        return new LocalTime(this.getLocalMillis(), this.getChronology());
    }

    public Date toDate() {
        Date earlier;
        int dom = this.getDayOfMonth();
        Date date = new Date(this.getYear() - 1900, this.getMonthOfYear() - 1, dom, this.getHourOfDay(), this.getMinuteOfHour(), this.getSecondOfMinute());
        date.setTime(date.getTime() + (long)this.getMillisOfSecond());
        LocalDateTime check = LocalDateTime.fromDateFields(date);
        if (check.isBefore(this)) {
            while (check.isBefore(this)) {
                date.setTime(date.getTime() + 60000L);
                check = LocalDateTime.fromDateFields(date);
            }
            while (!check.isBefore(this)) {
                date.setTime(date.getTime() - 1000L);
                check = LocalDateTime.fromDateFields(date);
            }
            date.setTime(date.getTime() + 1000L);
        } else if (check.equals(this) && (check = LocalDateTime.fromDateFields(earlier = new Date(date.getTime() - (long)TimeZone.getDefault().getDSTSavings()))).equals(this)) {
            date = earlier;
        }
        return date;
    }

    LocalDateTime withLocalMillis(long newMillis) {
        return newMillis == this.getLocalMillis() ? this : new LocalDateTime(newMillis, this.getChronology());
    }

    public LocalDateTime withDate(int year, int monthOfYear, int dayOfMonth) {
        Chronology chrono = this.getChronology();
        long instant = this.getLocalMillis();
        instant = chrono.year().set(instant, year);
        instant = chrono.monthOfYear().set(instant, monthOfYear);
        instant = chrono.dayOfMonth().set(instant, dayOfMonth);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime withTime(int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        Chronology chrono = this.getChronology();
        long instant = this.getLocalMillis();
        instant = chrono.hourOfDay().set(instant, hourOfDay);
        instant = chrono.minuteOfHour().set(instant, minuteOfHour);
        instant = chrono.secondOfMinute().set(instant, secondOfMinute);
        instant = chrono.millisOfSecond().set(instant, millisOfSecond);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime withFields(ReadablePartial partial) {
        if (partial == null) {
            return this;
        }
        return this.withLocalMillis(this.getChronology().set(partial, this.getLocalMillis()));
    }

    public LocalDateTime withField(DateTimeFieldType fieldType, int value) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        long instant = fieldType.getField(this.getChronology()).set(this.getLocalMillis(), value);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime withFieldAdded(DurationFieldType fieldType, int amount) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (amount == 0) {
            return this;
        }
        long instant = fieldType.getField(this.getChronology()).add(this.getLocalMillis(), amount);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime withDurationAdded(ReadableDuration durationToAdd, int scalar) {
        if (durationToAdd == null || scalar == 0) {
            return this;
        }
        long instant = this.getChronology().add(this.getLocalMillis(), durationToAdd.getMillis(), scalar);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime withPeriodAdded(ReadablePeriod period, int scalar) {
        if (period == null || scalar == 0) {
            return this;
        }
        long instant = this.getChronology().add(period, this.getLocalMillis(), scalar);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime plus(ReadableDuration duration) {
        return this.withDurationAdded(duration, 1);
    }

    public LocalDateTime plus(ReadablePeriod period) {
        return this.withPeriodAdded(period, 1);
    }

    public LocalDateTime plusYears(int years) {
        if (years == 0) {
            return this;
        }
        long instant = this.getChronology().years().add(this.getLocalMillis(), years);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime plusMonths(int months) {
        if (months == 0) {
            return this;
        }
        long instant = this.getChronology().months().add(this.getLocalMillis(), months);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime plusWeeks(int weeks) {
        if (weeks == 0) {
            return this;
        }
        long instant = this.getChronology().weeks().add(this.getLocalMillis(), weeks);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime plusDays(int days) {
        if (days == 0) {
            return this;
        }
        long instant = this.getChronology().days().add(this.getLocalMillis(), days);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime plusHours(int hours) {
        if (hours == 0) {
            return this;
        }
        long instant = this.getChronology().hours().add(this.getLocalMillis(), hours);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime plusMinutes(int minutes) {
        if (minutes == 0) {
            return this;
        }
        long instant = this.getChronology().minutes().add(this.getLocalMillis(), minutes);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime plusSeconds(int seconds) {
        if (seconds == 0) {
            return this;
        }
        long instant = this.getChronology().seconds().add(this.getLocalMillis(), seconds);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime plusMillis(int millis) {
        if (millis == 0) {
            return this;
        }
        long instant = this.getChronology().millis().add(this.getLocalMillis(), millis);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime minus(ReadableDuration duration) {
        return this.withDurationAdded(duration, -1);
    }

    public LocalDateTime minus(ReadablePeriod period) {
        return this.withPeriodAdded(period, -1);
    }

    public LocalDateTime minusYears(int years) {
        if (years == 0) {
            return this;
        }
        long instant = this.getChronology().years().subtract(this.getLocalMillis(), years);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime minusMonths(int months) {
        if (months == 0) {
            return this;
        }
        long instant = this.getChronology().months().subtract(this.getLocalMillis(), months);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime minusWeeks(int weeks) {
        if (weeks == 0) {
            return this;
        }
        long instant = this.getChronology().weeks().subtract(this.getLocalMillis(), weeks);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime minusDays(int days) {
        if (days == 0) {
            return this;
        }
        long instant = this.getChronology().days().subtract(this.getLocalMillis(), days);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime minusHours(int hours) {
        if (hours == 0) {
            return this;
        }
        long instant = this.getChronology().hours().subtract(this.getLocalMillis(), hours);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime minusMinutes(int minutes) {
        if (minutes == 0) {
            return this;
        }
        long instant = this.getChronology().minutes().subtract(this.getLocalMillis(), minutes);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime minusSeconds(int seconds) {
        if (seconds == 0) {
            return this;
        }
        long instant = this.getChronology().seconds().subtract(this.getLocalMillis(), seconds);
        return this.withLocalMillis(instant);
    }

    public LocalDateTime minusMillis(int millis) {
        if (millis == 0) {
            return this;
        }
        long instant = this.getChronology().millis().subtract(this.getLocalMillis(), millis);
        return this.withLocalMillis(instant);
    }

    public Property property(DateTimeFieldType fieldType) {
        if (fieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(fieldType)) {
            throw new IllegalArgumentException("Field '" + fieldType + "' is not supported");
        }
        return new Property(this, fieldType.getField(this.getChronology()));
    }

    public int getEra() {
        return this.getChronology().era().get(this.getLocalMillis());
    }

    public int getCenturyOfEra() {
        return this.getChronology().centuryOfEra().get(this.getLocalMillis());
    }

    public int getYearOfEra() {
        return this.getChronology().yearOfEra().get(this.getLocalMillis());
    }

    public int getYearOfCentury() {
        return this.getChronology().yearOfCentury().get(this.getLocalMillis());
    }

    public int getYear() {
        return this.getChronology().year().get(this.getLocalMillis());
    }

    public int getWeekyear() {
        return this.getChronology().weekyear().get(this.getLocalMillis());
    }

    public int getMonthOfYear() {
        return this.getChronology().monthOfYear().get(this.getLocalMillis());
    }

    public int getWeekOfWeekyear() {
        return this.getChronology().weekOfWeekyear().get(this.getLocalMillis());
    }

    public int getDayOfYear() {
        return this.getChronology().dayOfYear().get(this.getLocalMillis());
    }

    public int getDayOfMonth() {
        return this.getChronology().dayOfMonth().get(this.getLocalMillis());
    }

    public int getDayOfWeek() {
        return this.getChronology().dayOfWeek().get(this.getLocalMillis());
    }

    public int getHourOfDay() {
        return this.getChronology().hourOfDay().get(this.getLocalMillis());
    }

    public int getMinuteOfHour() {
        return this.getChronology().minuteOfHour().get(this.getLocalMillis());
    }

    public int getSecondOfMinute() {
        return this.getChronology().secondOfMinute().get(this.getLocalMillis());
    }

    public int getMillisOfSecond() {
        return this.getChronology().millisOfSecond().get(this.getLocalMillis());
    }

    public int getMillisOfDay() {
        return this.getChronology().millisOfDay().get(this.getLocalMillis());
    }

    public LocalDateTime withEra(int era) {
        return this.withLocalMillis(this.getChronology().era().set(this.getLocalMillis(), era));
    }

    public LocalDateTime withCenturyOfEra(int centuryOfEra) {
        return this.withLocalMillis(this.getChronology().centuryOfEra().set(this.getLocalMillis(), centuryOfEra));
    }

    public LocalDateTime withYearOfEra(int yearOfEra) {
        return this.withLocalMillis(this.getChronology().yearOfEra().set(this.getLocalMillis(), yearOfEra));
    }

    public LocalDateTime withYearOfCentury(int yearOfCentury) {
        return this.withLocalMillis(this.getChronology().yearOfCentury().set(this.getLocalMillis(), yearOfCentury));
    }

    public LocalDateTime withYear(int year) {
        return this.withLocalMillis(this.getChronology().year().set(this.getLocalMillis(), year));
    }

    public LocalDateTime withWeekyear(int weekyear) {
        return this.withLocalMillis(this.getChronology().weekyear().set(this.getLocalMillis(), weekyear));
    }

    public LocalDateTime withMonthOfYear(int monthOfYear) {
        return this.withLocalMillis(this.getChronology().monthOfYear().set(this.getLocalMillis(), monthOfYear));
    }

    public LocalDateTime withWeekOfWeekyear(int weekOfWeekyear) {
        return this.withLocalMillis(this.getChronology().weekOfWeekyear().set(this.getLocalMillis(), weekOfWeekyear));
    }

    public LocalDateTime withDayOfYear(int dayOfYear) {
        return this.withLocalMillis(this.getChronology().dayOfYear().set(this.getLocalMillis(), dayOfYear));
    }

    public LocalDateTime withDayOfMonth(int dayOfMonth) {
        return this.withLocalMillis(this.getChronology().dayOfMonth().set(this.getLocalMillis(), dayOfMonth));
    }

    public LocalDateTime withDayOfWeek(int dayOfWeek) {
        return this.withLocalMillis(this.getChronology().dayOfWeek().set(this.getLocalMillis(), dayOfWeek));
    }

    public LocalDateTime withHourOfDay(int hour) {
        return this.withLocalMillis(this.getChronology().hourOfDay().set(this.getLocalMillis(), hour));
    }

    public LocalDateTime withMinuteOfHour(int minute) {
        return this.withLocalMillis(this.getChronology().minuteOfHour().set(this.getLocalMillis(), minute));
    }

    public LocalDateTime withSecondOfMinute(int second) {
        return this.withLocalMillis(this.getChronology().secondOfMinute().set(this.getLocalMillis(), second));
    }

    public LocalDateTime withMillisOfSecond(int millis) {
        return this.withLocalMillis(this.getChronology().millisOfSecond().set(this.getLocalMillis(), millis));
    }

    public LocalDateTime withMillisOfDay(int millis) {
        return this.withLocalMillis(this.getChronology().millisOfDay().set(this.getLocalMillis(), millis));
    }

    public Property era() {
        return new Property(this, this.getChronology().era());
    }

    public Property centuryOfEra() {
        return new Property(this, this.getChronology().centuryOfEra());
    }

    public Property yearOfCentury() {
        return new Property(this, this.getChronology().yearOfCentury());
    }

    public Property yearOfEra() {
        return new Property(this, this.getChronology().yearOfEra());
    }

    public Property year() {
        return new Property(this, this.getChronology().year());
    }

    public Property weekyear() {
        return new Property(this, this.getChronology().weekyear());
    }

    public Property monthOfYear() {
        return new Property(this, this.getChronology().monthOfYear());
    }

    public Property weekOfWeekyear() {
        return new Property(this, this.getChronology().weekOfWeekyear());
    }

    public Property dayOfYear() {
        return new Property(this, this.getChronology().dayOfYear());
    }

    public Property dayOfMonth() {
        return new Property(this, this.getChronology().dayOfMonth());
    }

    public Property dayOfWeek() {
        return new Property(this, this.getChronology().dayOfWeek());
    }

    public Property hourOfDay() {
        return new Property(this, this.getChronology().hourOfDay());
    }

    public Property minuteOfHour() {
        return new Property(this, this.getChronology().minuteOfHour());
    }

    public Property secondOfMinute() {
        return new Property(this, this.getChronology().secondOfMinute());
    }

    public Property millisOfSecond() {
        return new Property(this, this.getChronology().millisOfSecond());
    }

    public Property millisOfDay() {
        return new Property(this, this.getChronology().millisOfDay());
    }

    @Override
    @ToString
    public String toString() {
        return ISODateTimeFormat.dateTime().print(this);
    }

    public String toString(String pattern) {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(pattern).print(this);
    }

    public String toString(String pattern, Locale locale) throws IllegalArgumentException {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(pattern).withLocale(locale).print(this);
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private static final long serialVersionUID = -358138762846288L;
        private transient LocalDateTime iInstant;
        private transient DateTimeField iField;

        Property(LocalDateTime instant, DateTimeField field) {
            this.iInstant = instant;
            this.iField = field;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeObject(this.iInstant);
            oos.writeObject(this.iField.getType());
        }

        private void readObject(ObjectInputStream oos) throws IOException, ClassNotFoundException {
            this.iInstant = (LocalDateTime)oos.readObject();
            DateTimeFieldType type = (DateTimeFieldType)oos.readObject();
            this.iField = type.getField(this.iInstant.getChronology());
        }

        @Override
        public DateTimeField getField() {
            return this.iField;
        }

        @Override
        protected long getMillis() {
            return this.iInstant.getLocalMillis();
        }

        @Override
        protected Chronology getChronology() {
            return this.iInstant.getChronology();
        }

        public LocalDateTime getLocalDateTime() {
            return this.iInstant;
        }

        public LocalDateTime addToCopy(int value) {
            return this.iInstant.withLocalMillis(this.iField.add(this.iInstant.getLocalMillis(), value));
        }

        public LocalDateTime addToCopy(long value) {
            return this.iInstant.withLocalMillis(this.iField.add(this.iInstant.getLocalMillis(), value));
        }

        public LocalDateTime addWrapFieldToCopy(int value) {
            return this.iInstant.withLocalMillis(this.iField.addWrapField(this.iInstant.getLocalMillis(), value));
        }

        public LocalDateTime setCopy(int value) {
            return this.iInstant.withLocalMillis(this.iField.set(this.iInstant.getLocalMillis(), value));
        }

        public LocalDateTime setCopy(String text, Locale locale) {
            return this.iInstant.withLocalMillis(this.iField.set(this.iInstant.getLocalMillis(), text, locale));
        }

        public LocalDateTime setCopy(String text) {
            return this.setCopy(text, null);
        }

        public LocalDateTime withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public LocalDateTime withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }

        public LocalDateTime roundFloorCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundFloor(this.iInstant.getLocalMillis()));
        }

        public LocalDateTime roundCeilingCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundCeiling(this.iInstant.getLocalMillis()));
        }

        public LocalDateTime roundHalfFloorCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfFloor(this.iInstant.getLocalMillis()));
        }

        public LocalDateTime roundHalfCeilingCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfCeiling(this.iInstant.getLocalMillis()));
        }

        public LocalDateTime roundHalfEvenCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfEven(this.iInstant.getLocalMillis()));
        }
    }
}

