/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base.genfiles;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.X;
import java.io.Serializable;

@GoogleInternal
public final class BooleanArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean[] list;
    private int length;

    @Deprecated
    public BooleanArray() {
        this.list = new boolean[4];
        this.length = 0;
    }

    @Deprecated
    public BooleanArray(int capacity) {
        this.list = new boolean[capacity];
        this.length = 0;
    }

    public BooleanArray(boolean[] source, int start, int num) {
        X.assertTrue(num >= 0);
        this.list = new boolean[num];
        this.length = num;
        System.arraycopy(source, start, this.list, 0, num);
    }

    @Deprecated
    private BooleanArray(boolean[] array, int arrayLength) {
        this.list = array;
        this.length = arrayLength;
    }

    @Deprecated
    public static BooleanArray newInstance(boolean ... array) {
        Preconditions.checkNotNull(array);
        return new BooleanArray(array, array.length);
    }

    public int size() {
        return this.length;
    }

    public boolean get(int i) {
        X.assertTrue(i >= 0 && i < this.length);
        return this.list[i];
    }

    public void set(int i, boolean x) {
        X.assertTrue(i >= 0 && i < this.length);
        this.list[i] = x;
    }

    public void add(boolean x) {
        if (this.length >= this.list.length) {
            this.ensureCapacity(this.length + 1);
        }
        this.list[this.length++] = x;
    }

    public void add(boolean[] source, int start, int num) {
        if (this.length + num > this.list.length) {
            this.ensureCapacity(this.length + num);
        }
        System.arraycopy(source, start, this.list, this.length, num);
        this.length += num;
    }

    public void addArray(BooleanArray other) {
        this.add(other.rep(), 0, other.size());
    }

    public void clear() {
        this.length = 0;
    }

    public void ensureCapacity(int n) {
        if (this.list.length < n) {
            int newSize = this.list.length * 2;
            if (newSize < n) {
                newSize = n;
            }
            boolean[] copy = new boolean[newSize];
            System.arraycopy(this.list, 0, copy, 0, this.length);
            this.list = copy;
        }
    }

    public boolean[] rep() {
        return this.list;
    }

    public void trimToSize() {
        if (this.list.length != this.length) {
            this.list = this.toArray();
        }
    }

    public boolean[] toArray() {
        boolean[] copy = new boolean[this.length];
        System.arraycopy(this.list, 0, copy, 0, this.length);
        return copy;
    }
}

