/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.pagespeedonline.v5;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.pagespeedonline.v5.PagespeedInsightsRequest;
import com.google.api.services.pagespeedonline.v5.PagespeedInsightsRequestInitializer;
import com.google.api.services.pagespeedonline.v5.model.PagespeedApiPagespeedResponseV5;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

public class PagespeedInsights
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://pagespeedonline.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://pagespeedonline.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://pagespeedonline.googleapis.com/";

    public PagespeedInsights(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    PagespeedInsights(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Pagespeedapi pagespeedapi() {
        return new Pagespeedapi();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.31.0 of the PageSpeed Insights API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return PagespeedInsights.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://pagespeedonline.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), PagespeedInsights.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(PagespeedInsights.DEFAULT_BATCH_PATH);
        }

        public PagespeedInsights build() {
            return new PagespeedInsights(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setPagespeedInsightsRequestInitializer(PagespeedInsightsRequestInitializer pagespeedinsightsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)pagespeedinsightsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Pagespeedapi {
        public Runpagespeed runpagespeed(String url) throws IOException {
            Runpagespeed result = new Runpagespeed(url);
            PagespeedInsights.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Runpagespeed
        extends PagespeedInsightsRequest<PagespeedApiPagespeedResponseV5> {
            private static final String REST_PATH = "pagespeedonline/v5/runPagespeed";
            private final Pattern URL_PATTERN;
            private final Pattern LOCALE_PATTERN;
            @Key
            private String url;
            @Key
            private String captchaToken;
            @Key
            private List<String> category;
            @Key
            private String locale;
            @Key
            private String strategy;
            @Key(value="utm_campaign")
            private String utmCampaign;
            @Key(value="utm_source")
            private String utmSource;

            protected Runpagespeed(String url) {
                super(PagespeedInsights.this, "GET", REST_PATH, null, PagespeedApiPagespeedResponseV5.class);
                this.URL_PATTERN = Pattern.compile("(?i)(url:|origin:)?http(s)?://.*");
                this.LOCALE_PATTERN = Pattern.compile("[a-zA-Z]+((_|-)[a-zA-Z]+)?");
                this.url = (String)Preconditions.checkNotNull((Object)url, (Object)"Required parameter url must be specified.");
                if (!PagespeedInsights.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_PATTERN.matcher(url).matches(), (Object)"Parameter url must conform to the pattern (?i)(url:|origin:)?http(s)?://.*");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Runpagespeed set$Xgafv(String $Xgafv) {
                return (Runpagespeed)super.set$Xgafv($Xgafv);
            }

            public Runpagespeed setAccessToken(String accessToken) {
                return (Runpagespeed)super.setAccessToken(accessToken);
            }

            public Runpagespeed setAlt(String alt) {
                return (Runpagespeed)super.setAlt(alt);
            }

            public Runpagespeed setCallback(String callback) {
                return (Runpagespeed)super.setCallback(callback);
            }

            public Runpagespeed setFields(String fields) {
                return (Runpagespeed)super.setFields(fields);
            }

            public Runpagespeed setKey(String key) {
                return (Runpagespeed)super.setKey(key);
            }

            public Runpagespeed setOauthToken(String oauthToken) {
                return (Runpagespeed)super.setOauthToken(oauthToken);
            }

            public Runpagespeed setPrettyPrint(Boolean prettyPrint) {
                return (Runpagespeed)super.setPrettyPrint(prettyPrint);
            }

            public Runpagespeed setQuotaUser(String quotaUser) {
                return (Runpagespeed)super.setQuotaUser(quotaUser);
            }

            public Runpagespeed setUploadType(String uploadType) {
                return (Runpagespeed)super.setUploadType(uploadType);
            }

            public Runpagespeed setUploadProtocol(String uploadProtocol) {
                return (Runpagespeed)super.setUploadProtocol(uploadProtocol);
            }

            public String getUrl() {
                return this.url;
            }

            public Runpagespeed setUrl(String url) {
                if (!PagespeedInsights.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_PATTERN.matcher(url).matches(), (Object)"Parameter url must conform to the pattern (?i)(url:|origin:)?http(s)?://.*");
                }
                this.url = url;
                return this;
            }

            public String getCaptchaToken() {
                return this.captchaToken;
            }

            public Runpagespeed setCaptchaToken(String captchaToken) {
                this.captchaToken = captchaToken;
                return this;
            }

            public List<String> getCategory() {
                return this.category;
            }

            public Runpagespeed setCategory(List<String> category) {
                this.category = category;
                return this;
            }

            public String getLocale() {
                return this.locale;
            }

            public Runpagespeed setLocale(String locale) {
                if (!PagespeedInsights.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.LOCALE_PATTERN.matcher(locale).matches(), (Object)"Parameter locale must conform to the pattern [a-zA-Z]+((_|-)[a-zA-Z]+)?");
                }
                this.locale = locale;
                return this;
            }

            public String getStrategy() {
                return this.strategy;
            }

            public Runpagespeed setStrategy(String strategy) {
                this.strategy = strategy;
                return this;
            }

            public String getUtmCampaign() {
                return this.utmCampaign;
            }

            public Runpagespeed setUtmCampaign(String utmCampaign) {
                this.utmCampaign = utmCampaign;
                return this;
            }

            public String getUtmSource() {
                return this.utmSource;
            }

            public Runpagespeed setUtmSource(String utmSource) {
                this.utmSource = utmSource;
                return this;
            }

            @Override
            public Runpagespeed set(String parameterName, Object value) {
                return (Runpagespeed)super.set(parameterName, value);
            }
        }
    }
}

