/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-03-23 at 03:23:23 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * An S/MIME email config.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SmimeInfo extends com.google.api.client.json.GenericJson {

  /**
   * Encrypted key password, when key is encrypted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String encryptedKeyPassword;

  /**
   * When the certificate expires (in milliseconds since epoch).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long expiration;

  /**
   * The immutable ID for the SmimeInfo.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Whether this SmimeInfo is the default one for this user's send-as address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isDefault;

  /**
   * The S/MIME certificate issuer's common name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String issuerCn;

  /**
   * PEM formatted X509 concatenated certificate string (standard base64 encoding). Format used for
   * returning key, which includes public key as well as certificate chain (not private key).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pem;

  /**
   * PKCS#12 format containing a single private/public key pair and certificate chain. This format
   * is only accepted from client for creating a new SmimeInfo and is never returned, because the
   * private key is not intended to be exported. PKCS#12 may be encrypted, in which case
   * encryptedKeyPassword should be set appropriately.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pkcs12;

  /**
   * Encrypted key password, when key is encrypted.
   * @return value or {@code null} for none
   */
  public java.lang.String getEncryptedKeyPassword() {
    return encryptedKeyPassword;
  }

  /**
   * Encrypted key password, when key is encrypted.
   * @param encryptedKeyPassword encryptedKeyPassword or {@code null} for none
   */
  public SmimeInfo setEncryptedKeyPassword(java.lang.String encryptedKeyPassword) {
    this.encryptedKeyPassword = encryptedKeyPassword;
    return this;
  }

  /**
   * When the certificate expires (in milliseconds since epoch).
   * @return value or {@code null} for none
   */
  public java.lang.Long getExpiration() {
    return expiration;
  }

  /**
   * When the certificate expires (in milliseconds since epoch).
   * @param expiration expiration or {@code null} for none
   */
  public SmimeInfo setExpiration(java.lang.Long expiration) {
    this.expiration = expiration;
    return this;
  }

  /**
   * The immutable ID for the SmimeInfo.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The immutable ID for the SmimeInfo.
   * @param id id or {@code null} for none
   */
  public SmimeInfo setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Whether this SmimeInfo is the default one for this user's send-as address.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsDefault() {
    return isDefault;
  }

  /**
   * Whether this SmimeInfo is the default one for this user's send-as address.
   * @param isDefault isDefault or {@code null} for none
   */
  public SmimeInfo setIsDefault(java.lang.Boolean isDefault) {
    this.isDefault = isDefault;
    return this;
  }

  /**
   * The S/MIME certificate issuer's common name.
   * @return value or {@code null} for none
   */
  public java.lang.String getIssuerCn() {
    return issuerCn;
  }

  /**
   * The S/MIME certificate issuer's common name.
   * @param issuerCn issuerCn or {@code null} for none
   */
  public SmimeInfo setIssuerCn(java.lang.String issuerCn) {
    this.issuerCn = issuerCn;
    return this;
  }

  /**
   * PEM formatted X509 concatenated certificate string (standard base64 encoding). Format used for
   * returning key, which includes public key as well as certificate chain (not private key).
   * @return value or {@code null} for none
   */
  public java.lang.String getPem() {
    return pem;
  }

  /**
   * PEM formatted X509 concatenated certificate string (standard base64 encoding). Format used for
   * returning key, which includes public key as well as certificate chain (not private key).
   * @param pem pem or {@code null} for none
   */
  public SmimeInfo setPem(java.lang.String pem) {
    this.pem = pem;
    return this;
  }

  /**
   * PKCS#12 format containing a single private/public key pair and certificate chain. This format
   * is only accepted from client for creating a new SmimeInfo and is never returned, because the
   * private key is not intended to be exported. PKCS#12 may be encrypted, in which case
   * encryptedKeyPassword should be set appropriately.
   * @see #decodePkcs12()
   * @return value or {@code null} for none
   */
  public java.lang.String getPkcs12() {
    return pkcs12;
  }

  /**
   * PKCS#12 format containing a single private/public key pair and certificate chain. This format
   * is only accepted from client for creating a new SmimeInfo and is never returned, because the
   * private key is not intended to be exported. PKCS#12 may be encrypted, in which case
   * encryptedKeyPassword should be set appropriately.
   * @see #getPkcs12()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodePkcs12() {
    return com.google.api.client.util.Base64.decodeBase64(pkcs12);
  }

  /**
   * PKCS#12 format containing a single private/public key pair and certificate chain. This format
   * is only accepted from client for creating a new SmimeInfo and is never returned, because the
   * private key is not intended to be exported. PKCS#12 may be encrypted, in which case
   * encryptedKeyPassword should be set appropriately.
   * @see #encodePkcs12()
   * @param pkcs12 pkcs12 or {@code null} for none
   */
  public SmimeInfo setPkcs12(java.lang.String pkcs12) {
    this.pkcs12 = pkcs12;
    return this;
  }

  /**
   * PKCS#12 format containing a single private/public key pair and certificate chain. This format
   * is only accepted from client for creating a new SmimeInfo and is never returned, because the
   * private key is not intended to be exported. PKCS#12 may be encrypted, in which case
   * encryptedKeyPassword should be set appropriately.
   * @see #setPkcs12()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public SmimeInfo encodePkcs12(byte[] pkcs12) {
    this.pkcs12 = com.google.api.client.util.Base64.encodeBase64URLSafeString(pkcs12);
    return this;
  }

  @Override
  public SmimeInfo set(String fieldName, Object value) {
    return (SmimeInfo) super.set(fieldName, value);
  }

  @Override
  public SmimeInfo clone() {
    return (SmimeInfo) super.clone();
  }

}
