/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-03-23 at 03:23:23 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * Settings for a forwarding address.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ForwardingAddress extends com.google.api.client.json.GenericJson {

  /**
   * An email address to which messages can be forwarded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String forwardingEmail;

  /**
   * Indicates whether this address has been verified and is usable for forwarding. Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String verificationStatus;

  /**
   * An email address to which messages can be forwarded.
   * @return value or {@code null} for none
   */
  public java.lang.String getForwardingEmail() {
    return forwardingEmail;
  }

  /**
   * An email address to which messages can be forwarded.
   * @param forwardingEmail forwardingEmail or {@code null} for none
   */
  public ForwardingAddress setForwardingEmail(java.lang.String forwardingEmail) {
    this.forwardingEmail = forwardingEmail;
    return this;
  }

  /**
   * Indicates whether this address has been verified and is usable for forwarding. Read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getVerificationStatus() {
    return verificationStatus;
  }

  /**
   * Indicates whether this address has been verified and is usable for forwarding. Read-only.
   * @param verificationStatus verificationStatus or {@code null} for none
   */
  public ForwardingAddress setVerificationStatus(java.lang.String verificationStatus) {
    this.verificationStatus = verificationStatus;
    return this;
  }

  @Override
  public ForwardingAddress set(String fieldName, Object value) {
    return (ForwardingAddress) super.set(fieldName, value);
  }

  @Override
  public ForwardingAddress clone() {
    return (ForwardingAddress) super.clone();
  }

}
