/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2013-08-26 17:13:51 UTC)
 * on 2013-09-09 at 19:13:30 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics;

/**
 * Service definition for Analytics (v3).
 *
 * <p>
 * View and manage your Google Analytics data
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/analytics/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link AnalyticsRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Analytics extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 14,
        "You are currently running with version %s of google-api-client. " +
        "You need version 1.14 of google-api-client to run version " +
        "1.14.2-beta of the Google Analytics API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "analytics/v3/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Analytics(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Analytics(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Data collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Analytics analytics = new Analytics(...);}
   *   {@code Analytics.Data.List request = analytics.data().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Data data() {
    return new Data();
  }

  /**
   * The "data" collection of methods.
   */
  public class Data {

    /**
     * An accessor for creating requests from the Ga collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Ga.List request = analytics.ga().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Ga ga() {
      return new Ga();
    }

    /**
     * The "ga" collection of methods.
     */
    public class Ga {

      /**
       * Returns Analytics data for a view (profile).
       *
       * Create a request for the method "ga.get".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param ids Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the
       *        Analytics view (profile) ID.
       * @param startDate Start date for fetching Analytics data. All requests should specify a start date formatted as YYYY-
       *        MM-DD.
       * @param endDate End date for fetching Analytics data. All requests should specify an end date formatted as YYYY-MM-
       *        DD.
       * @param metrics A comma-separated list of Analytics metrics. E.g., 'ga:visits,ga:pageviews'. At least one metric
       *        must be specified.
       * @return the request
       */
      public Get get(java.lang.String ids, java.lang.String startDate, java.lang.String endDate, java.lang.String metrics) throws java.io.IOException {
        Get result = new Get(ids, startDate, endDate, metrics);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.GaData> {

        private static final String REST_PATH = "data/ga";

        private final java.util.regex.Pattern IDS_PATTERN =
            java.util.regex.Pattern.compile("ga:[0-9]+");

        private final java.util.regex.Pattern STARTDATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

        private final java.util.regex.Pattern ENDDATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

        private final java.util.regex.Pattern METRICS_PATTERN =
            java.util.regex.Pattern.compile("ga:.+");

        private final java.util.regex.Pattern SORT_PATTERN =
            java.util.regex.Pattern.compile("(-)?ga:.+");

        private final java.util.regex.Pattern DIMENSIONS_PATTERN =
            java.util.regex.Pattern.compile("(ga:.+)?");

        private final java.util.regex.Pattern FILTERS_PATTERN =
            java.util.regex.Pattern.compile("ga:.+");

        /**
         * Returns Analytics data for a view (profile).
         *
         * Create a request for the method "ga.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param ids Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the
       *        Analytics view (profile) ID.
         * @param startDate Start date for fetching Analytics data. All requests should specify a start date formatted as YYYY-
       *        MM-DD.
         * @param endDate End date for fetching Analytics data. All requests should specify an end date formatted as YYYY-MM-
       *        DD.
         * @param metrics A comma-separated list of Analytics metrics. E.g., 'ga:visits,ga:pageviews'. At least one metric
       *        must be specified.
         * @since 1.13
         */
        protected Get(java.lang.String ids, java.lang.String startDate, java.lang.String endDate, java.lang.String metrics) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.GaData.class);
          this.ids = com.google.api.client.util.Preconditions.checkNotNull(ids, "Required parameter ids must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
                "Parameter ids must conform to the pattern " +
                "ga:[0-9]+");
          }
          this.startDate = com.google.api.client.util.Preconditions.checkNotNull(startDate, "Required parameter startDate must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(STARTDATE_PATTERN.matcher(startDate).matches(),
                "Parameter startDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.endDate = com.google.api.client.util.Preconditions.checkNotNull(endDate, "Required parameter endDate must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ENDDATE_PATTERN.matcher(endDate).matches(),
                "Parameter endDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.metrics = com.google.api.client.util.Preconditions.checkNotNull(metrics, "Required parameter metrics must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
                "Parameter metrics must conform to the pattern " +
                "ga:.+");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /**
         * Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where
         * XXXX is the Analytics view (profile) ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String ids;

        /** Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the
       Analytics view (profile) ID.
         */
        public java.lang.String getIds() {
          return ids;
        }

        /**
         * Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where
         * XXXX is the Analytics view (profile) ID.
         */
        public Get setIds(java.lang.String ids) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
                "Parameter ids must conform to the pattern " +
                "ga:[0-9]+");
          }
          this.ids = ids;
          return this;
        }

        /**
         * Start date for fetching Analytics data. All requests should specify a start date
         * formatted as YYYY-MM-DD.
         */
        @com.google.api.client.util.Key("start-date")
        private java.lang.String startDate;

        /** Start date for fetching Analytics data. All requests should specify a start date formatted as YYYY-
       MM-DD.
         */
        public java.lang.String getStartDate() {
          return startDate;
        }

        /**
         * Start date for fetching Analytics data. All requests should specify a start date
         * formatted as YYYY-MM-DD.
         */
        public Get setStartDate(java.lang.String startDate) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(STARTDATE_PATTERN.matcher(startDate).matches(),
                "Parameter startDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.startDate = startDate;
          return this;
        }

        /**
         * End date for fetching Analytics data. All requests should specify an end date formatted
         * as YYYY-MM-DD.
         */
        @com.google.api.client.util.Key("end-date")
        private java.lang.String endDate;

        /** End date for fetching Analytics data. All requests should specify an end date formatted as YYYY-MM-
       DD.
         */
        public java.lang.String getEndDate() {
          return endDate;
        }

        /**
         * End date for fetching Analytics data. All requests should specify an end date formatted
         * as YYYY-MM-DD.
         */
        public Get setEndDate(java.lang.String endDate) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ENDDATE_PATTERN.matcher(endDate).matches(),
                "Parameter endDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.endDate = endDate;
          return this;
        }

        /**
         * A comma-separated list of Analytics metrics. E.g., 'ga:visits,ga:pageviews'. At least one
         * metric must be specified.
         */
        @com.google.api.client.util.Key
        private java.lang.String metrics;

        /** A comma-separated list of Analytics metrics. E.g., 'ga:visits,ga:pageviews'. At least one metric
       must be specified.
         */
        public java.lang.String getMetrics() {
          return metrics;
        }

        /**
         * A comma-separated list of Analytics metrics. E.g., 'ga:visits,ga:pageviews'. At least one
         * metric must be specified.
         */
        public Get setMetrics(java.lang.String metrics) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
                "Parameter metrics must conform to the pattern " +
                "ga:.+");
          }
          this.metrics = metrics;
          return this;
        }

        /** The maximum number of entries to include in this feed. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of entries to include in this feed.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of entries to include in this feed. */
        public Get setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * A comma-separated list of dimensions or metrics that determine the sort order for
         * Analytics data.
         */
        @com.google.api.client.util.Key
        private java.lang.String sort;

        /** A comma-separated list of dimensions or metrics that determine the sort order for Analytics data.
         */
        public java.lang.String getSort() {
          return sort;
        }

        /**
         * A comma-separated list of dimensions or metrics that determine the sort order for
         * Analytics data.
         */
        public Get setSort(java.lang.String sort) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SORT_PATTERN.matcher(sort).matches(),
                "Parameter sort must conform to the pattern " +
                "(-)?ga:.+");
          }
          this.sort = sort;
          return this;
        }

        /** A comma-separated list of Analytics dimensions. E.g., 'ga:browser,ga:city'. */
        @com.google.api.client.util.Key
        private java.lang.String dimensions;

        /** A comma-separated list of Analytics dimensions. E.g., 'ga:browser,ga:city'.
         */
        public java.lang.String getDimensions() {
          return dimensions;
        }

        /** A comma-separated list of Analytics dimensions. E.g., 'ga:browser,ga:city'. */
        public Get setDimensions(java.lang.String dimensions) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(DIMENSIONS_PATTERN.matcher(dimensions).matches(),
                "Parameter dimensions must conform to the pattern " +
                "(ga:.+)?");
          }
          this.dimensions = dimensions;
          return this;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        public Get setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        /** An Analytics advanced segment to be applied to data. */
        @com.google.api.client.util.Key
        private java.lang.String segment;

        /** An Analytics advanced segment to be applied to data.
         */
        public java.lang.String getSegment() {
          return segment;
        }

        /** An Analytics advanced segment to be applied to data. */
        public Get setSegment(java.lang.String segment) {
          this.segment = segment;
          return this;
        }

        /**
         * A comma-separated list of dimension or metric filters to be applied to Analytics data.
         */
        @com.google.api.client.util.Key
        private java.lang.String filters;

        /** A comma-separated list of dimension or metric filters to be applied to Analytics data.
         */
        public java.lang.String getFilters() {
          return filters;
        }

        /**
         * A comma-separated list of dimension or metric filters to be applied to Analytics data.
         */
        public Get setFilters(java.lang.String filters) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(FILTERS_PATTERN.matcher(filters).matches(),
                "Parameter filters must conform to the pattern " +
                "ga:.+");
          }
          this.filters = filters;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Mcf collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Mcf.List request = analytics.mcf().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Mcf mcf() {
      return new Mcf();
    }

    /**
     * The "mcf" collection of methods.
     */
    public class Mcf {

      /**
       * Returns Analytics Multi-Channel Funnels data for a view (profile).
       *
       * Create a request for the method "mcf.get".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param ids Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the
       *        Analytics view (profile) ID.
       * @param startDate Start date for fetching Analytics data. All requests should specify a start date formatted as YYYY-
       *        MM-DD.
       * @param endDate End date for fetching Analytics data. All requests should specify an end date formatted as YYYY-MM-
       *        DD.
       * @param metrics A comma-separated list of Multi-Channel Funnels metrics. E.g.,
       *        'mcf:totalConversions,mcf:totalConversionValue'. At least one metric must be specified.
       * @return the request
       */
      public Get get(java.lang.String ids, java.lang.String startDate, java.lang.String endDate, java.lang.String metrics) throws java.io.IOException {
        Get result = new Get(ids, startDate, endDate, metrics);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.McfData> {

        private static final String REST_PATH = "data/mcf";

        private final java.util.regex.Pattern IDS_PATTERN =
            java.util.regex.Pattern.compile("ga:[0-9]+");

        private final java.util.regex.Pattern STARTDATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

        private final java.util.regex.Pattern ENDDATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

        private final java.util.regex.Pattern METRICS_PATTERN =
            java.util.regex.Pattern.compile("mcf:.+");

        private final java.util.regex.Pattern SORT_PATTERN =
            java.util.regex.Pattern.compile("(-)?mcf:.+");

        private final java.util.regex.Pattern DIMENSIONS_PATTERN =
            java.util.regex.Pattern.compile("(mcf:.+)?");

        private final java.util.regex.Pattern FILTERS_PATTERN =
            java.util.regex.Pattern.compile("mcf:.+");

        /**
         * Returns Analytics Multi-Channel Funnels data for a view (profile).
         *
         * Create a request for the method "mcf.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param ids Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the
       *        Analytics view (profile) ID.
         * @param startDate Start date for fetching Analytics data. All requests should specify a start date formatted as YYYY-
       *        MM-DD.
         * @param endDate End date for fetching Analytics data. All requests should specify an end date formatted as YYYY-MM-
       *        DD.
         * @param metrics A comma-separated list of Multi-Channel Funnels metrics. E.g.,
       *        'mcf:totalConversions,mcf:totalConversionValue'. At least one metric must be specified.
         * @since 1.13
         */
        protected Get(java.lang.String ids, java.lang.String startDate, java.lang.String endDate, java.lang.String metrics) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.McfData.class);
          this.ids = com.google.api.client.util.Preconditions.checkNotNull(ids, "Required parameter ids must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
                "Parameter ids must conform to the pattern " +
                "ga:[0-9]+");
          }
          this.startDate = com.google.api.client.util.Preconditions.checkNotNull(startDate, "Required parameter startDate must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(STARTDATE_PATTERN.matcher(startDate).matches(),
                "Parameter startDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.endDate = com.google.api.client.util.Preconditions.checkNotNull(endDate, "Required parameter endDate must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ENDDATE_PATTERN.matcher(endDate).matches(),
                "Parameter endDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.metrics = com.google.api.client.util.Preconditions.checkNotNull(metrics, "Required parameter metrics must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
                "Parameter metrics must conform to the pattern " +
                "mcf:.+");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /**
         * Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where
         * XXXX is the Analytics view (profile) ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String ids;

        /** Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the
       Analytics view (profile) ID.
         */
        public java.lang.String getIds() {
          return ids;
        }

        /**
         * Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where
         * XXXX is the Analytics view (profile) ID.
         */
        public Get setIds(java.lang.String ids) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
                "Parameter ids must conform to the pattern " +
                "ga:[0-9]+");
          }
          this.ids = ids;
          return this;
        }

        /**
         * Start date for fetching Analytics data. All requests should specify a start date
         * formatted as YYYY-MM-DD.
         */
        @com.google.api.client.util.Key("start-date")
        private java.lang.String startDate;

        /** Start date for fetching Analytics data. All requests should specify a start date formatted as YYYY-
       MM-DD.
         */
        public java.lang.String getStartDate() {
          return startDate;
        }

        /**
         * Start date for fetching Analytics data. All requests should specify a start date
         * formatted as YYYY-MM-DD.
         */
        public Get setStartDate(java.lang.String startDate) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(STARTDATE_PATTERN.matcher(startDate).matches(),
                "Parameter startDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.startDate = startDate;
          return this;
        }

        /**
         * End date for fetching Analytics data. All requests should specify an end date formatted
         * as YYYY-MM-DD.
         */
        @com.google.api.client.util.Key("end-date")
        private java.lang.String endDate;

        /** End date for fetching Analytics data. All requests should specify an end date formatted as YYYY-MM-
       DD.
         */
        public java.lang.String getEndDate() {
          return endDate;
        }

        /**
         * End date for fetching Analytics data. All requests should specify an end date formatted
         * as YYYY-MM-DD.
         */
        public Get setEndDate(java.lang.String endDate) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ENDDATE_PATTERN.matcher(endDate).matches(),
                "Parameter endDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.endDate = endDate;
          return this;
        }

        /**
         * A comma-separated list of Multi-Channel Funnels metrics. E.g.,
         * 'mcf:totalConversions,mcf:totalConversionValue'. At least one metric must be specified.
         */
        @com.google.api.client.util.Key
        private java.lang.String metrics;

        /** A comma-separated list of Multi-Channel Funnels metrics. E.g.,
       'mcf:totalConversions,mcf:totalConversionValue'. At least one metric must be specified.
         */
        public java.lang.String getMetrics() {
          return metrics;
        }

        /**
         * A comma-separated list of Multi-Channel Funnels metrics. E.g.,
         * 'mcf:totalConversions,mcf:totalConversionValue'. At least one metric must be specified.
         */
        public Get setMetrics(java.lang.String metrics) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
                "Parameter metrics must conform to the pattern " +
                "mcf:.+");
          }
          this.metrics = metrics;
          return this;
        }

        /** The maximum number of entries to include in this feed. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of entries to include in this feed.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of entries to include in this feed. */
        public Get setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * A comma-separated list of dimensions or metrics that determine the sort order for the
         * Analytics data.
         */
        @com.google.api.client.util.Key
        private java.lang.String sort;

        /** A comma-separated list of dimensions or metrics that determine the sort order for the Analytics
       data.
         */
        public java.lang.String getSort() {
          return sort;
        }

        /**
         * A comma-separated list of dimensions or metrics that determine the sort order for the
         * Analytics data.
         */
        public Get setSort(java.lang.String sort) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SORT_PATTERN.matcher(sort).matches(),
                "Parameter sort must conform to the pattern " +
                "(-)?mcf:.+");
          }
          this.sort = sort;
          return this;
        }

        /**
         * A comma-separated list of Multi-Channel Funnels dimensions. E.g.,
         * 'mcf:source,mcf:medium'.
         */
        @com.google.api.client.util.Key
        private java.lang.String dimensions;

        /** A comma-separated list of Multi-Channel Funnels dimensions. E.g., 'mcf:source,mcf:medium'.
         */
        public java.lang.String getDimensions() {
          return dimensions;
        }

        /**
         * A comma-separated list of Multi-Channel Funnels dimensions. E.g.,
         * 'mcf:source,mcf:medium'.
         */
        public Get setDimensions(java.lang.String dimensions) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(DIMENSIONS_PATTERN.matcher(dimensions).matches(),
                "Parameter dimensions must conform to the pattern " +
                "(mcf:.+)?");
          }
          this.dimensions = dimensions;
          return this;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        public Get setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        /**
         * A comma-separated list of dimension or metric filters to be applied to the Analytics
         * data.
         */
        @com.google.api.client.util.Key
        private java.lang.String filters;

        /** A comma-separated list of dimension or metric filters to be applied to the Analytics data.
         */
        public java.lang.String getFilters() {
          return filters;
        }

        /**
         * A comma-separated list of dimension or metric filters to be applied to the Analytics
         * data.
         */
        public Get setFilters(java.lang.String filters) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(FILTERS_PATTERN.matcher(filters).matches(),
                "Parameter filters must conform to the pattern " +
                "mcf:.+");
          }
          this.filters = filters;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Realtime collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Realtime.List request = analytics.realtime().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Realtime realtime() {
      return new Realtime();
    }

    /**
     * The "realtime" collection of methods.
     */
    public class Realtime {

      /**
       * Returns real time data for a view (profile).
       *
       * Create a request for the method "realtime.get".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param ids Unique table ID for retrieving real time data. Table ID is of the form ga:XXXX, where XXXX is the
       *        Analytics view (profile) ID.
       * @param metrics A comma-separated list of real time metrics. E.g., 'ga:activeVisitors'. At least one metric must be
       *        specified.
       * @return the request
       */
      public Get get(java.lang.String ids, java.lang.String metrics) throws java.io.IOException {
        Get result = new Get(ids, metrics);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.RealtimeData> {

        private static final String REST_PATH = "data/realtime";

        private final java.util.regex.Pattern IDS_PATTERN =
            java.util.regex.Pattern.compile("ga:[0-9]+");

        private final java.util.regex.Pattern METRICS_PATTERN =
            java.util.regex.Pattern.compile("ga:.+");

        private final java.util.regex.Pattern SORT_PATTERN =
            java.util.regex.Pattern.compile("(-)?ga:.+");

        private final java.util.regex.Pattern DIMENSIONS_PATTERN =
            java.util.regex.Pattern.compile("(ga:.+)?");

        private final java.util.regex.Pattern FILTERS_PATTERN =
            java.util.regex.Pattern.compile("ga:.+");

        /**
         * Returns real time data for a view (profile).
         *
         * Create a request for the method "realtime.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param ids Unique table ID for retrieving real time data. Table ID is of the form ga:XXXX, where XXXX is the
       *        Analytics view (profile) ID.
         * @param metrics A comma-separated list of real time metrics. E.g., 'ga:activeVisitors'. At least one metric must be
       *        specified.
         * @since 1.13
         */
        protected Get(java.lang.String ids, java.lang.String metrics) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.RealtimeData.class);
          this.ids = com.google.api.client.util.Preconditions.checkNotNull(ids, "Required parameter ids must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
                "Parameter ids must conform to the pattern " +
                "ga:[0-9]+");
          }
          this.metrics = com.google.api.client.util.Preconditions.checkNotNull(metrics, "Required parameter metrics must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
                "Parameter metrics must conform to the pattern " +
                "ga:.+");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /**
         * Unique table ID for retrieving real time data. Table ID is of the form ga:XXXX, where
         * XXXX is the Analytics view (profile) ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String ids;

        /** Unique table ID for retrieving real time data. Table ID is of the form ga:XXXX, where XXXX is the
       Analytics view (profile) ID.
         */
        public java.lang.String getIds() {
          return ids;
        }

        /**
         * Unique table ID for retrieving real time data. Table ID is of the form ga:XXXX, where
         * XXXX is the Analytics view (profile) ID.
         */
        public Get setIds(java.lang.String ids) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
                "Parameter ids must conform to the pattern " +
                "ga:[0-9]+");
          }
          this.ids = ids;
          return this;
        }

        /**
         * A comma-separated list of real time metrics. E.g., 'ga:activeVisitors'. At least one
         * metric must be specified.
         */
        @com.google.api.client.util.Key
        private java.lang.String metrics;

        /** A comma-separated list of real time metrics. E.g., 'ga:activeVisitors'. At least one metric must be
       specified.
         */
        public java.lang.String getMetrics() {
          return metrics;
        }

        /**
         * A comma-separated list of real time metrics. E.g., 'ga:activeVisitors'. At least one
         * metric must be specified.
         */
        public Get setMetrics(java.lang.String metrics) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
                "Parameter metrics must conform to the pattern " +
                "ga:.+");
          }
          this.metrics = metrics;
          return this;
        }

        /** The maximum number of entries to include in this feed. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of entries to include in this feed.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of entries to include in this feed. */
        public Get setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * A comma-separated list of dimensions or metrics that determine the sort order for real
         * time data.
         */
        @com.google.api.client.util.Key
        private java.lang.String sort;

        /** A comma-separated list of dimensions or metrics that determine the sort order for real time data.
         */
        public java.lang.String getSort() {
          return sort;
        }

        /**
         * A comma-separated list of dimensions or metrics that determine the sort order for real
         * time data.
         */
        public Get setSort(java.lang.String sort) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SORT_PATTERN.matcher(sort).matches(),
                "Parameter sort must conform to the pattern " +
                "(-)?ga:.+");
          }
          this.sort = sort;
          return this;
        }

        /** A comma-separated list of real time dimensions. E.g., 'ga:medium,ga:city'. */
        @com.google.api.client.util.Key
        private java.lang.String dimensions;

        /** A comma-separated list of real time dimensions. E.g., 'ga:medium,ga:city'.
         */
        public java.lang.String getDimensions() {
          return dimensions;
        }

        /** A comma-separated list of real time dimensions. E.g., 'ga:medium,ga:city'. */
        public Get setDimensions(java.lang.String dimensions) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(DIMENSIONS_PATTERN.matcher(dimensions).matches(),
                "Parameter dimensions must conform to the pattern " +
                "(ga:.+)?");
          }
          this.dimensions = dimensions;
          return this;
        }

        /**
         * A comma-separated list of dimension or metric filters to be applied to real time data.
         */
        @com.google.api.client.util.Key
        private java.lang.String filters;

        /** A comma-separated list of dimension or metric filters to be applied to real time data.
         */
        public java.lang.String getFilters() {
          return filters;
        }

        /**
         * A comma-separated list of dimension or metric filters to be applied to real time data.
         */
        public Get setFilters(java.lang.String filters) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(FILTERS_PATTERN.matcher(filters).matches(),
                "Parameter filters must conform to the pattern " +
                "ga:.+");
          }
          this.filters = filters;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * An accessor for creating requests from the Management collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Analytics analytics = new Analytics(...);}
   *   {@code Analytics.Management.List request = analytics.management().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Management management() {
    return new Management();
  }

  /**
   * The "management" collection of methods.
   */
  public class Management {

    /**
     * An accessor for creating requests from the Accounts collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Accounts.List request = analytics.accounts().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Accounts accounts() {
      return new Accounts();
    }

    /**
     * The "accounts" collection of methods.
     */
    public class Accounts {

      /**
       * Lists all accounts to which the user has access.
       *
       * Create a request for the method "accounts.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @return the request
       */
      public List list() throws java.io.IOException {
        List result = new List();
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Accounts> {

        private static final String REST_PATH = "management/accounts";

        /**
         * Lists all accounts to which the user has access.
         *
         * Create a request for the method "accounts.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @since 1.13
         */
        protected List() {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Accounts.class);
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** The maximum number of accounts to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of accounts to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of accounts to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first account to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first account to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first account to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the CustomDataSources collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.CustomDataSources.List request = analytics.customDataSources().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public CustomDataSources customDataSources() {
      return new CustomDataSources();
    }

    /**
     * The "customDataSources" collection of methods.
     */
    public class CustomDataSources {

      /**
       * List custom data sources to which the user has access.
       *
       * Create a request for the method "customDataSources.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account Id for the custom data sources to retrieve.
       * @param webPropertyId Web property Id for the custom data sources to retrieve.
       * @return the request
       */
      public List list(java.lang.String accountId, java.lang.String webPropertyId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.CustomDataSources> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources";

        private final java.util.regex.Pattern ACCOUNTID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEBPROPERTYID_PATTERN =
            java.util.regex.Pattern.compile("UA-(\\d+)-(\\d+)");

        /**
         * List custom data sources to which the user has access.
         *
         * Create a request for the method "customDataSources.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account Id for the custom data sources to retrieve.
         * @param webPropertyId Web property Id for the custom data sources to retrieve.
         * @since 1.13
         */
        protected List(java.lang.String accountId, java.lang.String webPropertyId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.CustomDataSources.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Account Id for the custom data sources to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account Id for the custom data sources to retrieve.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account Id for the custom data sources to retrieve. */
        public List setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property Id for the custom data sources to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property Id for the custom data sources to retrieve.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property Id for the custom data sources to retrieve. */
        public List setWebPropertyId(java.lang.String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** The maximum number of custom data sources to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of custom data sources to include in this response.

       [minimum: 1]
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of custom data sources to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * A 1-based index of the first custom data source to retrieve. Use this parameter as a
         * pagination mechanism along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** A 1-based index of the first custom data source to retrieve. Use this parameter as a pagination
       mechanism along with the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * A 1-based index of the first custom data source to retrieve. Use this parameter as a
         * pagination mechanism along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the DailyUploads collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.DailyUploads.List request = analytics.dailyUploads().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public DailyUploads dailyUploads() {
      return new DailyUploads();
    }

    /**
     * The "dailyUploads" collection of methods.
     */
    public class DailyUploads {

      /**
       * Delete uploaded data for the given date.
       *
       * Create a request for the method "dailyUploads.delete".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param accountId Account Id associated with daily upload delete.
       * @param webPropertyId Web property Id associated with daily upload delete.
       * @param customDataSourceId Custom data source Id associated with daily upload delete.
       * @param date Date for which data is to be deleted. Date should be formatted as YYYY-MM-DD.
       * @param type Type of data for this delete.
       * @return the request
       */
      public Delete delete(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDataSourceId, java.lang.String date, java.lang.String type) throws java.io.IOException {
        Delete result = new Delete(accountId, webPropertyId, customDataSourceId, date, type);
        initialize(result);
        return result;
      }

      public class Delete extends AnalyticsRequest<Void> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/dailyUploads/{date}";

        private final java.util.regex.Pattern ACCOUNTID_PATTERN =
            java.util.regex.Pattern.compile("[0-9]+");

        private final java.util.regex.Pattern WEBPROPERTYID_PATTERN =
            java.util.regex.Pattern.compile("UA-[0-9]+-[0-9]+");

        private final java.util.regex.Pattern DATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

        /**
         * Delete uploaded data for the given date.
         *
         * Create a request for the method "dailyUploads.delete".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account Id associated with daily upload delete.
         * @param webPropertyId Web property Id associated with daily upload delete.
         * @param customDataSourceId Custom data source Id associated with daily upload delete.
         * @param date Date for which data is to be deleted. Date should be formatted as YYYY-MM-DD.
         * @param type Type of data for this delete.
         * @since 1.13
         */
        protected Delete(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDataSourceId, java.lang.String date, java.lang.String type) {
          super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "[0-9]+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-[0-9]+-[0-9]+");
          }
          this.customDataSourceId = com.google.api.client.util.Preconditions.checkNotNull(customDataSourceId, "Required parameter customDataSourceId must be specified.");
          this.date = com.google.api.client.util.Preconditions.checkNotNull(date, "Required parameter date must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(DATE_PATTERN.matcher(date).matches(),
                "Parameter date must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.type = com.google.api.client.util.Preconditions.checkNotNull(type, "Required parameter type must be specified.");
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUserIp(java.lang.String userIp) {
          return (Delete) super.setUserIp(userIp);
        }

        /** Account Id associated with daily upload delete. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account Id associated with daily upload delete.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account Id associated with daily upload delete. */
        public Delete setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "[0-9]+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property Id associated with daily upload delete. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property Id associated with daily upload delete.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property Id associated with daily upload delete. */
        public Delete setWebPropertyId(java.lang.String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-[0-9]+-[0-9]+");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Custom data source Id associated with daily upload delete. */
        @com.google.api.client.util.Key
        private java.lang.String customDataSourceId;

        /** Custom data source Id associated with daily upload delete.
         */
        public java.lang.String getCustomDataSourceId() {
          return customDataSourceId;
        }

        /** Custom data source Id associated with daily upload delete. */
        public Delete setCustomDataSourceId(java.lang.String customDataSourceId) {
          this.customDataSourceId = customDataSourceId;
          return this;
        }

        /** Date for which data is to be deleted. Date should be formatted as YYYY-MM-DD. */
        @com.google.api.client.util.Key
        private java.lang.String date;

        /** Date for which data is to be deleted. Date should be formatted as YYYY-MM-DD.
         */
        public java.lang.String getDate() {
          return date;
        }

        /** Date for which data is to be deleted. Date should be formatted as YYYY-MM-DD. */
        public Delete setDate(java.lang.String date) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(DATE_PATTERN.matcher(date).matches(),
                "Parameter date must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.date = date;
          return this;
        }

        /** Type of data for this delete. */
        @com.google.api.client.util.Key
        private java.lang.String type;

        /** Type of data for this delete.
         */
        public java.lang.String getType() {
          return type;
        }

        /** Type of data for this delete. */
        public Delete setType(java.lang.String type) {
          this.type = type;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * List daily uploads to which the user has access.
       *
       * Create a request for the method "dailyUploads.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account Id for the daily uploads to retrieve.
       * @param webPropertyId Web property Id for the daily uploads to retrieve.
       * @param customDataSourceId Custom data source Id for daily uploads to retrieve.
       * @param startDate Start date of the form YYYY-MM-DD.
       * @param endDate End date of the form YYYY-MM-DD.
       * @return the request
       */
      public List list(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDataSourceId, java.lang.String startDate, java.lang.String endDate) throws java.io.IOException {
        List result = new List(accountId, webPropertyId, customDataSourceId, startDate, endDate);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.DailyUploads> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/dailyUploads";

        private final java.util.regex.Pattern ACCOUNTID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEBPROPERTYID_PATTERN =
            java.util.regex.Pattern.compile("UA-(\\d+)-(\\d+)");

        private final java.util.regex.Pattern CUSTOMDATASOURCEID_PATTERN =
            java.util.regex.Pattern.compile(".{22}");

        private final java.util.regex.Pattern STARTDATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

        private final java.util.regex.Pattern ENDDATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

        /**
         * List daily uploads to which the user has access.
         *
         * Create a request for the method "dailyUploads.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account Id for the daily uploads to retrieve.
         * @param webPropertyId Web property Id for the daily uploads to retrieve.
         * @param customDataSourceId Custom data source Id for daily uploads to retrieve.
         * @param startDate Start date of the form YYYY-MM-DD.
         * @param endDate End date of the form YYYY-MM-DD.
         * @since 1.13
         */
        protected List(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDataSourceId, java.lang.String startDate, java.lang.String endDate) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.DailyUploads.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.customDataSourceId = com.google.api.client.util.Preconditions.checkNotNull(customDataSourceId, "Required parameter customDataSourceId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(CUSTOMDATASOURCEID_PATTERN.matcher(customDataSourceId).matches(),
                "Parameter customDataSourceId must conform to the pattern " +
                ".{22}");
          }
          this.startDate = com.google.api.client.util.Preconditions.checkNotNull(startDate, "Required parameter startDate must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(STARTDATE_PATTERN.matcher(startDate).matches(),
                "Parameter startDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.endDate = com.google.api.client.util.Preconditions.checkNotNull(endDate, "Required parameter endDate must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ENDDATE_PATTERN.matcher(endDate).matches(),
                "Parameter endDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Account Id for the daily uploads to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account Id for the daily uploads to retrieve.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account Id for the daily uploads to retrieve. */
        public List setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property Id for the daily uploads to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property Id for the daily uploads to retrieve.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property Id for the daily uploads to retrieve. */
        public List setWebPropertyId(java.lang.String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Custom data source Id for daily uploads to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String customDataSourceId;

        /** Custom data source Id for daily uploads to retrieve.
         */
        public java.lang.String getCustomDataSourceId() {
          return customDataSourceId;
        }

        /** Custom data source Id for daily uploads to retrieve. */
        public List setCustomDataSourceId(java.lang.String customDataSourceId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(CUSTOMDATASOURCEID_PATTERN.matcher(customDataSourceId).matches(),
                "Parameter customDataSourceId must conform to the pattern " +
                ".{22}");
          }
          this.customDataSourceId = customDataSourceId;
          return this;
        }

        /** Start date of the form YYYY-MM-DD. */
        @com.google.api.client.util.Key("start-date")
        private java.lang.String startDate;

        /** Start date of the form YYYY-MM-DD.
         */
        public java.lang.String getStartDate() {
          return startDate;
        }

        /** Start date of the form YYYY-MM-DD. */
        public List setStartDate(java.lang.String startDate) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(STARTDATE_PATTERN.matcher(startDate).matches(),
                "Parameter startDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.startDate = startDate;
          return this;
        }

        /** End date of the form YYYY-MM-DD. */
        @com.google.api.client.util.Key("end-date")
        private java.lang.String endDate;

        /** End date of the form YYYY-MM-DD.
         */
        public java.lang.String getEndDate() {
          return endDate;
        }

        /** End date of the form YYYY-MM-DD. */
        public List setEndDate(java.lang.String endDate) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ENDDATE_PATTERN.matcher(endDate).matches(),
                "Parameter endDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.endDate = endDate;
          return this;
        }

        /** The maximum number of custom data sources to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of custom data sources to include in this response.

       [minimum: 1]
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of custom data sources to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * A 1-based index of the first daily upload to retrieve. Use this parameter as a pagination
         * mechanism along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** A 1-based index of the first daily upload to retrieve. Use this parameter as a pagination mechanism
       along with the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * A 1-based index of the first daily upload to retrieve. Use this parameter as a pagination
         * mechanism along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Update/Overwrite data for a custom data source.
       *
       * Create a request for the method "dailyUploads.upload".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Upload#execute()} method to invoke the remote operation.
       *
       * @param accountId Account Id associated with daily upload.
       * @param webPropertyId Web property Id associated with daily upload.
       * @param customDataSourceId Custom data source Id to which the data being uploaded belongs.
       * @param date Date for which data is uploaded. Date should be formatted as YYYY-MM-DD.
       * @param appendNumber Append number for this upload indexed from 1.
      [minimum: 1]
      [maximum: 20]
       * @param type Type of data for this upload.
       * @return the request
       */
      public Upload upload(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDataSourceId, java.lang.String date, java.lang.Integer appendNumber, java.lang.String type) throws java.io.IOException {
        Upload result = new Upload(accountId, webPropertyId, customDataSourceId, date, appendNumber, type);
        initialize(result);
        return result;
      }

      /**
       * Update/Overwrite data for a custom data source.
       *
       * Create a request for the method "dailyUploads.upload".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Upload#execute()} method to invoke the remote operation.
       *
       * <p>
       * This method should be used for uploading media content.
       * </p>
       *
       * @param accountId Account Id associated with daily upload.@param webPropertyId Web property Id associated with daily upload.@param customDataSourceId Custom data source Id to which the data being uploaded belongs.@param date Date for which data is uploaded. Date should be formatted as YYYY-MM-DD.@param appendNumber Append number for this upload indexed from 1.
      [minimum: 1]
      [maximum: 20]@param type Type of data for this upload.
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @return the request
       * @throws java.io.IOException if the initialization of the request fails
       */
      public Upload upload(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDataSourceId, java.lang.String date, java.lang.Integer appendNumber, java.lang.String type,
          com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
        Upload result = new Upload(accountId, webPropertyId, customDataSourceId, date, appendNumber, type, mediaContent);
        initialize(result);
        return result;
      }

      public class Upload extends AnalyticsRequest<com.google.api.services.analytics.model.DailyUploadAppend> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/dailyUploads/{date}/uploads";

        private final java.util.regex.Pattern ACCOUNTID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEBPROPERTYID_PATTERN =
            java.util.regex.Pattern.compile("UA-\\d+-\\d+");

        private final java.util.regex.Pattern DATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

        /**
         * Update/Overwrite data for a custom data source.
         *
         * Create a request for the method "dailyUploads.upload".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
         * <p> {@link
         * Upload#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account Id associated with daily upload.
         * @param webPropertyId Web property Id associated with daily upload.
         * @param customDataSourceId Custom data source Id to which the data being uploaded belongs.
         * @param date Date for which data is uploaded. Date should be formatted as YYYY-MM-DD.
         * @param appendNumber Append number for this upload indexed from 1.
      [minimum: 1]
      [maximum: 20]
         * @param type Type of data for this upload.
         * @since 1.13
         */
        protected Upload(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDataSourceId, java.lang.String date, java.lang.Integer appendNumber, java.lang.String type) {
          super(Analytics.this, "POST", REST_PATH, null, com.google.api.services.analytics.model.DailyUploadAppend.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-\\d+-\\d+");
          }
          this.customDataSourceId = com.google.api.client.util.Preconditions.checkNotNull(customDataSourceId, "Required parameter customDataSourceId must be specified.");
          this.date = com.google.api.client.util.Preconditions.checkNotNull(date, "Required parameter date must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(DATE_PATTERN.matcher(date).matches(),
                "Parameter date must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.appendNumber = com.google.api.client.util.Preconditions.checkNotNull(appendNumber, "Required parameter appendNumber must be specified.");
          this.type = com.google.api.client.util.Preconditions.checkNotNull(type, "Required parameter type must be specified.");
        }

        /**
         * Update/Overwrite data for a custom data source.
         *
         * Create a request for the method "dailyUploads.upload".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
         * <p> {@link
         * Upload#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * <p>
         * This constructor should be used for uploading media content.
         * </p>
         *
         * @param accountId Account Id associated with daily upload.@param webPropertyId Web property Id associated with daily upload.@param customDataSourceId Custom data source Id to which the data being uploaded belongs.@param date Date for which data is uploaded. Date should be formatted as YYYY-MM-DD.@param appendNumber Append number for this upload indexed from 1.
      [minimum: 1]
      [maximum: 20]@param type Type of data for this upload.
         * @param mediaContent The media HTTP content or {@code null} if none.
         * @since 1.13
         */
        protected Upload(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDataSourceId, java.lang.String date, java.lang.Integer appendNumber, java.lang.String type,
            com.google.api.client.http.AbstractInputStreamContent mediaContent) {
          super(Analytics.this, "POST", "/upload/" + getServicePath() + REST_PATH, null, com.google.api.services.analytics.model.DailyUploadAppend.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.customDataSourceId = com.google.api.client.util.Preconditions.checkNotNull(customDataSourceId, "Required parameter customDataSourceId must be specified.");
          this.date = com.google.api.client.util.Preconditions.checkNotNull(date, "Required parameter date must be specified.");
          this.appendNumber = com.google.api.client.util.Preconditions.checkNotNull(appendNumber, "Required parameter appendNumber must be specified.");
          this.type = com.google.api.client.util.Preconditions.checkNotNull(type, "Required parameter type must be specified.");
          initializeMediaUpload(mediaContent);
        }

        @Override
        public Upload setAlt(java.lang.String alt) {
          return (Upload) super.setAlt(alt);
        }

        @Override
        public Upload setFields(java.lang.String fields) {
          return (Upload) super.setFields(fields);
        }

        @Override
        public Upload setKey(java.lang.String key) {
          return (Upload) super.setKey(key);
        }

        @Override
        public Upload setOauthToken(java.lang.String oauthToken) {
          return (Upload) super.setOauthToken(oauthToken);
        }

        @Override
        public Upload setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Upload) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Upload setQuotaUser(java.lang.String quotaUser) {
          return (Upload) super.setQuotaUser(quotaUser);
        }

        @Override
        public Upload setUserIp(java.lang.String userIp) {
          return (Upload) super.setUserIp(userIp);
        }

        /** Account Id associated with daily upload. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account Id associated with daily upload.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account Id associated with daily upload. */
        public Upload setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property Id associated with daily upload. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property Id associated with daily upload.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property Id associated with daily upload. */
        public Upload setWebPropertyId(java.lang.String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-\\d+-\\d+");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Custom data source Id to which the data being uploaded belongs. */
        @com.google.api.client.util.Key
        private java.lang.String customDataSourceId;

        /** Custom data source Id to which the data being uploaded belongs.
         */
        public java.lang.String getCustomDataSourceId() {
          return customDataSourceId;
        }

        /** Custom data source Id to which the data being uploaded belongs. */
        public Upload setCustomDataSourceId(java.lang.String customDataSourceId) {
          this.customDataSourceId = customDataSourceId;
          return this;
        }

        /** Date for which data is uploaded. Date should be formatted as YYYY-MM-DD. */
        @com.google.api.client.util.Key
        private java.lang.String date;

        /** Date for which data is uploaded. Date should be formatted as YYYY-MM-DD.
         */
        public java.lang.String getDate() {
          return date;
        }

        /** Date for which data is uploaded. Date should be formatted as YYYY-MM-DD. */
        public Upload setDate(java.lang.String date) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(DATE_PATTERN.matcher(date).matches(),
                "Parameter date must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}");
          }
          this.date = date;
          return this;
        }

        /** Append number for this upload indexed from 1. */
        @com.google.api.client.util.Key
        private java.lang.Integer appendNumber;

        /** Append number for this upload indexed from 1.

       [minimum: 1] [maximum: 20]
         */
        public java.lang.Integer getAppendNumber() {
          return appendNumber;
        }

        /** Append number for this upload indexed from 1. */
        public Upload setAppendNumber(java.lang.Integer appendNumber) {
          this.appendNumber = appendNumber;
          return this;
        }

        /** Type of data for this upload. */
        @com.google.api.client.util.Key
        private java.lang.String type;

        /** Type of data for this upload.
         */
        public java.lang.String getType() {
          return type;
        }

        /** Type of data for this upload. */
        public Upload setType(java.lang.String type) {
          this.type = type;
          return this;
        }

        /**
         * Reset/Overwrite all previous appends for this date and start over with this file as the
         * first upload.
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean reset;

        /** Reset/Overwrite all previous appends for this date and start over with this file as the first
       upload. [default: false]
         */
        public java.lang.Boolean getReset() {
          return reset;
        }

        /**
         * Reset/Overwrite all previous appends for this date and start over with this file as the
         * first upload.
         */
        public Upload setReset(java.lang.Boolean reset) {
          this.reset = reset;
          return this;
        }

        /**
         * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
         *
         * <p>
         * Boolean properties can have four possible values:
         * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
         * or {@link Boolean#FALSE}.
         * </p>
         *
         * <p>
         * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
         * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
         * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * </p>
         *
         * <p>
         * Reset/Overwrite all previous appends for this date and start over with this file as the first
       upload.
         * </p>
         */
        public boolean isReset() {
          if (reset == null || reset == com.google.api.client.util.Data.NULL_BOOLEAN) {
            return false;
          }
          return reset;
        }

        @Override
        public Upload set(String parameterName, Object value) {
          return (Upload) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Experiments collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Experiments.List request = analytics.experiments().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Experiments experiments() {
      return new Experiments();
    }

    /**
     * The "experiments" collection of methods.
     */
    public class Experiments {

      /**
       * Delete an experiment.
       *
       * Create a request for the method "experiments.delete".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to which the experiment belongs
       * @param webPropertyId Web property ID to which the experiment belongs
       * @param profileId View (Profile) ID to which the experiment belongs
       * @param experimentId ID of the experiment to delete
       * @return the request
       */
      public Delete delete(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String experimentId) throws java.io.IOException {
        Delete result = new Delete(accountId, webPropertyId, profileId, experimentId);
        initialize(result);
        return result;
      }

      public class Delete extends AnalyticsRequest<Void> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";

        /**
         * Delete an experiment.
         *
         * Create a request for the method "experiments.delete".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to which the experiment belongs
         * @param webPropertyId Web property ID to which the experiment belongs
         * @param profileId View (Profile) ID to which the experiment belongs
         * @param experimentId ID of the experiment to delete
         * @since 1.13
         */
        protected Delete(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String experimentId) {
          super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          this.experimentId = com.google.api.client.util.Preconditions.checkNotNull(experimentId, "Required parameter experimentId must be specified.");
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUserIp(java.lang.String userIp) {
          return (Delete) super.setUserIp(userIp);
        }

        /** Account ID to which the experiment belongs */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to which the experiment belongs
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to which the experiment belongs */
        public Delete setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to which the experiment belongs */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to which the experiment belongs
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to which the experiment belongs */
        public Delete setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID to which the experiment belongs */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to which the experiment belongs
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID to which the experiment belongs */
        public Delete setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** ID of the experiment to delete */
        @com.google.api.client.util.Key
        private java.lang.String experimentId;

        /** ID of the experiment to delete
         */
        public java.lang.String getExperimentId() {
          return experimentId;
        }

        /** ID of the experiment to delete */
        public Delete setExperimentId(java.lang.String experimentId) {
          this.experimentId = experimentId;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Returns an experiment to which the user has access.
       *
       * Create a request for the method "experiments.get".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve the experiment for.
       * @param webPropertyId Web property ID to retrieve the experiment for.
       * @param profileId View (Profile) ID to retrieve the experiment for.
       * @param experimentId Experiment ID to retrieve the experiment for.
       * @return the request
       */
      public Get get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String experimentId) throws java.io.IOException {
        Get result = new Get(accountId, webPropertyId, profileId, experimentId);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.Experiment> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";

        /**
         * Returns an experiment to which the user has access.
         *
         * Create a request for the method "experiments.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve the experiment for.
         * @param webPropertyId Web property ID to retrieve the experiment for.
         * @param profileId View (Profile) ID to retrieve the experiment for.
         * @param experimentId Experiment ID to retrieve the experiment for.
         * @since 1.13
         */
        protected Get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String experimentId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Experiment.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          this.experimentId = com.google.api.client.util.Preconditions.checkNotNull(experimentId, "Required parameter experimentId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /** Account ID to retrieve the experiment for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to retrieve the experiment for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to retrieve the experiment for. */
        public Get setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to retrieve the experiment for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to retrieve the experiment for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to retrieve the experiment for. */
        public Get setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID to retrieve the experiment for. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to retrieve the experiment for.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID to retrieve the experiment for. */
        public Get setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** Experiment ID to retrieve the experiment for. */
        @com.google.api.client.util.Key
        private java.lang.String experimentId;

        /** Experiment ID to retrieve the experiment for.
         */
        public java.lang.String getExperimentId() {
          return experimentId;
        }

        /** Experiment ID to retrieve the experiment for. */
        public Get setExperimentId(java.lang.String experimentId) {
          this.experimentId = experimentId;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Create a new experiment.
       *
       * Create a request for the method "experiments.insert".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to create the experiment for.
       * @param webPropertyId Web property ID to create the experiment for.
       * @param profileId View (Profile) ID to create the experiment for.
       * @param content the {@link com.google.api.services.analytics.model.Experiment}
       * @return the request
       */
      public Insert insert(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, com.google.api.services.analytics.model.Experiment content) throws java.io.IOException {
        Insert result = new Insert(accountId, webPropertyId, profileId, content);
        initialize(result);
        return result;
      }

      public class Insert extends AnalyticsRequest<com.google.api.services.analytics.model.Experiment> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments";

        /**
         * Create a new experiment.
         *
         * Create a request for the method "experiments.insert".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
         * <p> {@link
         * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to create the experiment for.
         * @param webPropertyId Web property ID to create the experiment for.
         * @param profileId View (Profile) ID to create the experiment for.
         * @param content the {@link com.google.api.services.analytics.model.Experiment}
         * @since 1.13
         */
        protected Insert(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, com.google.api.services.analytics.model.Experiment content) {
          super(Analytics.this, "POST", REST_PATH, content, com.google.api.services.analytics.model.Experiment.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getName(), "Experiment.getName()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getStatus(), "Experiment.getStatus()");
        }

        @Override
        public Insert setAlt(java.lang.String alt) {
          return (Insert) super.setAlt(alt);
        }

        @Override
        public Insert setFields(java.lang.String fields) {
          return (Insert) super.setFields(fields);
        }

        @Override
        public Insert setKey(java.lang.String key) {
          return (Insert) super.setKey(key);
        }

        @Override
        public Insert setOauthToken(java.lang.String oauthToken) {
          return (Insert) super.setOauthToken(oauthToken);
        }

        @Override
        public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Insert) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Insert setQuotaUser(java.lang.String quotaUser) {
          return (Insert) super.setQuotaUser(quotaUser);
        }

        @Override
        public Insert setUserIp(java.lang.String userIp) {
          return (Insert) super.setUserIp(userIp);
        }

        /** Account ID to create the experiment for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to create the experiment for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to create the experiment for. */
        public Insert setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to create the experiment for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to create the experiment for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to create the experiment for. */
        public Insert setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID to create the experiment for. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to create the experiment for.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID to create the experiment for. */
        public Insert setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        @Override
        public Insert set(String parameterName, Object value) {
          return (Insert) super.set(parameterName, value);
        }
      }
      /**
       * Lists experiments to which the user has access.
       *
       * Create a request for the method "experiments.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve experiments for.
       * @param webPropertyId Web property ID to retrieve experiments for.
       * @param profileId View (Profile) ID to retrieve experiments for.
       * @return the request
       */
      public List list(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId, profileId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Experiments> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments";

        private final java.util.regex.Pattern ACCOUNTID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEBPROPERTYID_PATTERN =
            java.util.regex.Pattern.compile("UA-(\\d+)-(\\d+)");

        private final java.util.regex.Pattern PROFILEID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        /**
         * Lists experiments to which the user has access.
         *
         * Create a request for the method "experiments.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve experiments for.
         * @param webPropertyId Web property ID to retrieve experiments for.
         * @param profileId View (Profile) ID to retrieve experiments for.
         * @since 1.13
         */
        protected List(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Experiments.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROFILEID_PATTERN.matcher(profileId).matches(),
                "Parameter profileId must conform to the pattern " +
                "\\d+");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Account ID to retrieve experiments for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to retrieve experiments for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to retrieve experiments for. */
        public List setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNTID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to retrieve experiments for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to retrieve experiments for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to retrieve experiments for. */
        public List setWebPropertyId(java.lang.String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEBPROPERTYID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID to retrieve experiments for. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to retrieve experiments for.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID to retrieve experiments for. */
        public List setProfileId(java.lang.String profileId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROFILEID_PATTERN.matcher(profileId).matches(),
                "Parameter profileId must conform to the pattern " +
                "\\d+");
          }
          this.profileId = profileId;
          return this;
        }

        /** The maximum number of experiments to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of experiments to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of experiments to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first experiment to retrieve. Use this parameter as a pagination
         * mechanism along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first experiment to retrieve. Use this parameter as a pagination mechanism along
       with the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first experiment to retrieve. Use this parameter as a pagination
         * mechanism along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Update an existing experiment. This method supports patch semantics.
       *
       * Create a request for the method "experiments.patch".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID of the experiment to update.
       * @param webPropertyId Web property ID of the experiment to update.
       * @param profileId View (Profile) ID of the experiment to update.
       * @param experimentId Experiment ID of the experiment to update.
       * @param content the {@link com.google.api.services.analytics.model.Experiment}
       * @return the request
       */
      public Patch patch(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String experimentId, com.google.api.services.analytics.model.Experiment content) throws java.io.IOException {
        Patch result = new Patch(accountId, webPropertyId, profileId, experimentId, content);
        initialize(result);
        return result;
      }

      public class Patch extends AnalyticsRequest<com.google.api.services.analytics.model.Experiment> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";

        /**
         * Update an existing experiment. This method supports patch semantics.
         *
         * Create a request for the method "experiments.patch".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID of the experiment to update.
         * @param webPropertyId Web property ID of the experiment to update.
         * @param profileId View (Profile) ID of the experiment to update.
         * @param experimentId Experiment ID of the experiment to update.
         * @param content the {@link com.google.api.services.analytics.model.Experiment}
         * @since 1.13
         */
        protected Patch(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String experimentId, com.google.api.services.analytics.model.Experiment content) {
          super(Analytics.this, "PATCH", REST_PATH, content, com.google.api.services.analytics.model.Experiment.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          this.experimentId = com.google.api.client.util.Preconditions.checkNotNull(experimentId, "Required parameter experimentId must be specified.");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getId(), "Experiment.getId()");
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUserIp(java.lang.String userIp) {
          return (Patch) super.setUserIp(userIp);
        }

        /** Account ID of the experiment to update. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID of the experiment to update.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID of the experiment to update. */
        public Patch setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID of the experiment to update. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID of the experiment to update.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID of the experiment to update. */
        public Patch setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID of the experiment to update. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID of the experiment to update.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID of the experiment to update. */
        public Patch setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** Experiment ID of the experiment to update. */
        @com.google.api.client.util.Key
        private java.lang.String experimentId;

        /** Experiment ID of the experiment to update.
         */
        public java.lang.String getExperimentId() {
          return experimentId;
        }

        /** Experiment ID of the experiment to update. */
        public Patch setExperimentId(java.lang.String experimentId) {
          this.experimentId = experimentId;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Update an existing experiment.
       *
       * Create a request for the method "experiments.update".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID of the experiment to update.
       * @param webPropertyId Web property ID of the experiment to update.
       * @param profileId View (Profile) ID of the experiment to update.
       * @param experimentId Experiment ID of the experiment to update.
       * @param content the {@link com.google.api.services.analytics.model.Experiment}
       * @return the request
       */
      public Update update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String experimentId, com.google.api.services.analytics.model.Experiment content) throws java.io.IOException {
        Update result = new Update(accountId, webPropertyId, profileId, experimentId, content);
        initialize(result);
        return result;
      }

      public class Update extends AnalyticsRequest<com.google.api.services.analytics.model.Experiment> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";

        /**
         * Update an existing experiment.
         *
         * Create a request for the method "experiments.update".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID of the experiment to update.
         * @param webPropertyId Web property ID of the experiment to update.
         * @param profileId View (Profile) ID of the experiment to update.
         * @param experimentId Experiment ID of the experiment to update.
         * @param content the {@link com.google.api.services.analytics.model.Experiment}
         * @since 1.13
         */
        protected Update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String experimentId, com.google.api.services.analytics.model.Experiment content) {
          super(Analytics.this, "PUT", REST_PATH, content, com.google.api.services.analytics.model.Experiment.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          this.experimentId = com.google.api.client.util.Preconditions.checkNotNull(experimentId, "Required parameter experimentId must be specified.");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getId(), "Experiment.getId()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getName(), "Experiment.getName()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getStatus(), "Experiment.getStatus()");
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUserIp(java.lang.String userIp) {
          return (Update) super.setUserIp(userIp);
        }

        /** Account ID of the experiment to update. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID of the experiment to update.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID of the experiment to update. */
        public Update setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID of the experiment to update. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID of the experiment to update.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID of the experiment to update. */
        public Update setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID of the experiment to update. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID of the experiment to update.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID of the experiment to update. */
        public Update setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** Experiment ID of the experiment to update. */
        @com.google.api.client.util.Key
        private java.lang.String experimentId;

        /** Experiment ID of the experiment to update.
         */
        public java.lang.String getExperimentId() {
          return experimentId;
        }

        /** Experiment ID of the experiment to update. */
        public Update setExperimentId(java.lang.String experimentId) {
          this.experimentId = experimentId;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Goals collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Goals.List request = analytics.goals().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Goals goals() {
      return new Goals();
    }

    /**
     * The "goals" collection of methods.
     */
    public class Goals {

      /**
       * Lists goals to which the user has access.
       *
       * Create a request for the method "goals.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve goals for. Can either be a specific account ID or '~all', which refers to all
       *        the accounts that user has access to.
       * @param webPropertyId Web property ID to retrieve goals for. Can either be a specific web property ID or '~all', which
       *        refers to all the web properties that user has access to.
       * @param profileId View (Profile) ID to retrieve goals for. Can either be a specific view (profile) ID or '~all', which
       *        refers to all the views (profiles) that user has access to.
       * @return the request
       */
      public List list(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId, profileId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Goals> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals";

        /**
         * Lists goals to which the user has access.
         *
         * Create a request for the method "goals.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve goals for. Can either be a specific account ID or '~all', which refers to all
       *        the accounts that user has access to.
         * @param webPropertyId Web property ID to retrieve goals for. Can either be a specific web property ID or '~all', which
       *        refers to all the web properties that user has access to.
         * @param profileId View (Profile) ID to retrieve goals for. Can either be a specific view (profile) ID or '~all', which
       *        refers to all the views (profiles) that user has access to.
         * @since 1.13
         */
        protected List(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Goals.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /**
         * Account ID to retrieve goals for. Can either be a specific account ID or '~all', which
         * refers to all the accounts that user has access to.
         */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to retrieve goals for. Can either be a specific account ID or '~all', which refers to
       all the accounts that user has access to.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /**
         * Account ID to retrieve goals for. Can either be a specific account ID or '~all', which
         * refers to all the accounts that user has access to.
         */
        public List setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /**
         * Web property ID to retrieve goals for. Can either be a specific web property ID or
         * '~all', which refers to all the web properties that user has access to.
         */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to retrieve goals for. Can either be a specific web property ID or '~all', which
       refers to all the web properties that user has access to.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /**
         * Web property ID to retrieve goals for. Can either be a specific web property ID or
         * '~all', which refers to all the web properties that user has access to.
         */
        public List setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /**
         * View (Profile) ID to retrieve goals for. Can either be a specific view (profile) ID or
         * '~all', which refers to all the views (profiles) that user has access to.
         */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to retrieve goals for. Can either be a specific view (profile) ID or '~all',
       which refers to all the views (profiles) that user has access to.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /**
         * View (Profile) ID to retrieve goals for. Can either be a specific view (profile) ID or
         * '~all', which refers to all the views (profiles) that user has access to.
         */
        public List setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** The maximum number of goals to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of goals to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of goals to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first goal to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first goal to retrieve. Use this parameter as a pagination mechanism along with the
       max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first goal to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Profiles collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Profiles.List request = analytics.profiles().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Profiles profiles() {
      return new Profiles();
    }

    /**
     * The "profiles" collection of methods.
     */
    public class Profiles {

      /**
       * Lists views (profiles) to which the user has access.
       *
       * Create a request for the method "profiles.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID for the view (profiles) to retrieve. Can either be a specific account ID or '~all', which
       *        refers to all the accounts to which the user has access.
       * @param webPropertyId Web property ID for the views (profiles) to retrieve. Can either be a specific web property ID or
       *        '~all', which refers to all the web properties to which the user has access.
       * @return the request
       */
      public List list(java.lang.String accountId, java.lang.String webPropertyId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Profiles> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles";

        /**
         * Lists views (profiles) to which the user has access.
         *
         * Create a request for the method "profiles.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID for the view (profiles) to retrieve. Can either be a specific account ID or '~all', which
       *        refers to all the accounts to which the user has access.
         * @param webPropertyId Web property ID for the views (profiles) to retrieve. Can either be a specific web property ID or
       *        '~all', which refers to all the web properties to which the user has access.
         * @since 1.13
         */
        protected List(java.lang.String accountId, java.lang.String webPropertyId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Profiles.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /**
         * Account ID for the view (profiles) to retrieve. Can either be a specific account ID or
         * '~all', which refers to all the accounts to which the user has access.
         */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID for the view (profiles) to retrieve. Can either be a specific account ID or '~all',
       which refers to all the accounts to which the user has access.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /**
         * Account ID for the view (profiles) to retrieve. Can either be a specific account ID or
         * '~all', which refers to all the accounts to which the user has access.
         */
        public List setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /**
         * Web property ID for the views (profiles) to retrieve. Can either be a specific web
         * property ID or '~all', which refers to all the web properties to which the user has
         * access.
         */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID for the views (profiles) to retrieve. Can either be a specific web property ID or
       '~all', which refers to all the web properties to which the user has access.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /**
         * Web property ID for the views (profiles) to retrieve. Can either be a specific web
         * property ID or '~all', which refers to all the web properties to which the user has
         * access.
         */
        public List setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** The maximum number of views (profiles) to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of views (profiles) to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of views (profiles) to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Segments collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Segments.List request = analytics.segments().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Segments segments() {
      return new Segments();
    }

    /**
     * The "segments" collection of methods.
     */
    public class Segments {

      /**
       * Lists advanced segments to which the user has access.
       *
       * Create a request for the method "segments.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @return the request
       */
      public List list() throws java.io.IOException {
        List result = new List();
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Segments> {

        private static final String REST_PATH = "management/segments";

        /**
         * Lists advanced segments to which the user has access.
         *
         * Create a request for the method "segments.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @since 1.13
         */
        protected List() {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Segments.class);
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** The maximum number of advanced segments to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of advanced segments to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of advanced segments to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first advanced segment to retrieve. Use this parameter as a pagination
         * mechanism along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first advanced segment to retrieve. Use this parameter as a pagination mechanism
       along with the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first advanced segment to retrieve. Use this parameter as a pagination
         * mechanism along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Webproperties collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Webproperties.List request = analytics.webproperties().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Webproperties webproperties() {
      return new Webproperties();
    }

    /**
     * The "webproperties" collection of methods.
     */
    public class Webproperties {

      /**
       * Lists web properties to which the user has access.
       *
       * Create a request for the method "webproperties.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve web properties for. Can either be a specific account ID or '~all', which
       *        refers to all the accounts that user has access to.
       * @return the request
       */
      public List list(java.lang.String accountId) throws java.io.IOException {
        List result = new List(accountId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Webproperties> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties";

        /**
         * Lists web properties to which the user has access.
         *
         * Create a request for the method "webproperties.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve web properties for. Can either be a specific account ID or '~all', which
       *        refers to all the accounts that user has access to.
         * @since 1.13
         */
        protected List(java.lang.String accountId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Webproperties.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /**
         * Account ID to retrieve web properties for. Can either be a specific account ID or '~all',
         * which refers to all the accounts that user has access to.
         */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to retrieve web properties for. Can either be a specific account ID or '~all', which
       refers to all the accounts that user has access to.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /**
         * Account ID to retrieve web properties for. Can either be a specific account ID or '~all',
         * which refers to all the accounts that user has access to.
         */
        public List setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** The maximum number of web properties to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of web properties to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of web properties to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * An accessor for creating requests from the Metadata collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Analytics analytics = new Analytics(...);}
   *   {@code Analytics.Metadata.List request = analytics.metadata().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Metadata metadata() {
    return new Metadata();
  }

  /**
   * The "metadata" collection of methods.
   */
  public class Metadata {

    /**
     * An accessor for creating requests from the Columns collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Columns.List request = analytics.columns().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Columns columns() {
      return new Columns();
    }

    /**
     * The "columns" collection of methods.
     */
    public class Columns {

      /**
       * Lists all columns for a report type
       *
       * Create a request for the method "columns.list".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param reportType Report type. Allowed Values: 'ga'. Where 'ga' corresponds to the Core Reporting API
       * @return the request
       */
      public List list(java.lang.String reportType) throws java.io.IOException {
        List result = new List(reportType);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Columns> {

        private static final String REST_PATH = "metadata/{reportType}/columns";

        private final java.util.regex.Pattern REPORTTYPE_PATTERN =
            java.util.regex.Pattern.compile("ga");

        /**
         * Lists all columns for a report type
         *
         * Create a request for the method "columns.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param reportType Report type. Allowed Values: 'ga'. Where 'ga' corresponds to the Core Reporting API
         * @since 1.13
         */
        protected List(java.lang.String reportType) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Columns.class);
          this.reportType = com.google.api.client.util.Preconditions.checkNotNull(reportType, "Required parameter reportType must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(REPORTTYPE_PATTERN.matcher(reportType).matches(),
                "Parameter reportType must conform to the pattern " +
                "ga");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Report type. Allowed Values: 'ga'. Where 'ga' corresponds to the Core Reporting API */
        @com.google.api.client.util.Key
        private java.lang.String reportType;

        /** Report type. Allowed Values: 'ga'. Where 'ga' corresponds to the Core Reporting API
         */
        public java.lang.String getReportType() {
          return reportType;
        }

        /** Report type. Allowed Values: 'ga'. Where 'ga' corresponds to the Core Reporting API */
        public List setReportType(java.lang.String reportType) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(REPORTTYPE_PATTERN.matcher(reportType).matches(),
                "Parameter reportType must conform to the pattern " +
                "ga");
          }
          this.reportType = reportType;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link Analytics}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Analytics}. */
    @Override
    public Analytics build() {
      return new Analytics(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link AnalyticsRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setAnalyticsRequestInitializer(
        AnalyticsRequestInitializer analyticsRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(analyticsRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
