/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-20 at 11:23:34 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * JSON template for a user deletion request resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UserDeletionRequest extends com.google.api.client.json.GenericJson {

  /**
   * This marks the point in time for which all user data before should be deleted
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime deletionRequestTime;

  /**
   * Firebase Project Id
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String firebaseProjectId;

  /**
   * User ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Id id;

  /**
   * Value is "analytics#userDeletionRequest".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Web property ID of the form UA-XXXXX-YY.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String webPropertyId;

  /**
   * This marks the point in time for which all user data before should be deleted
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getDeletionRequestTime() {
    return deletionRequestTime;
  }

  /**
   * This marks the point in time for which all user data before should be deleted
   * @param deletionRequestTime deletionRequestTime or {@code null} for none
   */
  public UserDeletionRequest setDeletionRequestTime(com.google.api.client.util.DateTime deletionRequestTime) {
    this.deletionRequestTime = deletionRequestTime;
    return this;
  }

  /**
   * Firebase Project Id
   * @return value or {@code null} for none
   */
  public java.lang.String getFirebaseProjectId() {
    return firebaseProjectId;
  }

  /**
   * Firebase Project Id
   * @param firebaseProjectId firebaseProjectId or {@code null} for none
   */
  public UserDeletionRequest setFirebaseProjectId(java.lang.String firebaseProjectId) {
    this.firebaseProjectId = firebaseProjectId;
    return this;
  }

  /**
   * User ID.
   * @return value or {@code null} for none
   */
  public Id getId() {
    return id;
  }

  /**
   * User ID.
   * @param id id or {@code null} for none
   */
  public UserDeletionRequest setId(Id id) {
    this.id = id;
    return this;
  }

  /**
   * Value is "analytics#userDeletionRequest".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Value is "analytics#userDeletionRequest".
   * @param kind kind or {@code null} for none
   */
  public UserDeletionRequest setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebPropertyId() {
    return webPropertyId;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY.
   * @param webPropertyId webPropertyId or {@code null} for none
   */
  public UserDeletionRequest setWebPropertyId(java.lang.String webPropertyId) {
    this.webPropertyId = webPropertyId;
    return this;
  }

  @Override
  public UserDeletionRequest set(String fieldName, Object value) {
    return (UserDeletionRequest) super.set(fieldName, value);
  }

  @Override
  public UserDeletionRequest clone() {
    return (UserDeletionRequest) super.clone();
  }

  /**
   * User ID.
   */
  public static final class Id extends com.google.api.client.json.GenericJson {

    /**
     * Type of user
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * The User's id
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String userId;

    /**
     * Type of user
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * Type of user
     * @param type type or {@code null} for none
     */
    public Id setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    /**
     * The User's id
     * @return value or {@code null} for none
     */
    public java.lang.String getUserId() {
      return userId;
    }

    /**
     * The User's id
     * @param userId userId or {@code null} for none
     */
    public Id setUserId(java.lang.String userId) {
      this.userId = userId;
      return this;
    }

    @Override
    public Id set(String fieldName, Object value) {
      return (Id) super.set(fieldName, value);
    }

    @Override
    public Id clone() {
      return (Id) super.clone();
    }

  }

}
