/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-20 at 11:23:34 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * JSON template for an Analytics Remarketing Audience Foreign Link.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LinkedForeignAccount extends com.google.api.client.json.GenericJson {

  /**
   * Account ID to which this linked foreign account belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountId;

  /**
   * Boolean indicating whether this is eligible for search.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean eligibleForSearch;

  /**
   * Entity ad account link ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Internal ID for the web property to which this linked foreign account belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String internalWebPropertyId;

  /**
   * Resource type for linked foreign account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The foreign account ID. For example the an Google Ads `linkedAccountId` has the following
   * format XXX-XXX-XXXX.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String linkedAccountId;

  /**
   * Remarketing audience ID to which this linked foreign account belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String remarketingAudienceId;

  /**
   * The status of this foreign account link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * The type of the foreign account. For example, `ADWORDS_LINKS`, `DBM_LINKS`, `MCC_LINKS` or
   * `OPTIMIZE`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Web property ID of the form UA-XXXXX-YY to which this linked foreign account belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String webPropertyId;

  /**
   * Account ID to which this linked foreign account belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountId() {
    return accountId;
  }

  /**
   * Account ID to which this linked foreign account belongs.
   * @param accountId accountId or {@code null} for none
   */
  public LinkedForeignAccount setAccountId(java.lang.String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Boolean indicating whether this is eligible for search.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEligibleForSearch() {
    return eligibleForSearch;
  }

  /**
   * Boolean indicating whether this is eligible for search.
   * @param eligibleForSearch eligibleForSearch or {@code null} for none
   */
  public LinkedForeignAccount setEligibleForSearch(java.lang.Boolean eligibleForSearch) {
    this.eligibleForSearch = eligibleForSearch;
    return this;
  }

  /**
   * Entity ad account link ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Entity ad account link ID.
   * @param id id or {@code null} for none
   */
  public LinkedForeignAccount setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Internal ID for the web property to which this linked foreign account belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getInternalWebPropertyId() {
    return internalWebPropertyId;
  }

  /**
   * Internal ID for the web property to which this linked foreign account belongs.
   * @param internalWebPropertyId internalWebPropertyId or {@code null} for none
   */
  public LinkedForeignAccount setInternalWebPropertyId(java.lang.String internalWebPropertyId) {
    this.internalWebPropertyId = internalWebPropertyId;
    return this;
  }

  /**
   * Resource type for linked foreign account.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Resource type for linked foreign account.
   * @param kind kind or {@code null} for none
   */
  public LinkedForeignAccount setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The foreign account ID. For example the an Google Ads `linkedAccountId` has the following
   * format XXX-XXX-XXXX.
   * @return value or {@code null} for none
   */
  public java.lang.String getLinkedAccountId() {
    return linkedAccountId;
  }

  /**
   * The foreign account ID. For example the an Google Ads `linkedAccountId` has the following
   * format XXX-XXX-XXXX.
   * @param linkedAccountId linkedAccountId or {@code null} for none
   */
  public LinkedForeignAccount setLinkedAccountId(java.lang.String linkedAccountId) {
    this.linkedAccountId = linkedAccountId;
    return this;
  }

  /**
   * Remarketing audience ID to which this linked foreign account belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getRemarketingAudienceId() {
    return remarketingAudienceId;
  }

  /**
   * Remarketing audience ID to which this linked foreign account belongs.
   * @param remarketingAudienceId remarketingAudienceId or {@code null} for none
   */
  public LinkedForeignAccount setRemarketingAudienceId(java.lang.String remarketingAudienceId) {
    this.remarketingAudienceId = remarketingAudienceId;
    return this;
  }

  /**
   * The status of this foreign account link.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * The status of this foreign account link.
   * @param status status or {@code null} for none
   */
  public LinkedForeignAccount setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * The type of the foreign account. For example, `ADWORDS_LINKS`, `DBM_LINKS`, `MCC_LINKS` or
   * `OPTIMIZE`.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of the foreign account. For example, `ADWORDS_LINKS`, `DBM_LINKS`, `MCC_LINKS` or
   * `OPTIMIZE`.
   * @param type type or {@code null} for none
   */
  public LinkedForeignAccount setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY to which this linked foreign account belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebPropertyId() {
    return webPropertyId;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY to which this linked foreign account belongs.
   * @param webPropertyId webPropertyId or {@code null} for none
   */
  public LinkedForeignAccount setWebPropertyId(java.lang.String webPropertyId) {
    this.webPropertyId = webPropertyId;
    return this;
  }

  @Override
  public LinkedForeignAccount set(String fieldName, Object value) {
    return (LinkedForeignAccount) super.set(fieldName, value);
  }

  @Override
  public LinkedForeignAccount clone() {
    return (LinkedForeignAccount) super.clone();
  }

}
