/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/iam/admin/v1/iam.proto

// Protobuf Java Version: 3.25.8
package com.google.iam.admin.v1;

/**
 *
 *
 * <pre>
 * A permission which can be included by a role.
 * </pre>
 *
 * Protobuf type {@code google.iam.admin.v1.Permission}
 */
public final class Permission extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.iam.admin.v1.Permission)
    PermissionOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Permission.newBuilder() to construct.
  private Permission(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Permission() {
    name_ = "";
    title_ = "";
    description_ = "";
    stage_ = 0;
    customRolesSupportLevel_ = 0;
    primaryPermission_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Permission();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.iam.admin.v1.Iam.internal_static_google_iam_admin_v1_Permission_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.iam.admin.v1.Iam
        .internal_static_google_iam_admin_v1_Permission_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.iam.admin.v1.Permission.class,
            com.google.iam.admin.v1.Permission.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * A stage representing a permission's lifecycle phase.
   * </pre>
   *
   * Protobuf enum {@code google.iam.admin.v1.Permission.PermissionLaunchStage}
   */
  public enum PermissionLaunchStage implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The permission is currently in an alpha phase.
     * </pre>
     *
     * <code>ALPHA = 0;</code>
     */
    ALPHA(0),
    /**
     *
     *
     * <pre>
     * The permission is currently in a beta phase.
     * </pre>
     *
     * <code>BETA = 1;</code>
     */
    BETA(1),
    /**
     *
     *
     * <pre>
     * The permission is generally available.
     * </pre>
     *
     * <code>GA = 2;</code>
     */
    GA(2),
    /**
     *
     *
     * <pre>
     * The permission is being deprecated.
     * </pre>
     *
     * <code>DEPRECATED = 3;</code>
     */
    DEPRECATED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The permission is currently in an alpha phase.
     * </pre>
     *
     * <code>ALPHA = 0;</code>
     */
    public static final int ALPHA_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The permission is currently in a beta phase.
     * </pre>
     *
     * <code>BETA = 1;</code>
     */
    public static final int BETA_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The permission is generally available.
     * </pre>
     *
     * <code>GA = 2;</code>
     */
    public static final int GA_VALUE = 2;

    /**
     *
     *
     * <pre>
     * The permission is being deprecated.
     * </pre>
     *
     * <code>DEPRECATED = 3;</code>
     */
    public static final int DEPRECATED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PermissionLaunchStage valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PermissionLaunchStage forNumber(int value) {
      switch (value) {
        case 0:
          return ALPHA;
        case 1:
          return BETA;
        case 2:
          return GA;
        case 3:
          return DEPRECATED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PermissionLaunchStage>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PermissionLaunchStage>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PermissionLaunchStage>() {
              public PermissionLaunchStage findValueByNumber(int number) {
                return PermissionLaunchStage.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.iam.admin.v1.Permission.getDescriptor().getEnumTypes().get(0);
    }

    private static final PermissionLaunchStage[] VALUES = values();

    public static PermissionLaunchStage valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PermissionLaunchStage(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.iam.admin.v1.Permission.PermissionLaunchStage)
  }

  /**
   *
   *
   * <pre>
   * The state of the permission with regards to custom roles.
   * </pre>
   *
   * Protobuf enum {@code google.iam.admin.v1.Permission.CustomRolesSupportLevel}
   */
  public enum CustomRolesSupportLevel implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default state. Permission is fully supported for custom role use.
     * </pre>
     *
     * <code>SUPPORTED = 0;</code>
     */
    SUPPORTED(0),
    /**
     *
     *
     * <pre>
     * Permission is being tested to check custom role compatibility.
     * </pre>
     *
     * <code>TESTING = 1;</code>
     */
    TESTING(1),
    /**
     *
     *
     * <pre>
     * Permission is not supported for custom role use.
     * </pre>
     *
     * <code>NOT_SUPPORTED = 2;</code>
     */
    NOT_SUPPORTED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default state. Permission is fully supported for custom role use.
     * </pre>
     *
     * <code>SUPPORTED = 0;</code>
     */
    public static final int SUPPORTED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Permission is being tested to check custom role compatibility.
     * </pre>
     *
     * <code>TESTING = 1;</code>
     */
    public static final int TESTING_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Permission is not supported for custom role use.
     * </pre>
     *
     * <code>NOT_SUPPORTED = 2;</code>
     */
    public static final int NOT_SUPPORTED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CustomRolesSupportLevel valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CustomRolesSupportLevel forNumber(int value) {
      switch (value) {
        case 0:
          return SUPPORTED;
        case 1:
          return TESTING;
        case 2:
          return NOT_SUPPORTED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CustomRolesSupportLevel>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CustomRolesSupportLevel>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CustomRolesSupportLevel>() {
              public CustomRolesSupportLevel findValueByNumber(int number) {
                return CustomRolesSupportLevel.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.iam.admin.v1.Permission.getDescriptor().getEnumTypes().get(1);
    }

    private static final CustomRolesSupportLevel[] VALUES = values();

    public static CustomRolesSupportLevel valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CustomRolesSupportLevel(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.iam.admin.v1.Permission.CustomRolesSupportLevel)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * The name of this Permission.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The name of this Permission.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TITLE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object title_ = "";

  /**
   *
   *
   * <pre>
   * The title of this Permission.
   * </pre>
   *
   * <code>string title = 2;</code>
   *
   * @return The title.
   */
  @java.lang.Override
  public java.lang.String getTitle() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      title_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The title of this Permission.
   * </pre>
   *
   * <code>string title = 2;</code>
   *
   * @return The bytes for title.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTitleBytes() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      title_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * A brief description of what this Permission is used for.
   * This permission can ONLY be used in predefined roles.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A brief description of what this Permission is used for.
   * This permission can ONLY be used in predefined roles.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ONLY_IN_PREDEFINED_ROLES_FIELD_NUMBER = 4;
  private boolean onlyInPredefinedRoles_ = false;

  /**
   * <code>bool only_in_predefined_roles = 4 [deprecated = true];</code>
   *
   * @deprecated google.iam.admin.v1.Permission.only_in_predefined_roles is deprecated. See
   *     google/iam/admin/v1/iam.proto;l=1450
   * @return The onlyInPredefinedRoles.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getOnlyInPredefinedRoles() {
    return onlyInPredefinedRoles_;
  }

  public static final int STAGE_FIELD_NUMBER = 5;
  private int stage_ = 0;

  /**
   *
   *
   * <pre>
   * The current launch stage of the permission.
   * </pre>
   *
   * <code>.google.iam.admin.v1.Permission.PermissionLaunchStage stage = 5;</code>
   *
   * @return The enum numeric value on the wire for stage.
   */
  @java.lang.Override
  public int getStageValue() {
    return stage_;
  }

  /**
   *
   *
   * <pre>
   * The current launch stage of the permission.
   * </pre>
   *
   * <code>.google.iam.admin.v1.Permission.PermissionLaunchStage stage = 5;</code>
   *
   * @return The stage.
   */
  @java.lang.Override
  public com.google.iam.admin.v1.Permission.PermissionLaunchStage getStage() {
    com.google.iam.admin.v1.Permission.PermissionLaunchStage result =
        com.google.iam.admin.v1.Permission.PermissionLaunchStage.forNumber(stage_);
    return result == null
        ? com.google.iam.admin.v1.Permission.PermissionLaunchStage.UNRECOGNIZED
        : result;
  }

  public static final int CUSTOM_ROLES_SUPPORT_LEVEL_FIELD_NUMBER = 6;
  private int customRolesSupportLevel_ = 0;

  /**
   *
   *
   * <pre>
   * The current custom role support level.
   * </pre>
   *
   * <code>.google.iam.admin.v1.Permission.CustomRolesSupportLevel custom_roles_support_level = 6;
   * </code>
   *
   * @return The enum numeric value on the wire for customRolesSupportLevel.
   */
  @java.lang.Override
  public int getCustomRolesSupportLevelValue() {
    return customRolesSupportLevel_;
  }

  /**
   *
   *
   * <pre>
   * The current custom role support level.
   * </pre>
   *
   * <code>.google.iam.admin.v1.Permission.CustomRolesSupportLevel custom_roles_support_level = 6;
   * </code>
   *
   * @return The customRolesSupportLevel.
   */
  @java.lang.Override
  public com.google.iam.admin.v1.Permission.CustomRolesSupportLevel getCustomRolesSupportLevel() {
    com.google.iam.admin.v1.Permission.CustomRolesSupportLevel result =
        com.google.iam.admin.v1.Permission.CustomRolesSupportLevel.forNumber(
            customRolesSupportLevel_);
    return result == null
        ? com.google.iam.admin.v1.Permission.CustomRolesSupportLevel.UNRECOGNIZED
        : result;
  }

  public static final int API_DISABLED_FIELD_NUMBER = 7;
  private boolean apiDisabled_ = false;

  /**
   *
   *
   * <pre>
   * The service API associated with the permission is not enabled.
   * </pre>
   *
   * <code>bool api_disabled = 7;</code>
   *
   * @return The apiDisabled.
   */
  @java.lang.Override
  public boolean getApiDisabled() {
    return apiDisabled_;
  }

  public static final int PRIMARY_PERMISSION_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object primaryPermission_ = "";

  /**
   *
   *
   * <pre>
   * The preferred name for this permission. If present, then this permission is
   * an alias of, and equivalent to, the listed primary_permission.
   * </pre>
   *
   * <code>string primary_permission = 8;</code>
   *
   * @return The primaryPermission.
   */
  @java.lang.Override
  public java.lang.String getPrimaryPermission() {
    java.lang.Object ref = primaryPermission_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      primaryPermission_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The preferred name for this permission. If present, then this permission is
   * an alias of, and equivalent to, the listed primary_permission.
   * </pre>
   *
   * <code>string primary_permission = 8;</code>
   *
   * @return The bytes for primaryPermission.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrimaryPermissionBytes() {
    java.lang.Object ref = primaryPermission_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      primaryPermission_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, title_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (onlyInPredefinedRoles_ != false) {
      output.writeBool(4, onlyInPredefinedRoles_);
    }
    if (stage_ != com.google.iam.admin.v1.Permission.PermissionLaunchStage.ALPHA.getNumber()) {
      output.writeEnum(5, stage_);
    }
    if (customRolesSupportLevel_
        != com.google.iam.admin.v1.Permission.CustomRolesSupportLevel.SUPPORTED.getNumber()) {
      output.writeEnum(6, customRolesSupportLevel_);
    }
    if (apiDisabled_ != false) {
      output.writeBool(7, apiDisabled_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(primaryPermission_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, primaryPermission_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, title_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (onlyInPredefinedRoles_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, onlyInPredefinedRoles_);
    }
    if (stage_ != com.google.iam.admin.v1.Permission.PermissionLaunchStage.ALPHA.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, stage_);
    }
    if (customRolesSupportLevel_
        != com.google.iam.admin.v1.Permission.CustomRolesSupportLevel.SUPPORTED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, customRolesSupportLevel_);
    }
    if (apiDisabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, apiDisabled_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(primaryPermission_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, primaryPermission_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.iam.admin.v1.Permission)) {
      return super.equals(obj);
    }
    com.google.iam.admin.v1.Permission other = (com.google.iam.admin.v1.Permission) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getTitle().equals(other.getTitle())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (getOnlyInPredefinedRoles() != other.getOnlyInPredefinedRoles()) return false;
    if (stage_ != other.stage_) return false;
    if (customRolesSupportLevel_ != other.customRolesSupportLevel_) return false;
    if (getApiDisabled() != other.getApiDisabled()) return false;
    if (!getPrimaryPermission().equals(other.getPrimaryPermission())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TITLE_FIELD_NUMBER;
    hash = (53 * hash) + getTitle().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + ONLY_IN_PREDEFINED_ROLES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getOnlyInPredefinedRoles());
    hash = (37 * hash) + STAGE_FIELD_NUMBER;
    hash = (53 * hash) + stage_;
    hash = (37 * hash) + CUSTOM_ROLES_SUPPORT_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + customRolesSupportLevel_;
    hash = (37 * hash) + API_DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getApiDisabled());
    hash = (37 * hash) + PRIMARY_PERMISSION_FIELD_NUMBER;
    hash = (53 * hash) + getPrimaryPermission().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.iam.admin.v1.Permission parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.Permission parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.Permission parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.Permission parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.Permission parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.Permission parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.Permission parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.Permission parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.iam.admin.v1.Permission parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.Permission parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.iam.admin.v1.Permission parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.Permission parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.iam.admin.v1.Permission prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A permission which can be included by a role.
   * </pre>
   *
   * Protobuf type {@code google.iam.admin.v1.Permission}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.iam.admin.v1.Permission)
      com.google.iam.admin.v1.PermissionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.iam.admin.v1.Iam.internal_static_google_iam_admin_v1_Permission_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.iam.admin.v1.Iam
          .internal_static_google_iam_admin_v1_Permission_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.iam.admin.v1.Permission.class,
              com.google.iam.admin.v1.Permission.Builder.class);
    }

    // Construct using com.google.iam.admin.v1.Permission.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      title_ = "";
      description_ = "";
      onlyInPredefinedRoles_ = false;
      stage_ = 0;
      customRolesSupportLevel_ = 0;
      apiDisabled_ = false;
      primaryPermission_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.iam.admin.v1.Iam.internal_static_google_iam_admin_v1_Permission_descriptor;
    }

    @java.lang.Override
    public com.google.iam.admin.v1.Permission getDefaultInstanceForType() {
      return com.google.iam.admin.v1.Permission.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.iam.admin.v1.Permission build() {
      com.google.iam.admin.v1.Permission result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.iam.admin.v1.Permission buildPartial() {
      com.google.iam.admin.v1.Permission result = new com.google.iam.admin.v1.Permission(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.iam.admin.v1.Permission result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.title_ = title_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.onlyInPredefinedRoles_ = onlyInPredefinedRoles_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.stage_ = stage_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.customRolesSupportLevel_ = customRolesSupportLevel_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.apiDisabled_ = apiDisabled_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.primaryPermission_ = primaryPermission_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.iam.admin.v1.Permission) {
        return mergeFrom((com.google.iam.admin.v1.Permission) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.iam.admin.v1.Permission other) {
      if (other == com.google.iam.admin.v1.Permission.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getTitle().isEmpty()) {
        title_ = other.title_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getOnlyInPredefinedRoles() != false) {
        setOnlyInPredefinedRoles(other.getOnlyInPredefinedRoles());
      }
      if (other.stage_ != 0) {
        setStageValue(other.getStageValue());
      }
      if (other.customRolesSupportLevel_ != 0) {
        setCustomRolesSupportLevelValue(other.getCustomRolesSupportLevelValue());
      }
      if (other.getApiDisabled() != false) {
        setApiDisabled(other.getApiDisabled());
      }
      if (!other.getPrimaryPermission().isEmpty()) {
        primaryPermission_ = other.primaryPermission_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                title_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                onlyInPredefinedRoles_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                stage_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                customRolesSupportLevel_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                apiDisabled_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 66:
              {
                primaryPermission_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * The name of this Permission.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of this Permission.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of this Permission.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of this Permission.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of this Permission.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object title_ = "";

    /**
     *
     *
     * <pre>
     * The title of this Permission.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @return The title.
     */
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The title of this Permission.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @return The bytes for title.
     */
    public com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The title of this Permission.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @param value The title to set.
     * @return This builder for chaining.
     */
    public Builder setTitle(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      title_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The title of this Permission.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTitle() {
      title_ = getDefaultInstance().getTitle();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The title of this Permission.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @param value The bytes for title to set.
     * @return This builder for chaining.
     */
    public Builder setTitleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      title_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * A brief description of what this Permission is used for.
     * This permission can ONLY be used in predefined roles.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A brief description of what this Permission is used for.
     * This permission can ONLY be used in predefined roles.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A brief description of what this Permission is used for.
     * This permission can ONLY be used in predefined roles.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A brief description of what this Permission is used for.
     * This permission can ONLY be used in predefined roles.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A brief description of what this Permission is used for.
     * This permission can ONLY be used in predefined roles.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean onlyInPredefinedRoles_;

    /**
     * <code>bool only_in_predefined_roles = 4 [deprecated = true];</code>
     *
     * @deprecated google.iam.admin.v1.Permission.only_in_predefined_roles is deprecated. See
     *     google/iam/admin/v1/iam.proto;l=1450
     * @return The onlyInPredefinedRoles.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getOnlyInPredefinedRoles() {
      return onlyInPredefinedRoles_;
    }

    /**
     * <code>bool only_in_predefined_roles = 4 [deprecated = true];</code>
     *
     * @deprecated google.iam.admin.v1.Permission.only_in_predefined_roles is deprecated. See
     *     google/iam/admin/v1/iam.proto;l=1450
     * @param value The onlyInPredefinedRoles to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setOnlyInPredefinedRoles(boolean value) {

      onlyInPredefinedRoles_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     * <code>bool only_in_predefined_roles = 4 [deprecated = true];</code>
     *
     * @deprecated google.iam.admin.v1.Permission.only_in_predefined_roles is deprecated. See
     *     google/iam/admin/v1/iam.proto;l=1450
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearOnlyInPredefinedRoles() {
      bitField0_ = (bitField0_ & ~0x00000008);
      onlyInPredefinedRoles_ = false;
      onChanged();
      return this;
    }

    private int stage_ = 0;

    /**
     *
     *
     * <pre>
     * The current launch stage of the permission.
     * </pre>
     *
     * <code>.google.iam.admin.v1.Permission.PermissionLaunchStage stage = 5;</code>
     *
     * @return The enum numeric value on the wire for stage.
     */
    @java.lang.Override
    public int getStageValue() {
      return stage_;
    }

    /**
     *
     *
     * <pre>
     * The current launch stage of the permission.
     * </pre>
     *
     * <code>.google.iam.admin.v1.Permission.PermissionLaunchStage stage = 5;</code>
     *
     * @param value The enum numeric value on the wire for stage to set.
     * @return This builder for chaining.
     */
    public Builder setStageValue(int value) {
      stage_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The current launch stage of the permission.
     * </pre>
     *
     * <code>.google.iam.admin.v1.Permission.PermissionLaunchStage stage = 5;</code>
     *
     * @return The stage.
     */
    @java.lang.Override
    public com.google.iam.admin.v1.Permission.PermissionLaunchStage getStage() {
      com.google.iam.admin.v1.Permission.PermissionLaunchStage result =
          com.google.iam.admin.v1.Permission.PermissionLaunchStage.forNumber(stage_);
      return result == null
          ? com.google.iam.admin.v1.Permission.PermissionLaunchStage.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * The current launch stage of the permission.
     * </pre>
     *
     * <code>.google.iam.admin.v1.Permission.PermissionLaunchStage stage = 5;</code>
     *
     * @param value The stage to set.
     * @return This builder for chaining.
     */
    public Builder setStage(com.google.iam.admin.v1.Permission.PermissionLaunchStage value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      stage_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The current launch stage of the permission.
     * </pre>
     *
     * <code>.google.iam.admin.v1.Permission.PermissionLaunchStage stage = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStage() {
      bitField0_ = (bitField0_ & ~0x00000010);
      stage_ = 0;
      onChanged();
      return this;
    }

    private int customRolesSupportLevel_ = 0;

    /**
     *
     *
     * <pre>
     * The current custom role support level.
     * </pre>
     *
     * <code>.google.iam.admin.v1.Permission.CustomRolesSupportLevel custom_roles_support_level = 6;
     * </code>
     *
     * @return The enum numeric value on the wire for customRolesSupportLevel.
     */
    @java.lang.Override
    public int getCustomRolesSupportLevelValue() {
      return customRolesSupportLevel_;
    }

    /**
     *
     *
     * <pre>
     * The current custom role support level.
     * </pre>
     *
     * <code>.google.iam.admin.v1.Permission.CustomRolesSupportLevel custom_roles_support_level = 6;
     * </code>
     *
     * @param value The enum numeric value on the wire for customRolesSupportLevel to set.
     * @return This builder for chaining.
     */
    public Builder setCustomRolesSupportLevelValue(int value) {
      customRolesSupportLevel_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The current custom role support level.
     * </pre>
     *
     * <code>.google.iam.admin.v1.Permission.CustomRolesSupportLevel custom_roles_support_level = 6;
     * </code>
     *
     * @return The customRolesSupportLevel.
     */
    @java.lang.Override
    public com.google.iam.admin.v1.Permission.CustomRolesSupportLevel getCustomRolesSupportLevel() {
      com.google.iam.admin.v1.Permission.CustomRolesSupportLevel result =
          com.google.iam.admin.v1.Permission.CustomRolesSupportLevel.forNumber(
              customRolesSupportLevel_);
      return result == null
          ? com.google.iam.admin.v1.Permission.CustomRolesSupportLevel.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * The current custom role support level.
     * </pre>
     *
     * <code>.google.iam.admin.v1.Permission.CustomRolesSupportLevel custom_roles_support_level = 6;
     * </code>
     *
     * @param value The customRolesSupportLevel to set.
     * @return This builder for chaining.
     */
    public Builder setCustomRolesSupportLevel(
        com.google.iam.admin.v1.Permission.CustomRolesSupportLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      customRolesSupportLevel_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The current custom role support level.
     * </pre>
     *
     * <code>.google.iam.admin.v1.Permission.CustomRolesSupportLevel custom_roles_support_level = 6;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomRolesSupportLevel() {
      bitField0_ = (bitField0_ & ~0x00000020);
      customRolesSupportLevel_ = 0;
      onChanged();
      return this;
    }

    private boolean apiDisabled_;

    /**
     *
     *
     * <pre>
     * The service API associated with the permission is not enabled.
     * </pre>
     *
     * <code>bool api_disabled = 7;</code>
     *
     * @return The apiDisabled.
     */
    @java.lang.Override
    public boolean getApiDisabled() {
      return apiDisabled_;
    }

    /**
     *
     *
     * <pre>
     * The service API associated with the permission is not enabled.
     * </pre>
     *
     * <code>bool api_disabled = 7;</code>
     *
     * @param value The apiDisabled to set.
     * @return This builder for chaining.
     */
    public Builder setApiDisabled(boolean value) {

      apiDisabled_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The service API associated with the permission is not enabled.
     * </pre>
     *
     * <code>bool api_disabled = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApiDisabled() {
      bitField0_ = (bitField0_ & ~0x00000040);
      apiDisabled_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object primaryPermission_ = "";

    /**
     *
     *
     * <pre>
     * The preferred name for this permission. If present, then this permission is
     * an alias of, and equivalent to, the listed primary_permission.
     * </pre>
     *
     * <code>string primary_permission = 8;</code>
     *
     * @return The primaryPermission.
     */
    public java.lang.String getPrimaryPermission() {
      java.lang.Object ref = primaryPermission_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        primaryPermission_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The preferred name for this permission. If present, then this permission is
     * an alias of, and equivalent to, the listed primary_permission.
     * </pre>
     *
     * <code>string primary_permission = 8;</code>
     *
     * @return The bytes for primaryPermission.
     */
    public com.google.protobuf.ByteString getPrimaryPermissionBytes() {
      java.lang.Object ref = primaryPermission_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        primaryPermission_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The preferred name for this permission. If present, then this permission is
     * an alias of, and equivalent to, the listed primary_permission.
     * </pre>
     *
     * <code>string primary_permission = 8;</code>
     *
     * @param value The primaryPermission to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryPermission(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      primaryPermission_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The preferred name for this permission. If present, then this permission is
     * an alias of, and equivalent to, the listed primary_permission.
     * </pre>
     *
     * <code>string primary_permission = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrimaryPermission() {
      primaryPermission_ = getDefaultInstance().getPrimaryPermission();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The preferred name for this permission. If present, then this permission is
     * an alias of, and equivalent to, the listed primary_permission.
     * </pre>
     *
     * <code>string primary_permission = 8;</code>
     *
     * @param value The bytes for primaryPermission to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryPermissionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      primaryPermission_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.iam.admin.v1.Permission)
  }

  // @@protoc_insertion_point(class_scope:google.iam.admin.v1.Permission)
  private static final com.google.iam.admin.v1.Permission DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.iam.admin.v1.Permission();
  }

  public static com.google.iam.admin.v1.Permission getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Permission> PARSER =
      new com.google.protobuf.AbstractParser<Permission>() {
        @java.lang.Override
        public Permission parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Permission> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Permission> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.iam.admin.v1.Permission getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
