/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.videointelligence.v1beta1;

import com.google.cloud.videointelligence.v1beta1.LabelDetectionMode;
import com.google.cloud.videointelligence.v1beta1.VideoContextOrBuilder;
import com.google.cloud.videointelligence.v1beta1.VideoIntelligenceServiceProto;
import com.google.cloud.videointelligence.v1beta1.VideoSegment;
import com.google.cloud.videointelligence.v1beta1.VideoSegmentOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class VideoContext
extends GeneratedMessageV3
implements VideoContextOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int SEGMENTS_FIELD_NUMBER = 1;
    private List<VideoSegment> segments_;
    public static final int LABEL_DETECTION_MODE_FIELD_NUMBER = 2;
    private int labelDetectionMode_;
    public static final int STATIONARY_CAMERA_FIELD_NUMBER = 3;
    private boolean stationaryCamera_;
    public static final int LABEL_DETECTION_MODEL_FIELD_NUMBER = 4;
    private volatile Object labelDetectionModel_;
    public static final int FACE_DETECTION_MODEL_FIELD_NUMBER = 5;
    private volatile Object faceDetectionModel_;
    public static final int SHOT_CHANGE_DETECTION_MODEL_FIELD_NUMBER = 6;
    private volatile Object shotChangeDetectionModel_;
    public static final int SAFE_SEARCH_DETECTION_MODEL_FIELD_NUMBER = 7;
    private volatile Object safeSearchDetectionModel_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final VideoContext DEFAULT_INSTANCE = new VideoContext();
    private static final Parser<VideoContext> PARSER = new AbstractParser<VideoContext>(){

        public VideoContext parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new VideoContext(input, extensionRegistry);
        }
    };

    private VideoContext(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private VideoContext() {
        this.segments_ = Collections.emptyList();
        this.labelDetectionMode_ = 0;
        this.stationaryCamera_ = false;
        this.labelDetectionModel_ = "";
        this.faceDetectionModel_ = "";
        this.shotChangeDetectionModel_ = "";
        this.safeSearchDetectionModel_ = "";
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private VideoContext(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        boolean mutable_bitField0_ = false;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block16: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block16;
                    }
                    case 10: {
                        if (!(mutable_bitField0_ & true)) {
                            this.segments_ = new ArrayList<VideoSegment>();
                            mutable_bitField0_ |= true;
                        }
                        this.segments_.add((VideoSegment)input.readMessage(VideoSegment.parser(), extensionRegistry));
                        continue block16;
                    }
                    case 16: {
                        int rawValue;
                        this.labelDetectionMode_ = rawValue = input.readEnum();
                        continue block16;
                    }
                    case 24: {
                        this.stationaryCamera_ = input.readBool();
                        continue block16;
                    }
                    case 34: {
                        String s = input.readStringRequireUtf8();
                        this.labelDetectionModel_ = s;
                        continue block16;
                    }
                    case 42: {
                        String s = input.readStringRequireUtf8();
                        this.faceDetectionModel_ = s;
                        continue block16;
                    }
                    case 50: {
                        String s = input.readStringRequireUtf8();
                        this.shotChangeDetectionModel_ = s;
                        continue block16;
                    }
                    case 58: {
                        String s = input.readStringRequireUtf8();
                        this.safeSearchDetectionModel_ = s;
                        continue block16;
                    }
                }
                if (this.parseUnknownFieldProto3(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.segments_ = Collections.unmodifiableList(this.segments_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return VideoIntelligenceServiceProto.internal_static_google_cloud_videointelligence_v1beta1_VideoContext_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return VideoIntelligenceServiceProto.internal_static_google_cloud_videointelligence_v1beta1_VideoContext_fieldAccessorTable.ensureFieldAccessorsInitialized(VideoContext.class, Builder.class);
    }

    @Override
    public List<VideoSegment> getSegmentsList() {
        return this.segments_;
    }

    @Override
    public List<? extends VideoSegmentOrBuilder> getSegmentsOrBuilderList() {
        return this.segments_;
    }

    @Override
    public int getSegmentsCount() {
        return this.segments_.size();
    }

    @Override
    public VideoSegment getSegments(int index) {
        return this.segments_.get(index);
    }

    @Override
    public VideoSegmentOrBuilder getSegmentsOrBuilder(int index) {
        return this.segments_.get(index);
    }

    @Override
    public int getLabelDetectionModeValue() {
        return this.labelDetectionMode_;
    }

    @Override
    public LabelDetectionMode getLabelDetectionMode() {
        LabelDetectionMode result = LabelDetectionMode.valueOf(this.labelDetectionMode_);
        return result == null ? LabelDetectionMode.UNRECOGNIZED : result;
    }

    @Override
    public boolean getStationaryCamera() {
        return this.stationaryCamera_;
    }

    @Override
    public String getLabelDetectionModel() {
        Object ref = this.labelDetectionModel_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.labelDetectionModel_ = s;
        return s;
    }

    @Override
    public ByteString getLabelDetectionModelBytes() {
        Object ref = this.labelDetectionModel_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.labelDetectionModel_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getFaceDetectionModel() {
        Object ref = this.faceDetectionModel_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.faceDetectionModel_ = s;
        return s;
    }

    @Override
    public ByteString getFaceDetectionModelBytes() {
        Object ref = this.faceDetectionModel_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.faceDetectionModel_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getShotChangeDetectionModel() {
        Object ref = this.shotChangeDetectionModel_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.shotChangeDetectionModel_ = s;
        return s;
    }

    @Override
    public ByteString getShotChangeDetectionModelBytes() {
        Object ref = this.shotChangeDetectionModel_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.shotChangeDetectionModel_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getSafeSearchDetectionModel() {
        Object ref = this.safeSearchDetectionModel_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.safeSearchDetectionModel_ = s;
        return s;
    }

    @Override
    public ByteString getSafeSearchDetectionModelBytes() {
        Object ref = this.safeSearchDetectionModel_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.safeSearchDetectionModel_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        for (int i = 0; i < this.segments_.size(); ++i) {
            output.writeMessage(1, (MessageLite)this.segments_.get(i));
        }
        if (this.labelDetectionMode_ != LabelDetectionMode.LABEL_DETECTION_MODE_UNSPECIFIED.getNumber()) {
            output.writeEnum(2, this.labelDetectionMode_);
        }
        if (this.stationaryCamera_) {
            output.writeBool(3, this.stationaryCamera_);
        }
        if (!this.getLabelDetectionModelBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.labelDetectionModel_);
        }
        if (!this.getFaceDetectionModelBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.faceDetectionModel_);
        }
        if (!this.getShotChangeDetectionModelBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.shotChangeDetectionModel_);
        }
        if (!this.getSafeSearchDetectionModelBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.safeSearchDetectionModel_);
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        for (int i = 0; i < this.segments_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((MessageLite)this.segments_.get(i)));
        }
        if (this.labelDetectionMode_ != LabelDetectionMode.LABEL_DETECTION_MODE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)2, (int)this.labelDetectionMode_);
        }
        if (this.stationaryCamera_) {
            size += CodedOutputStream.computeBoolSize((int)3, (boolean)this.stationaryCamera_);
        }
        if (!this.getLabelDetectionModelBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.labelDetectionModel_);
        }
        if (!this.getFaceDetectionModelBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.faceDetectionModel_);
        }
        if (!this.getShotChangeDetectionModelBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.shotChangeDetectionModel_);
        }
        if (!this.getSafeSearchDetectionModelBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)7, (Object)this.safeSearchDetectionModel_);
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VideoContext)) {
            return super.equals(obj);
        }
        VideoContext other = (VideoContext)obj;
        boolean result = true;
        result = result && this.getSegmentsList().equals(other.getSegmentsList());
        result = result && this.labelDetectionMode_ == other.labelDetectionMode_;
        result = result && this.getStationaryCamera() == other.getStationaryCamera();
        result = result && this.getLabelDetectionModel().equals(other.getLabelDetectionModel());
        result = result && this.getFaceDetectionModel().equals(other.getFaceDetectionModel());
        result = result && this.getShotChangeDetectionModel().equals(other.getShotChangeDetectionModel());
        result = result && this.getSafeSearchDetectionModel().equals(other.getSafeSearchDetectionModel());
        result = result && this.unknownFields.equals((Object)other.unknownFields);
        return result;
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + VideoContext.getDescriptor().hashCode();
        if (this.getSegmentsCount() > 0) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getSegmentsList().hashCode();
        }
        hash = 37 * hash + 2;
        hash = 53 * hash + this.labelDetectionMode_;
        hash = 37 * hash + 3;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getStationaryCamera());
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getLabelDetectionModel().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getFaceDetectionModel().hashCode();
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getShotChangeDetectionModel().hashCode();
        hash = 37 * hash + 7;
        hash = 53 * hash + this.getSafeSearchDetectionModel().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static VideoContext parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (VideoContext)PARSER.parseFrom(data);
    }

    public static VideoContext parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (VideoContext)PARSER.parseFrom(data, extensionRegistry);
    }

    public static VideoContext parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (VideoContext)PARSER.parseFrom(data);
    }

    public static VideoContext parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (VideoContext)PARSER.parseFrom(data, extensionRegistry);
    }

    public static VideoContext parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (VideoContext)PARSER.parseFrom(data);
    }

    public static VideoContext parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (VideoContext)PARSER.parseFrom(data, extensionRegistry);
    }

    public static VideoContext parseFrom(InputStream input) throws IOException {
        return (VideoContext)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static VideoContext parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (VideoContext)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static VideoContext parseDelimitedFrom(InputStream input) throws IOException {
        return (VideoContext)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static VideoContext parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (VideoContext)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static VideoContext parseFrom(CodedInputStream input) throws IOException {
        return (VideoContext)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static VideoContext parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (VideoContext)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return VideoContext.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(VideoContext prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static VideoContext getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<VideoContext> parser() {
        return PARSER;
    }

    public Parser<VideoContext> getParserForType() {
        return PARSER;
    }

    public VideoContext getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements VideoContextOrBuilder {
        private int bitField0_;
        private List<VideoSegment> segments_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<VideoSegment, VideoSegment.Builder, VideoSegmentOrBuilder> segmentsBuilder_;
        private int labelDetectionMode_ = 0;
        private boolean stationaryCamera_;
        private Object labelDetectionModel_ = "";
        private Object faceDetectionModel_ = "";
        private Object shotChangeDetectionModel_ = "";
        private Object safeSearchDetectionModel_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return VideoIntelligenceServiceProto.internal_static_google_cloud_videointelligence_v1beta1_VideoContext_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return VideoIntelligenceServiceProto.internal_static_google_cloud_videointelligence_v1beta1_VideoContext_fieldAccessorTable.ensureFieldAccessorsInitialized(VideoContext.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getSegmentsFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            if (this.segmentsBuilder_ == null) {
                this.segments_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
            } else {
                this.segmentsBuilder_.clear();
            }
            this.labelDetectionMode_ = 0;
            this.stationaryCamera_ = false;
            this.labelDetectionModel_ = "";
            this.faceDetectionModel_ = "";
            this.shotChangeDetectionModel_ = "";
            this.safeSearchDetectionModel_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return VideoIntelligenceServiceProto.internal_static_google_cloud_videointelligence_v1beta1_VideoContext_descriptor;
        }

        public VideoContext getDefaultInstanceForType() {
            return VideoContext.getDefaultInstance();
        }

        public VideoContext build() {
            VideoContext result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public VideoContext buildPartial() {
            VideoContext result = new VideoContext(this);
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if (this.segmentsBuilder_ == null) {
                if ((this.bitField0_ & 1) == 1) {
                    this.segments_ = Collections.unmodifiableList(this.segments_);
                    this.bitField0_ &= 0xFFFFFFFE;
                }
                result.segments_ = this.segments_;
            } else {
                result.segments_ = this.segmentsBuilder_.build();
            }
            result.labelDetectionMode_ = this.labelDetectionMode_;
            result.stationaryCamera_ = this.stationaryCamera_;
            result.labelDetectionModel_ = this.labelDetectionModel_;
            result.faceDetectionModel_ = this.faceDetectionModel_;
            result.shotChangeDetectionModel_ = this.shotChangeDetectionModel_;
            result.safeSearchDetectionModel_ = this.safeSearchDetectionModel_;
            result.bitField0_ = to_bitField0_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof VideoContext) {
                return this.mergeFrom((VideoContext)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(VideoContext other) {
            if (other == VideoContext.getDefaultInstance()) {
                return this;
            }
            if (this.segmentsBuilder_ == null) {
                if (!other.segments_.isEmpty()) {
                    if (this.segments_.isEmpty()) {
                        this.segments_ = other.segments_;
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.ensureSegmentsIsMutable();
                        this.segments_.addAll(other.segments_);
                    }
                    this.onChanged();
                }
            } else if (!other.segments_.isEmpty()) {
                if (this.segmentsBuilder_.isEmpty()) {
                    this.segmentsBuilder_.dispose();
                    this.segmentsBuilder_ = null;
                    this.segments_ = other.segments_;
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.segmentsBuilder_ = alwaysUseFieldBuilders ? this.getSegmentsFieldBuilder() : null;
                } else {
                    this.segmentsBuilder_.addAllMessages((Iterable)other.segments_);
                }
            }
            if (other.labelDetectionMode_ != 0) {
                this.setLabelDetectionModeValue(other.getLabelDetectionModeValue());
            }
            if (other.getStationaryCamera()) {
                this.setStationaryCamera(other.getStationaryCamera());
            }
            if (!other.getLabelDetectionModel().isEmpty()) {
                this.labelDetectionModel_ = other.labelDetectionModel_;
                this.onChanged();
            }
            if (!other.getFaceDetectionModel().isEmpty()) {
                this.faceDetectionModel_ = other.faceDetectionModel_;
                this.onChanged();
            }
            if (!other.getShotChangeDetectionModel().isEmpty()) {
                this.shotChangeDetectionModel_ = other.shotChangeDetectionModel_;
                this.onChanged();
            }
            if (!other.getSafeSearchDetectionModel().isEmpty()) {
                this.safeSearchDetectionModel_ = other.safeSearchDetectionModel_;
                this.onChanged();
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            VideoContext parsedMessage = null;
            try {
                parsedMessage = (VideoContext)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (VideoContext)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        private void ensureSegmentsIsMutable() {
            if ((this.bitField0_ & 1) != 1) {
                this.segments_ = new ArrayList<VideoSegment>(this.segments_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<VideoSegment> getSegmentsList() {
            if (this.segmentsBuilder_ == null) {
                return Collections.unmodifiableList(this.segments_);
            }
            return this.segmentsBuilder_.getMessageList();
        }

        @Override
        public int getSegmentsCount() {
            if (this.segmentsBuilder_ == null) {
                return this.segments_.size();
            }
            return this.segmentsBuilder_.getCount();
        }

        @Override
        public VideoSegment getSegments(int index) {
            if (this.segmentsBuilder_ == null) {
                return this.segments_.get(index);
            }
            return (VideoSegment)this.segmentsBuilder_.getMessage(index);
        }

        public Builder setSegments(int index, VideoSegment value) {
            if (this.segmentsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureSegmentsIsMutable();
                this.segments_.set(index, value);
                this.onChanged();
            } else {
                this.segmentsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setSegments(int index, VideoSegment.Builder builderForValue) {
            if (this.segmentsBuilder_ == null) {
                this.ensureSegmentsIsMutable();
                this.segments_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.segmentsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addSegments(VideoSegment value) {
            if (this.segmentsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureSegmentsIsMutable();
                this.segments_.add(value);
                this.onChanged();
            } else {
                this.segmentsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addSegments(int index, VideoSegment value) {
            if (this.segmentsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureSegmentsIsMutable();
                this.segments_.add(index, value);
                this.onChanged();
            } else {
                this.segmentsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addSegments(VideoSegment.Builder builderForValue) {
            if (this.segmentsBuilder_ == null) {
                this.ensureSegmentsIsMutable();
                this.segments_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.segmentsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addSegments(int index, VideoSegment.Builder builderForValue) {
            if (this.segmentsBuilder_ == null) {
                this.ensureSegmentsIsMutable();
                this.segments_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.segmentsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllSegments(Iterable<? extends VideoSegment> values) {
            if (this.segmentsBuilder_ == null) {
                this.ensureSegmentsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.segments_);
                this.onChanged();
            } else {
                this.segmentsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearSegments() {
            if (this.segmentsBuilder_ == null) {
                this.segments_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
            } else {
                this.segmentsBuilder_.clear();
            }
            return this;
        }

        public Builder removeSegments(int index) {
            if (this.segmentsBuilder_ == null) {
                this.ensureSegmentsIsMutable();
                this.segments_.remove(index);
                this.onChanged();
            } else {
                this.segmentsBuilder_.remove(index);
            }
            return this;
        }

        public VideoSegment.Builder getSegmentsBuilder(int index) {
            return (VideoSegment.Builder)this.getSegmentsFieldBuilder().getBuilder(index);
        }

        @Override
        public VideoSegmentOrBuilder getSegmentsOrBuilder(int index) {
            if (this.segmentsBuilder_ == null) {
                return this.segments_.get(index);
            }
            return (VideoSegmentOrBuilder)this.segmentsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends VideoSegmentOrBuilder> getSegmentsOrBuilderList() {
            if (this.segmentsBuilder_ != null) {
                return this.segmentsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.segments_);
        }

        public VideoSegment.Builder addSegmentsBuilder() {
            return (VideoSegment.Builder)this.getSegmentsFieldBuilder().addBuilder((AbstractMessage)VideoSegment.getDefaultInstance());
        }

        public VideoSegment.Builder addSegmentsBuilder(int index) {
            return (VideoSegment.Builder)this.getSegmentsFieldBuilder().addBuilder(index, (AbstractMessage)VideoSegment.getDefaultInstance());
        }

        public List<VideoSegment.Builder> getSegmentsBuilderList() {
            return this.getSegmentsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<VideoSegment, VideoSegment.Builder, VideoSegmentOrBuilder> getSegmentsFieldBuilder() {
            if (this.segmentsBuilder_ == null) {
                this.segmentsBuilder_ = new RepeatedFieldBuilderV3(this.segments_, (this.bitField0_ & 1) == 1, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.segments_ = null;
            }
            return this.segmentsBuilder_;
        }

        @Override
        public int getLabelDetectionModeValue() {
            return this.labelDetectionMode_;
        }

        public Builder setLabelDetectionModeValue(int value) {
            this.labelDetectionMode_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public LabelDetectionMode getLabelDetectionMode() {
            LabelDetectionMode result = LabelDetectionMode.valueOf(this.labelDetectionMode_);
            return result == null ? LabelDetectionMode.UNRECOGNIZED : result;
        }

        public Builder setLabelDetectionMode(LabelDetectionMode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.labelDetectionMode_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearLabelDetectionMode() {
            this.labelDetectionMode_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getStationaryCamera() {
            return this.stationaryCamera_;
        }

        public Builder setStationaryCamera(boolean value) {
            this.stationaryCamera_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearStationaryCamera() {
            this.stationaryCamera_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public String getLabelDetectionModel() {
            Object ref = this.labelDetectionModel_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.labelDetectionModel_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getLabelDetectionModelBytes() {
            Object ref = this.labelDetectionModel_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.labelDetectionModel_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setLabelDetectionModel(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.labelDetectionModel_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearLabelDetectionModel() {
            this.labelDetectionModel_ = VideoContext.getDefaultInstance().getLabelDetectionModel();
            this.onChanged();
            return this;
        }

        public Builder setLabelDetectionModelBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            VideoContext.checkByteStringIsUtf8((ByteString)value);
            this.labelDetectionModel_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getFaceDetectionModel() {
            Object ref = this.faceDetectionModel_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.faceDetectionModel_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getFaceDetectionModelBytes() {
            Object ref = this.faceDetectionModel_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.faceDetectionModel_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setFaceDetectionModel(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.faceDetectionModel_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearFaceDetectionModel() {
            this.faceDetectionModel_ = VideoContext.getDefaultInstance().getFaceDetectionModel();
            this.onChanged();
            return this;
        }

        public Builder setFaceDetectionModelBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            VideoContext.checkByteStringIsUtf8((ByteString)value);
            this.faceDetectionModel_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getShotChangeDetectionModel() {
            Object ref = this.shotChangeDetectionModel_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.shotChangeDetectionModel_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getShotChangeDetectionModelBytes() {
            Object ref = this.shotChangeDetectionModel_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.shotChangeDetectionModel_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setShotChangeDetectionModel(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.shotChangeDetectionModel_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearShotChangeDetectionModel() {
            this.shotChangeDetectionModel_ = VideoContext.getDefaultInstance().getShotChangeDetectionModel();
            this.onChanged();
            return this;
        }

        public Builder setShotChangeDetectionModelBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            VideoContext.checkByteStringIsUtf8((ByteString)value);
            this.shotChangeDetectionModel_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getSafeSearchDetectionModel() {
            Object ref = this.safeSearchDetectionModel_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.safeSearchDetectionModel_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getSafeSearchDetectionModelBytes() {
            Object ref = this.safeSearchDetectionModel_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.safeSearchDetectionModel_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setSafeSearchDetectionModel(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.safeSearchDetectionModel_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearSafeSearchDetectionModel() {
            this.safeSearchDetectionModel_ = VideoContext.getDefaultInstance().getSafeSearchDetectionModel();
            this.onChanged();
            return this;
        }

        public Builder setSafeSearchDetectionModelBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            VideoContext.checkByteStringIsUtf8((ByteString)value);
            this.safeSearchDetectionModel_ = value;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFieldsProto3(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

