/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.v2;

public interface ReadRangeOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.storage.v2.ReadRange)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The offset for the first byte to return in the read, relative to
   * the start of the object.
   *
   * A negative read_offset value will be interpreted as the number of bytes
   * back from the end of the object to be returned. For example, if an object's
   * length is 15 bytes, a ReadObjectRequest with read_offset = -5 and
   * read_length = 3 would return bytes 10 through 12 of the object. Requesting
   * a negative offset with magnitude larger than the size of the object will
   * return the entire object. A read_offset larger than the size of the object
   * will result in an OutOfRange error.
   * </pre>
   *
   * <code>int64 read_offset = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The readOffset.
   */
  long getReadOffset();

  /**
   *
   *
   * <pre>
   * Optional. The maximum number of data bytes the server is allowed to return
   * across all response messages with the same read_id. A read_length of zero
   * indicates to read until the resource end, and a negative read_length will
   * cause an error. If the stream returns fewer bytes than allowed by the
   * read_length and no error occurred, the stream includes all data from the
   * read_offset to the resource end.
   * </pre>
   *
   * <code>int64 read_length = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The readLength.
   */
  long getReadLength();

  /**
   *
   *
   * <pre>
   * Required. Read identifier provided by the client. When the client issues
   * more than one outstanding ReadRange on the same stream, responses can be
   * mapped back to their corresponding requests using this value. Clients must
   * ensure that all outstanding requests have different read_id values. The
   * server may close the stream with an error if this condition is not met.
   * </pre>
   *
   * <code>int64 read_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The readId.
   */
  long getReadId();
}
