/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.v2;

public interface BucketAccessControlOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.storage.v2.BucketAccessControl)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Optional. The access permission for the entity.
   * </pre>
   *
   * <code>string role = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The role.
   */
  java.lang.String getRole();

  /**
   *
   *
   * <pre>
   * Optional. The access permission for the entity.
   * </pre>
   *
   * <code>string role = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for role.
   */
  com.google.protobuf.ByteString getRoleBytes();

  /**
   *
   *
   * <pre>
   * Optional. The ID of the access-control entry.
   * </pre>
   *
   * <code>string id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The id.
   */
  java.lang.String getId();

  /**
   *
   *
   * <pre>
   * Optional. The ID of the access-control entry.
   * </pre>
   *
   * <code>string id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for id.
   */
  com.google.protobuf.ByteString getIdBytes();

  /**
   *
   *
   * <pre>
   * Optional. The entity holding the permission, in one of the following forms:
   * * `user-{userid}`
   * * `user-{email}`
   * * `group-{groupid}`
   * * `group-{email}`
   * * `domain-{domain}`
   * * `project-{team}-{projectnumber}`
   * * `project-{team}-{projectid}`
   * * `allUsers`
   * * `allAuthenticatedUsers`
   * Examples:
   * * The user `liz&#64;example.com` would be `user-liz&#64;example.com`.
   * * The group `example&#64;googlegroups.com` would be
   * `group-example&#64;googlegroups.com`
   * * All members of the Google Apps for Business domain `example.com` would be
   * `domain-example.com`
   * For project entities, `project-{team}-{projectnumber}` format will be
   * returned on response.
   * </pre>
   *
   * <code>string entity = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The entity.
   */
  java.lang.String getEntity();

  /**
   *
   *
   * <pre>
   * Optional. The entity holding the permission, in one of the following forms:
   * * `user-{userid}`
   * * `user-{email}`
   * * `group-{groupid}`
   * * `group-{email}`
   * * `domain-{domain}`
   * * `project-{team}-{projectnumber}`
   * * `project-{team}-{projectid}`
   * * `allUsers`
   * * `allAuthenticatedUsers`
   * Examples:
   * * The user `liz&#64;example.com` would be `user-liz&#64;example.com`.
   * * The group `example&#64;googlegroups.com` would be
   * `group-example&#64;googlegroups.com`
   * * All members of the Google Apps for Business domain `example.com` would be
   * `domain-example.com`
   * For project entities, `project-{team}-{projectnumber}` format will be
   * returned on response.
   * </pre>
   *
   * <code>string entity = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for entity.
   */
  com.google.protobuf.ByteString getEntityBytes();

  /**
   *
   *
   * <pre>
   * Output only. The alternative entity format, if exists. For project
   * entities, `project-{team}-{projectid}` format will be returned on response.
   * </pre>
   *
   * <code>string entity_alt = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The entityAlt.
   */
  java.lang.String getEntityAlt();

  /**
   *
   *
   * <pre>
   * Output only. The alternative entity format, if exists. For project
   * entities, `project-{team}-{projectid}` format will be returned on response.
   * </pre>
   *
   * <code>string entity_alt = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for entityAlt.
   */
  com.google.protobuf.ByteString getEntityAltBytes();

  /**
   *
   *
   * <pre>
   * Optional. The ID for the entity, if any.
   * </pre>
   *
   * <code>string entity_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The entityId.
   */
  java.lang.String getEntityId();

  /**
   *
   *
   * <pre>
   * Optional. The ID for the entity, if any.
   * </pre>
   *
   * <code>string entity_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for entityId.
   */
  com.google.protobuf.ByteString getEntityIdBytes();

  /**
   *
   *
   * <pre>
   * Optional. The etag of the BucketAccessControl.
   * If included in the metadata of an update or delete request message, the
   * operation operation will only be performed if the etag matches that of the
   * bucket's BucketAccessControl.
   * </pre>
   *
   * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  java.lang.String getEtag();

  /**
   *
   *
   * <pre>
   * Optional. The etag of the BucketAccessControl.
   * If included in the metadata of an update or delete request message, the
   * operation operation will only be performed if the etag matches that of the
   * bucket's BucketAccessControl.
   * </pre>
   *
   * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  com.google.protobuf.ByteString getEtagBytes();

  /**
   *
   *
   * <pre>
   * Optional. The email address associated with the entity, if any.
   * </pre>
   *
   * <code>string email = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The email.
   */
  java.lang.String getEmail();

  /**
   *
   *
   * <pre>
   * Optional. The email address associated with the entity, if any.
   * </pre>
   *
   * <code>string email = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for email.
   */
  com.google.protobuf.ByteString getEmailBytes();

  /**
   *
   *
   * <pre>
   * Optional. The domain associated with the entity, if any.
   * </pre>
   *
   * <code>string domain = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The domain.
   */
  java.lang.String getDomain();

  /**
   *
   *
   * <pre>
   * Optional. The domain associated with the entity, if any.
   * </pre>
   *
   * <code>string domain = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for domain.
   */
  com.google.protobuf.ByteString getDomainBytes();

  /**
   *
   *
   * <pre>
   * Optional. The project team associated with the entity, if any.
   * </pre>
   *
   * <code>
   * .google.storage.v2.ProjectTeam project_team = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the projectTeam field is set.
   */
  boolean hasProjectTeam();

  /**
   *
   *
   * <pre>
   * Optional. The project team associated with the entity, if any.
   * </pre>
   *
   * <code>
   * .google.storage.v2.ProjectTeam project_team = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The projectTeam.
   */
  com.google.storage.v2.ProjectTeam getProjectTeam();

  /**
   *
   *
   * <pre>
   * Optional. The project team associated with the entity, if any.
   * </pre>
   *
   * <code>
   * .google.storage.v2.ProjectTeam project_team = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.ProjectTeamOrBuilder getProjectTeamOrBuilder();
}
