/*
 * Decompiled with CFR 0.152.
 */
package com.google.spanner.admin.database.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DatabaseName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instances/{instance}/databases/{database}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String instance;
    private final String database;

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getDatabase() {
        return this.database;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DatabaseName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
    }

    public static DatabaseName of(String project, String instance, String database) {
        return DatabaseName.newBuilder().setProject(project).setInstance(instance).setDatabase(database).build();
    }

    public static String format(String project, String instance, String database) {
        return DatabaseName.newBuilder().setProject(project).setInstance(instance).setDatabase(database).build().toString();
    }

    public static DatabaseName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "DatabaseName.parse: formattedString not in valid format");
        return DatabaseName.of((String)matchMap.get("project"), (String)matchMap.get("instance"), (String)matchMap.get("database"));
    }

    public static List<DatabaseName> parseList(List<String> formattedStrings) {
        ArrayList<DatabaseName> list = new ArrayList<DatabaseName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DatabaseName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DatabaseName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DatabaseName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DatabaseName databaseName = this;
            synchronized (databaseName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    fieldMapBuilder.put((Object)"database", (Object)this.database);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "instance", this.instance, "database", this.database});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DatabaseName) {
            DatabaseName that = (DatabaseName)o;
            return this.project.equals(that.project) && this.instance.equals(that.instance) && this.database.equals(that.database);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.instance.hashCode();
        h *= 1000003;
        return h ^= this.database.hashCode();
    }

    public static class Builder {
        private String project;
        private String instance;
        private String database;

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getDatabase() {
            return this.database;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        private Builder() {
        }

        private Builder(DatabaseName databaseName) {
            this.project = databaseName.project;
            this.instance = databaseName.instance;
            this.database = databaseName.database;
        }

        public DatabaseName build() {
            return new DatabaseName(this);
        }
    }
}

