/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OrganizationSourcesName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/sources/-");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private OrganizationSourcesName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
    }

    public static OrganizationSourcesName of(String organization) {
        return OrganizationSourcesName.newBuilder().setOrganization(organization).build();
    }

    public static String format(String organization) {
        return OrganizationSourcesName.newBuilder().setOrganization(organization).build().toString();
    }

    public static OrganizationSourcesName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "OrganizationSourcesName.parse: formattedString not in valid format");
        return OrganizationSourcesName.of((String)matchMap.get("organization"));
    }

    public static List<OrganizationSourcesName> parseList(List<String> formattedStrings) {
        ArrayList<OrganizationSourcesName> list = new ArrayList<OrganizationSourcesName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OrganizationSourcesName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OrganizationSourcesName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OrganizationSourcesName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OrganizationSourcesName organizationSourcesName = this;
            synchronized (organizationSourcesName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"organization", this.organization});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OrganizationSourcesName) {
            OrganizationSourcesName that = (OrganizationSourcesName)o;
            return this.organization.equals(that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.organization.hashCode();
    }

    public static class Builder {
        private String organization;

        public String getOrganization() {
            return this.organization;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        private Builder() {
        }

        private Builder(OrganizationSourcesName organizationSourcesName) {
            this.organization = organizationSourcesName.organization;
        }

        public OrganizationSourcesName build() {
            return new OrganizationSourcesName(this);
        }
    }
}

