/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.secretmanager.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SecretName
implements ResourceName {
    private static final PathTemplate PROJECT_SECRET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/secrets/{secret}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String secret;

    @Deprecated
    protected SecretName() {
        this.project = null;
        this.secret = null;
    }

    private SecretName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.secret = (String)Preconditions.checkNotNull((Object)builder.getSecret());
    }

    public String getProject() {
        return this.project;
    }

    public String getSecret() {
        return this.secret;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SecretName of(String project, String secret) {
        return SecretName.newBuilder().setProject(project).setSecret(secret).build();
    }

    public static String format(String project, String secret) {
        return SecretName.newBuilder().setProject(project).setSecret(secret).build().toString();
    }

    public static SecretName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_SECRET.validatedMatch(formattedString, "SecretName.parse: formattedString not in valid format");
        return SecretName.of((String)matchMap.get("project"), (String)matchMap.get("secret"));
    }

    public static List<SecretName> parseList(List<String> formattedStrings) {
        ArrayList<SecretName> list = new ArrayList<SecretName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SecretName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SecretName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SecretName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SECRET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SecretName secretName = this;
            synchronized (secretName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.secret != null) {
                        fieldMapBuilder.put((Object)"secret", (Object)this.secret);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_SECRET.instantiate(new String[]{"project", this.project, "secret", this.secret});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SecretName that = (SecretName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.secret, that.secret);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.secret);
    }

    public static class Builder {
        private String project;
        private String secret;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getSecret() {
            return this.secret;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSecret(String secret) {
            this.secret = secret;
            return this;
        }

        private Builder(SecretName secretName) {
            this.project = secretName.project;
            this.secret = secretName.secret;
        }

        public SecretName build() {
            return new SecretName(this);
        }
    }
}

