/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

package com.google.pubsub.v1;

public interface TopicOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.pubsub.v1.Topic)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The name of the topic. It must have the format
   * `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
   * and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
   * underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
   * signs (`%`). It must be between 3 and 255 characters in length, and it
   * must not start with `"goog"`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Required. The name of the topic. It must have the format
   * `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
   * and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
   * underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
   * signs (`%`). It must be between 3 and 255 characters in length, and it
   * must not start with `"goog"`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * See &lt;a href="https://cloud.google.com/pubsub/docs/labels"&gt; Creating and
   * managing labels&lt;/a&gt;.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * See &lt;a href="https://cloud.google.com/pubsub/docs/labels"&gt; Creating and
   * managing labels&lt;/a&gt;.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * See &lt;a href="https://cloud.google.com/pubsub/docs/labels"&gt; Creating and
   * managing labels&lt;/a&gt;.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * See &lt;a href="https://cloud.google.com/pubsub/docs/labels"&gt; Creating and
   * managing labels&lt;/a&gt;.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * See &lt;a href="https://cloud.google.com/pubsub/docs/labels"&gt; Creating and
   * managing labels&lt;/a&gt;.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Policy constraining the set of Google Cloud Platform regions where messages
   * published to the topic may be stored. If not present, then no constraints
   * are in effect.
   * </pre>
   *
   * <code>.google.pubsub.v1.MessageStoragePolicy message_storage_policy = 3;</code>
   *
   * @return Whether the messageStoragePolicy field is set.
   */
  boolean hasMessageStoragePolicy();
  /**
   *
   *
   * <pre>
   * Policy constraining the set of Google Cloud Platform regions where messages
   * published to the topic may be stored. If not present, then no constraints
   * are in effect.
   * </pre>
   *
   * <code>.google.pubsub.v1.MessageStoragePolicy message_storage_policy = 3;</code>
   *
   * @return The messageStoragePolicy.
   */
  com.google.pubsub.v1.MessageStoragePolicy getMessageStoragePolicy();
  /**
   *
   *
   * <pre>
   * Policy constraining the set of Google Cloud Platform regions where messages
   * published to the topic may be stored. If not present, then no constraints
   * are in effect.
   * </pre>
   *
   * <code>.google.pubsub.v1.MessageStoragePolicy message_storage_policy = 3;</code>
   */
  com.google.pubsub.v1.MessageStoragePolicyOrBuilder getMessageStoragePolicyOrBuilder();

  /**
   *
   *
   * <pre>
   * The resource name of the Cloud KMS CryptoKey to be used to protect access
   * to messages published on this topic.
   * The expected format is `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
   * </pre>
   *
   * <code>string kms_key_name = 5;</code>
   *
   * @return The kmsKeyName.
   */
  java.lang.String getKmsKeyName();
  /**
   *
   *
   * <pre>
   * The resource name of the Cloud KMS CryptoKey to be used to protect access
   * to messages published on this topic.
   * The expected format is `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
   * </pre>
   *
   * <code>string kms_key_name = 5;</code>
   *
   * @return The bytes for kmsKeyName.
   */
  com.google.protobuf.ByteString getKmsKeyNameBytes();
}
